---
generated_at: 2026-02-11 19:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：59-会場編集画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり
  2. Google Maps連携の動作確認
  3. FCKeditor連携の動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/views/scripts/events/venue.phtml` (1-216行目)
- E-02: `application/modules/admin/controllers/EventsController.php` (1384-1416行目 venueAction)
- E-03: `application/modules/admin/controllers/EventsController.php` (1639-1787行目 venuesaveAction)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (59行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (127行目)
- E-06: `_scripts/admin/venue.js` (地図マーカー操作処理)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL は /admin/events/venue/id/{id} | E-02 (venueAction) | ○ |
| C-02 | 画面アクセスにはeeventsとevenueedit権限が必要 | E-02 (1386行目) | ○ |
| C-03 | 会場が存在しない場合はvenuesにリダイレクト | E-02 (1406-1408行目) | ○ |
| C-04 | 入力項目はtitle, latitude, longitude, address, city, country, description, url, email, phoneの10項目 | E-01 (51-210行目), E-03 (1656-1691行目) | ○ |
| C-05 | title, latitude, longitude, address, city, countryはNotEmptyバリデーション | E-03 (1656-1687行目) | ○ |
| C-06 | description, url, email, phoneはallowEmpty | E-03 (1662, 1688-1690行目) | ○ |
| C-07 | Google Maps APIで地図を表示 | E-01 (29行目, 67行目) | ○ |
| C-08 | マーカードラッグで位置調整可能 | E-01 (71行目), E-06 | ○ |
| C-09 | FCKeditorで説明文を編集 | E-01 (38行目, 149-157行目) | ○ |
| C-10 | URLフィールドはURL形式の正規表現バリデーション | E-01 (173行目) | ○ |
| C-11 | メールフィールドはEmail形式の正規表現バリデーション | E-01 (190行目) | ○ |
| C-12 | 保存成功時にVenue Savedメッセージ表示 | E-03 (1750行目) | ○ |
| C-13 | 公開済み会場の場合は検索インデックスを更新 | E-03 (1729-1746行目) | ○ |
| C-14 | 会場詳細画面をContentPaneで読み込み | E-01 (42行目) | ○ |
| C-15 | TabContainerでVenueタブを表示 | E-01 (44-45行目) | ○ |
| C-16 | ValidationTextBoxを会場名と都市に使用 | E-01 (51-62行目, 112-123行目) | ○ |
| C-17 | FilteringSelectを国選択に使用 | E-01 (127-139行目) | ○ |
| C-18 | 権限不足時はprivilegesにフォワード | E-02 (1412行目), E-03 (1783行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 編集フォームの実装
- 0: 低リスク - バリデーション処理
- 0: 低リスク - Google Maps連携
- 0: 低リスク - FCKeditor連携

## 6) レビュアーチェックリスト（最小）
- [ ] venue.phtmlのフォーム構造がvenueArrayの構造と一致しているか確認
- [ ] 各Dojoウィジェットが正しく動作するか確認
- [ ] Google Mapsのマーカードラッグで緯度・経度フィールドが更新されるか確認
- [ ] FCKeditorの値が保存時に正しく取得されるか確認（MyFCKObject.UpdateEditorFormValue）
- [ ] URL・メールフィールドの正規表現バリデーションが正しく動作するか確認
- [ ] 公開済み会場の保存時に検索インデックスが更新されるか確認
