---
generated_at: 2026-02-11 19:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-ページ管理画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり
  2. フィルタ機能の動作確認
  3. ソート機能の動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/views/scripts/pages/manage.phtml` (1-142行目)
- E-02: `application/modules/admin/controllers/PagesController.php` (29-49行目 manageAction)
- E-03: `application/modules/admin/controllers/PagesController.php` (81-121行目 deleteAction)
- E-04: `application/models/Pages.php` (39-77行目 getFilter)
- E-05: `application/models/Pages.php` (84-140行目 fetchPages)
- E-06: `application/models/Pages.php` (187-201行目 deletePage)
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` (60行目)
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (128行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL は /admin/pages/manage | E-02 (manageAction) | ○ |
| C-02 | 画面アクセスにはppages権限が必要 | E-02 (31行目) | ○ |
| C-03 | 15件/ページでページネーション | E-02 (33行目) | ○ |
| C-04 | ページ範囲は5 | E-02 (34行目) | ○ |
| C-05 | PagesモデルでgetFilterを呼び出し | E-02 (40行目), E-04 | ○ |
| C-06 | PagesモデルでfetchPagesを呼び出し | E-02 (41行目), E-05 | ○ |
| C-07 | New Pageボタンはppagenew権限で表示 | E-01 (37行目) | ○ |
| C-08 | Editリンクはppageedit権限で表示 | E-01 (110行目) | ○ |
| C-09 | Deleteリンクはppagedelete権限かつ非保護で表示 | E-01 (110行目) | ○ |
| C-10 | フィルタ未適用時は「No active filter」表示 | E-01 (50行目) | ○ |
| C-11 | ページが存在しない場合は「No Pages!」表示 | E-01 (128行目) | ○ |
| C-12 | ページ名リンクで編集画面に遷移 | E-01 (109行目) | ○ |
| C-13 | 作成者リンクでフィルタリング | E-01 (112行目) | ○ |
| C-14 | フィルタタグクリックで解除 | E-01 (47-49行目 onClick goTo) | ○ |
| C-15 | デフォルトソートはdate降順 | E-04 (59-61行目、72-73行目), E-05 (89、113行目) | ○ |
| C-16 | ソート対象はpage, author, slug, date | E-05 (102-110行目) | ○ |
| C-17 | pagesテーブルとusersテーブルをJOIN | E-05 (93-94行目) | ○ |
| C-18 | 権限不足時はprivilegesにフォワード | E-02 (45行目) | ○ |
| C-19 | 保護ページは鍵アイコンで表示 | E-01 (104-106行目) | ○ |
| C-20 | 削除時はタグと検索インデックスも削除 | E-06 (191-195行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ページ一覧表示の実装
- 0: 低リスク - 権限チェックの実装
- 0: 低リスク - フィルタ機能の実装
- 0: 低リスク - ソート機能の実装

## 6) レビュアーチェックリスト（最小）
- [ ] manage.phtmlの表示内容がpagesArrayの構造と一致しているか確認
- [ ] フィルタ（author）が正しく動作するか確認
- [ ] ソート（page、author、slug、date）が正しく動作するか確認
- [ ] ソート順切替（asc/desc）が正しく動作するか確認
- [ ] フィルタ解除（タグクリック）が正しく動作するか確認
- [ ] 保護ページ（page_protected='Y'）の削除リンクが非表示になっているか確認
- [ ] ページネーションが正しく動作するか確認
