---
generated_at: 2026-02-11 19:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：61-ページ編集画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **検索インデックスの更新処理**：Search.phpの実装詳細が未確認
  2. **タグ管理パーシャルの詳細動作**：tagspane.phtmlの完全な解析が未実施

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/PagesController.php` - editAction(), saveAction(), deleteAction(), publishAction(), detailsAction()
- E-02: `application/models/Pages.php` - fetchPage(), updatePage(), updatePageStatus(), deletePage()
- E-03: `application/modules/admin/views/scripts/pages/edit.phtml` - 編集フォームUI定義
- E-04: `application/modules/admin/views/scripts/pages/details.phtml` - 詳細パネルUI定義
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.61の定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連機能の定義
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは/admin/pages/edit/id/{page_id}/ | E-01 (58行目) | ○ |
| C-02 | ppagesとppageedit権限が必要 | E-01 (56行目) | ○ |
| C-03 | Pagesモデルでページデータを取得 | E-01 (63-64行目), E-02 (146行目) | ○ |
| C-04 | FCKeditorでリッチテキスト編集 | E-03 (67-74行目) | ○ |
| C-05 | タイトルは必須入力 | E-01 (141-146行目), E-03 (48-59行目) | ○ |
| C-06 | スラッグは英数字のみ、一意性チェック | E-01 (152-158行目) | ○ |
| C-07 | 保護されたページはスラッグ・セクションが読み取り専用 | E-03 (94, 112行目) | ○ |
| C-08 | 保護されたページは削除ボタン非表示 | E-04 (32-34行目) | ○ |
| C-09 | 保存時にpagesテーブルをUPDATE | E-02 (207-217行目) | ○ |
| C-10 | 公開済みページ保存時に検索インデックス更新 | E-02 (221-236行目) | ○ |
| C-11 | 削除時にタグも削除 | E-02 (191-192行目) | ○ |
| C-12 | 削除時に検索インデックスから削除 | E-02 (194-195行目) | ○ |
| C-13 | 公開時にpage_statusをpublishedに更新 | E-01 (260-262行目), E-02 (243-251行目) | ○ |
| C-14 | Ajaxダイアログで保存結果を表示 | E-04 (31行目), E-01 (174-179行目) | ○ |
| C-15 | ページIDが無効な場合は一覧へリダイレクト | E-01 (66-68行目) | ○ |
| C-16 | 権限不足時は権限エラー画面へフォワード | E-01 (72行目) | ○ |
| C-17 | page_editカラムをNOW()で更新 | E-02 (214行目) | ○ |
| C-18 | page_publishedカラムを公開時にNOW()で更新 | E-02 (247行目) | ○ |
| C-19 | タグ管理は別タブで実施 | E-03 (121行目) | ○ |
| C-20 | 詳細パネルはAjaxで読み込み | E-03 (39行目) | ○ |
| C-21 | 著者名、ステータス、作成日時等を詳細パネルに表示 | E-04 (14-22行目) | ○ |
| C-22 | 下書き状態でのみPublishボタン表示 | E-04 (35-37行目) | ○ |
| C-23 | Dojo Toolkitのウィジェットを使用 | E-03 (9-18行目) | ○ |
| C-24 | html_entity_decode()でコンテンツをデコード | E-02 (211行目) | ○ |
| C-25 | Zend_Filter_Inputでバリデーション | E-01 (141-162行目) | ○ |
| C-26 | Search.phpで検索インデックスを管理 | E-02 (227行目) | △ |
| C-27 | tagspane.phtmlでタグ管理UI提供 | E-03 (121行目) | △ |
| C-28 | サイトURLとスラッグを連結してURL表示 | E-03 (81行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- Search.phpの実装詳細が未確認のため、検索インデックス更新の正確な動作が不明
  - 候補：application/models/Search.php / Zend_Search_Lucene関連ファイル
- tagspane.phtmlの完全な解析が実施されていない
  - 候補：application/modules/admin/views/scripts/_partials/tagspane.phtml / tags.js

## 5) リスクフラグ（レビュー観点）
- 0: FCKeditorのセキュリティリスク（レガシーエディタ）- ドキュメントに記載済み
- 1: 検索インデックス更新失敗時のエラーハンドリングが不明確
- 0: 保護されたページの定義基準が不明（page_protectedの設定契機）

## 6) レビュアーチェックリスト（最小）
- [ ] saveAction()のバリデーションルールがフォーム要件と一致しているか確認
- [ ] 検索インデックス更新処理のエラーハンドリングを確認
- [ ] 保護されたページ（page_protected = 'Y'）の設定条件を確認
- [ ] FCKeditorのXSS対策が適切か確認
- [ ] タグ管理機能の動作を実機で確認
