---
generated_at: 2026-02-11 19:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：63-ページ詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先度の高いレビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/PagesController.php` - detailsAction()（313-330行目）
- E-02: `application/models/Pages.php` - fetchPage()（146-160行目）
- E-03: `application/modules/admin/views/scripts/pages/details.phtml` - 詳細パネルUI定義
- E-04: `application/modules/admin/views/scripts/pages/edit.phtml` - ContentPaneによる読み込み（39行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.63の定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連機能の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは/admin/pages/details?id={page_id} | E-04 (39行目), E-01 (319行目) | ○ |
| C-02 | ppagesとppageedit権限が必要 | E-01 (315行目) | ○ |
| C-03 | レイアウトが無効化される | E-01 (317行目) | ○ |
| C-04 | Pagesモデルでページデータを取得 | E-01 (321-323行目), E-02 | ○ |
| C-05 | 著者名を表示 | E-03 (14行目) | ○ |
| C-06 | ステータスをucwords()で整形して表示 | E-03 (15行目) | ○ |
| C-07 | 作成日時をd/m/Y H:i形式で表示 | E-03 (17行目) | ○ |
| C-08 | 公開日時は公開済みの場合のみ表示 | E-03 (18-20行目) | ○ |
| C-09 | 最終編集日時を表示 | E-03 (21行目) | ○ |
| C-10 | SaveボタンはpostDialog()を使用 | E-03 (31行目) | ○ |
| C-11 | Saveボタンは/admin/pages/save/を呼び出す | E-03 (31行目) | ○ |
| C-12 | Deleteボタンは保護されていない場合のみ表示 | E-03 (32-34行目) | ○ |
| C-13 | DeleteボタンはgetDialog()を使用 | E-03 (33行目) | ○ |
| C-14 | Publishボタンは下書き状態の場合のみ表示 | E-03 (35-37行目) | ○ |
| C-15 | PublishボタンはgetDialog()を使用 | E-03 (36行目) | ○ |
| C-16 | Pages...ボタンはgoTo()を使用 | E-03 (38行目) | ○ |
| C-17 | Pages...ボタンは/admin/pages/へ遷移 | E-03 (38行目) | ○ |
| C-18 | ContentPaneで自動的にAjax読み込み | E-04 (39行目) | ○ |
| C-19 | preload="true"で即時読み込み | E-04 (39行目) | ○ |
| C-20 | MakeDate()ビューヘルパーで日時整形 | E-03 (17, 19, 21行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。本画面はシンプルなパーシャルビューであり、すべての主張がソースコードで確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: ページIDが無効な場合のエラーハンドリングが明示的でない（空のレスポンスが返る）
- 0: FCKeditorの更新（MyFCKObject.UpdateEditorFormValue()）は親画面依存

## 6) レビュアーチェックリスト（最小）
- [ ] ページが存在しない場合の表示を確認
- [ ] 権限不足時の動作を確認
- [ ] FCKeditorとの連携が正常に動作することを確認
