---
generated_at: 2026-02-11 19:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：64-メール管理画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **mgetTo()ビューヘルパーの実装詳細**：宛先表示の変換ロジックが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/MailController.php` - manageAction()（29-50行目）
- E-02: `application/models/Mail.php` - getFilter(), fetchMails(), fetchGroups()
- E-03: `application/modules/admin/views/scripts/mail/manage.phtml` - メール管理画面UI定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.64の定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連機能の定義
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは/admin/mail/manage/ | E-01 (29行目) | ○ |
| C-02 | indexActionからmanageへリダイレクト | E-01 (22-24行目) | ○ |
| C-03 | mmail権限が必要 | E-01 (31行目) | ○ |
| C-04 | 1ページあたり15件表示 | E-01 (33行目), E-02 (193-196行目) | ○ |
| C-05 | ページ範囲は5 | E-01 (34行目), E-02 (199-202行目) | ○ |
| C-06 | Mail->getFilter()でフィルタを取得 | E-01 (40行目), E-02 (39-127行目) | ○ |
| C-07 | Mail->fetchMails()でメール一覧を取得 | E-01 (41行目), E-02 (134-211行目) | ○ |
| C-08 | Mail->fetchGroups()でグループ一覧を取得 | E-01 (42行目), E-02 (217-224行目) | ○ |
| C-09 | New Mailはドロップダウンメニュー | E-03 (39-45行目) | ○ |
| C-10 | メーリングリスト宛は/admin/mail/maillist/ | E-03 (42行目) | ○ |
| C-11 | ロール宛は/admin/mail/mailrole/ | E-03 (43行目) | ○ |
| C-12 | New Mailing ListはurolenewではなくuroleneW権限で表示 | E-03 (46行目) | ○ |
| C-13 | 新規リストは/admin/mail/groupnew/ | E-03 (46行目) | ○ |
| C-14 | ステータスフィルタはsent/draft | E-03 (77-78行目), E-02 (99-105行目) | ○ |
| C-15 | メーリングリストはグループとして管理 | E-02 (217-224行目), E-03 (88-106行目) | ○ |
| C-16 | 鍵アイコンはクローズドリストを示す | E-03 (92, 94行目) | ○ |
| C-17 | ID=1のリストは削除不可 | E-03 (98行目), E-01 (1334行目) | ○ |
| C-18 | 右クリックでコンテキストメニュー表示 | E-03 (97-102行目) | ○ |
| C-19 | メール一覧はテーブル表示 | E-03 (115-174行目) | ○ |
| C-20 | ソート可能なカラムはSubject, Author, Date | E-03 (117, 127, 136行目) | ○ |
| C-21 | mgetTo()で宛先を変換表示 | E-03 (154行目) | △ |
| C-22 | mmaildelete権限と送信済みでない条件で削除リンク表示 | E-03 (152行目) | ○ |
| C-23 | Zend_Paginatorでページネーション | E-02 (205-208行目), E-03 (178行目) | ○ |
| C-24 | cycle()でテーブル行の背景色を交互に | E-03 (148行目) | ○ |
| C-25 | マウスオーバーでEdit/Deleteリンク表示 | E-03 (149, 152行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- mgetTo()ビューヘルパーの実装詳細が未確認のため、宛先表示の変換ロジックが不明
  - 候補：application/modules/admin/views/helpers/MgetTo.php / ビューヘルパーディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: mgetTo()ヘルパーの実装が確認できない
- 0: MStatusCount(), MGroupCount()ヘルパーの実装詳細が未確認
- 1: urolenewの権限名がNew Mailing List機能に使用されている点が不自然（命名の問題）

## 6) レビュアーチェックリスト（最小）
- [ ] mgetTo()ビューヘルパーの実装を確認
- [ ] MStatusCount()、MGroupCount()ヘルパーの実装を確認
- [ ] urolenew権限がNew Mailing List機能に適切か確認
- [ ] メール送信タイプ（G/R/U）の表示が正しいか確認
