---
generated_at: 2026-02-11 19:20:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：65-メール編集画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **添付ファイルの実装詳細**：Attachments.phpの詳細な解析が未実施

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/MailController.php` - editAction(), saveAction(), sendAction(), sendtestAction(), deleteAction()
- E-02: `application/models/Mail.php` - fetchMail(), updateMail()
- E-03: `application/modules/admin/views/scripts/mail/edit.phtml` - 編集画面UI定義
- E-04: `application/modules/admin/views/scripts/mail/details.phtml` - 詳細パネルUI定義
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.65の定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連機能の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは/admin/mail/edit/id/{mail_id}/ | E-01 (224行目) | ○ |
| C-02 | uusersとuview権限が必要 | E-01 (222行目) | ○ |
| C-03 | Mailモデルでメールデータを取得 | E-01 (226-227行目), E-02 (270-284行目) | ○ |
| C-04 | メールが存在しない場合は一覧へリダイレクト | E-01 (229-231行目) | ○ |
| C-05 | 3種類の送信タイプ（G/R/U） | E-03 (53-88行目) | ○ |
| C-06 | タイプGはメーリングリスト選択 | E-03 (53-63行目) | ○ |
| C-07 | タイプRはロール選択 | E-03 (64-74行目) | ○ |
| C-08 | タイプUはユーザー表示（読み取り専用） | E-03 (75-88行目) | ○ |
| C-09 | FCKeditorでHTML本文編集 | E-03 (125-133行目) | ○ |
| C-10 | Attachmentsタブで添付ファイル管理 | E-03 (144-180行目) | ○ |
| C-11 | 送信済みの場合は添付ファイル追加不可 | E-03 (148行目) | ○ |
| C-12 | SaveボタンはpostDialog()を使用 | E-04 (34行目) | ○ |
| C-13 | Deleteボタンはmmaildelete権限が必要 | E-04 (35行目) | ○ |
| C-14 | Send TestボタンはmmailsendとgetDialog()を使用 | E-04 (37行目) | ○ |
| C-15 | SendボタンはmmailsendとgetDialog()を使用 | E-04 (38行目) | ○ |
| C-16 | 送信済みの場合はSave/Delete/Send系ボタン非表示 | E-04 (33, 39行目) | ○ |
| C-17 | saveAction()でバリデーション実行 | E-01 (66-102行目) | ○ |
| C-18 | updateMail()でmailテーブルを更新 | E-01 (113-118行目), E-02 (406-418行目) | ○ |
| C-19 | 送信済みメールの保存はエラー | E-01 (111, 127-135行目) | ○ |
| C-20 | テスト送信は現在のユーザー宛 | E-01 (591行目) | ○ |
| C-21 | グループ宛送信はfetchSubscriptions()で購読者取得 | E-01 (780-781行目) | ○ |
| C-22 | ロール宛送信はfetchUsers()でユーザー取得 | E-01 (891行目) | ○ |
| C-23 | テキスト/HTML両方ある場合は分けて送信 | E-01 (778-831行目) | ○ |
| C-24 | 添付ファイルはfile_get_contents()で読み込み | E-01 (596行目) | ○ |
| C-25 | 削除時は関連添付ファイルも削除 | E-02 (352-366行目) | ○ |
| C-26 | html_entity_decode()でHTML本文をデコード | E-01 (117行目), E-02 (413行目) | ○ |
| C-27 | StripTagsフィルタでテキスト本文を処理 | E-01 (78-82行目) | ○ |
| C-28 | 詳細パネルはAjaxで読み込み | E-03 (45行目) | ○ |
| C-29 | attachmentTab()でAttachments初期化 | E-03 (27行目) | ○ |
| C-30 | Attachments.phpで添付ファイル操作 | E-01 (568-571行目) | △ |

## 4) 不足情報（Unknown / Missing）
- Attachments.phpの詳細な実装が未確認のため、添付ファイル操作の完全な動作が不明
  - 候補：application/models/Attachments.php / AttachmentsController.php

## 5) リスクフラグ（レビュー観点）
- 1: メール送信処理が非常に長く複雑（sendAction()が約450行）
- 1: BCCを使用した一括送信は大量メール時にパフォーマンス問題の可能性
- 0: FCKeditorのセキュリティリスク（レガシーエディタ）
- 0: file_get_contents()による添付ファイル読み込みはメモリ使用量に注意

## 6) レビュアーチェックリスト（最小）
- [ ] 権限チェック（uusersとuview）がeditAction以外のアクションでも適切か確認
- [ ] 大量の購読者へのBCC送信時のパフォーマンスを確認
- [ ] 添付ファイルのファイルサイズ制限を確認
- [ ] メール送信失敗時のエラーハンドリングを確認
- [ ] Attachments.phpの実装詳細を確認
