---
generated_at: 2026-02-11 19:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-メール詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先度の高いレビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/MailController.php` - detailsAction()（243-259行目）
- E-02: `application/models/Mail.php` - fetchMail()（270-284行目）
- E-03: `application/modules/admin/views/scripts/mail/details.phtml` - 詳細パネルUI定義
- E-04: `application/modules/admin/views/scripts/mail/edit.phtml` - ContentPaneによる読み込み（45行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.66の定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連機能の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは/admin/mail/details?id={mail_id} | E-04 (45行目), E-01 (249行目) | ○ |
| C-02 | uusersとuview権限が必要 | E-01 (245行目) | ○ |
| C-03 | レイアウトが無効化される | E-01 (247行目) | ○ |
| C-04 | Mailモデルでメールデータを取得 | E-01 (251-252行目), E-02 | ○ |
| C-05 | 著者名を表示 | E-03 (15行目) | ○ |
| C-06 | ステータスをucwords()で整形して表示 | E-03 (16行目) | ○ |
| C-07 | 送信済みの場合は送信日時を表示 | E-03 (18-19行目) | ○ |
| C-08 | 下書きの場合は最終編集日時を表示 | E-03 (20-21行目) | ○ |
| C-09 | 送信済みの場合はSave/Delete/Send系ボタン非表示 | E-03 (33, 39行目) | ○ |
| C-10 | SaveボタンはpostDialog()を使用 | E-03 (34行目) | ○ |
| C-11 | Saveボタンは/admin/mail/save/を呼び出す | E-03 (34行目) | ○ |
| C-12 | DeleteボタンはmmaildeleteのACLチェック | E-03 (35行目) | ○ |
| C-13 | DeleteボタンはgetDialog()を使用 | E-03 (35行目) | ○ |
| C-14 | Send TestボタンはmmailsendのACLチェック | E-03 (36行目) | ○ |
| C-15 | Send TestボタンはgetDialog()を使用 | E-03 (37行目) | ○ |
| C-16 | SendボタンはmmailsendのACLチェック | E-03 (36行目) | ○ |
| C-17 | SendボタンはgetDialog()を使用 | E-03 (38行目) | ○ |
| C-18 | Mail...ボタンはgoTo()を使用 | E-03 (40行目) | ○ |
| C-19 | Mail...ボタンは/admin/mail/へ遷移 | E-03 (40行目) | ○ |
| C-20 | ContentPaneで自動的にAjax読み込み | E-04 (45行目) | ○ |
| C-21 | preload="true"で即時読み込み | E-04 (45行目) | ○ |
| C-22 | MakeDate()ビューヘルパーで日時整形 | E-03 (19, 21行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。本画面はシンプルなパーシャルビューであり、すべての主張がソースコードで確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: メールIDが無効な場合のエラーハンドリングが明示的でない（空のレスポンスが返る）
- 0: FCKeditorの更新（MyFCKObject.UpdateEditorFormValue()）は親画面依存

## 6) レビュアーチェックリスト（最小）
- [ ] メールが存在しない場合の表示を確認
- [ ] 権限不足時の動作を確認
- [ ] FCKeditorとの連携が正常に動作することを確認
