---
generated_at: 2026-02-11 19:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-グループ管理画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先度の高いレビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/MailController.php` - groupAction()（1163-1182行目）
- E-02: `application/modules/admin/controllers/MailController.php` - groupsaveAction()（1208-1327行目）
- E-03: `application/modules/admin/controllers/MailController.php` - groupdeleteAction()（1332-1378行目）
- E-04: `application/modules/admin/controllers/MailController.php` - grouppublishAction()（1380-1428行目）
- E-05: `application/models/Mail.php` - fetchGroup()（290-304行目）
- E-06: `application/models/Mail.php` - updateGroup()（424-442行目）
- E-07: `application/models/Mail.php` - deleteGroup()（372-392行目）
- E-08: `application/modules/admin/views/scripts/mail/group.phtml` - 編集画面UI定義
- E-09: `application/modules/admin/views/scripts/mail/groupdetails.phtml` - 詳細パネルUI定義
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.67の定義
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連機能の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは/admin/mail/group/id/{mgroup_id}/ | E-01 (1167行目) | ○ |
| C-02 | mmailとmlistedit権限が必要 | E-01 (1165行目) | ○ |
| C-03 | Mailモデルでグループデータを取得 | E-01 (1169-1170行目), E-05 | ○ |
| C-04 | グループが存在しない場合は一覧へリダイレクト | E-01 (1172-1174行目) | ○ |
| C-05 | タイトル入力はValidationTextBox使用 | E-08 (47-52行目) | ○ |
| C-06 | 説明入力はSimpleTextarea使用 | E-08 (59-63行目) | ○ |
| C-07 | タイプ選択はY=オープン、N=クローズド | E-08 (69-77行目) | ○ |
| C-08 | デフォルト購読チェックボックスあり | E-08 (83-90行目) | ○ |
| C-09 | テキストテンプレートはSimpleTextarea使用 | E-08 (110-115行目) | ○ |
| C-10 | HTMLテンプレートはFCKeditor使用 | E-08 (121-130行目) | ○ |
| C-11 | 保存ボタンはpostDialog()でgroupsaveを呼び出し | E-09 (27行目) | ○ |
| C-12 | 削除ボタンはmlistdelete権限が必要 | E-09 (28行目) | ○ |
| C-13 | 削除ボタンはID=1以外のみ表示 | E-09 (28行目) | ○ |
| C-14 | 公開ボタンはmlistpublish権限が必要 | E-09 (31行目) | ○ |
| C-15 | 公開ボタンはステータスがpublishedでない場合のみ表示 | E-09 (31行目) | ○ |
| C-16 | groupsaveAction()でバリデーション実行 | E-02 (1221-1272行目) | ○ |
| C-17 | タイトルは英数字のみ許可 | E-02 (1233-1237行目) | ○ |
| C-18 | タイトル重複チェックあり | E-02 (1256-1268行目) | ○ |
| C-19 | updateGroup()でmail_groupsテーブル更新 | E-02 (1282-1289行目), E-06 | ○ |
| C-20 | html_entity_decode()でHTMLをデコード | E-06 (437行目) | ○ |
| C-21 | 削除時は関連メールを既定リスト（ID=1）に移動 | E-07 (378-381行目) | ○ |
| C-22 | 削除時は購読情報を削除 | E-07 (384-387行目) | ○ |
| C-23 | ID=1のグループは削除不可 | E-03 (1346-1348行目) | ○ |
| C-24 | 公開時はステータスをpublishedに更新 | E-04 (1414-1420行目) | ○ |
| C-25 | MGroupCount()で投稿数を取得 | E-08 (4行目), E-09 (11行目) | ○ |
| C-26 | MSubscriberCount()で購読者数を取得 | E-08 (5行目), E-09 (13行目) | ○ |
| C-27 | Mail...ボタンはgoTo()で/admin/mail/へ遷移 | E-09 (34行目) | ○ |
| C-28 | 詳細パネルはAjax（ContentPane）で読み込み | E-08 (35-36行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。本画面はメーリングリスト編集機能であり、すべての主張がソースコードで確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: オープン/クローズドリストの権限制御が適切か確認が必要
- 0: デフォルト購読設定の新規ユーザーへの反映タイミング
- 0: テンプレートの変更が既存メールに影響しないことの確認

## 6) レビュアーチェックリスト（最小）
- [ ] ID=1の削除防止ロジックが適切に機能するか確認
- [ ] タイトルの英数字バリデーションが適切か確認
- [ ] 削除時の関連メール移動が正常に動作するか確認
- [ ] オープン/クローズドリストの挙動差を確認
