---
generated_at: 2026-02-11 19:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-グループ新規作成画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先度の高いレビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/MailController.php` - groupnewAction()（1520-1597行目）
- E-02: `application/models/Mail.php` - newGroup()（334-346行目）
- E-03: `application/modules/admin/views/scripts/mail/groupnew.phtml` - 新規作成フォームUI定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.68の定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連機能の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは/admin/mail/groupnew/ | E-03 (47行目), E-01 (1520行目) | ○ |
| C-02 | mmailとmlistnew権限が必要 | E-01 (1522行目) | ○ |
| C-03 | レイアウトが無効化される | E-01 (1524行目) | ○ |
| C-04 | タイトル入力はValidationTextBox使用 | E-03 (14-25行目) | ○ |
| C-05 | タイプ選択はFilteringSelect使用 | E-03 (29-38行目) | ○ |
| C-06 | タイプ選択はY=オープン、N=クローズド | E-03 (36-37行目) | ○ |
| C-07 | CreateボタンはdoDialog()を使用 | E-03 (47行目) | ○ |
| C-08 | Cancelボタンはダイアログを閉じる | E-03 (52-53行目) | ○ |
| C-09 | バリデーションでタイトル必須チェック | E-01 (1543-1549行目) | ○ |
| C-10 | バリデーションでタイトル英数字チェック | E-01 (1546行目) | ○ |
| C-11 | バリデーションでタイトル重複チェック | E-01 (1547行目) | ○ |
| C-12 | バリデーションでタイプ必須チェック | E-01 (1550-1554行目) | ○ |
| C-13 | newGroup()でmail_groupsにINSERT | E-01 (1561-1564行目), E-02 (337-342行目) | ○ |
| C-14 | 成功時は「Mailing List Created」メッセージ | E-01 (1567行目) | ○ |
| C-15 | 成功時はCloseボタンを表示 | E-01 (1570行目) | ○ |
| C-16 | Closeボタンはダイアログを閉じて画面リロード | E-01 (1570行目) | ○ |
| C-17 | posted == 'N'の場合のみフォーム表示 | E-03 (9行目) | ○ |
| C-18 | エラー時はフォームを再表示 | E-01 (1573-1583行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。本画面はシンプルな新規作成ダイアログであり、すべての主張がソースコードで確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 1581行目のバグ：groupopenの初期値設定が誤っている（grouptitleを代入している）
- 0: 新規作成時のデフォルトステータスが明示的に設定されていない

## 6) レビュアーチェックリスト（最小）
- [ ] タイトルの英数字バリデーションが適切か確認
- [ ] 重複チェックが正常に動作するか確認
- [ ] 1581行目のバグ（groupopenへの誤った代入）の影響を確認
