---
generated_at: 2026-02-11 19:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-グループ詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先度の高いレビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/MailController.php` - groupdetailsAction()（1187-1203行目）
- E-02: `application/models/Mail.php` - fetchGroup()（290-304行目）
- E-03: `application/modules/admin/views/scripts/mail/groupdetails.phtml` - 詳細パネルUI定義
- E-04: `application/modules/admin/views/scripts/mail/group.phtml` - ContentPaneによる読み込み（35-36行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.69の定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連機能の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは/admin/mail/groupdetails?id={mgroup_id} | E-04 (35-36行目), E-01 (1193行目) | ○ |
| C-02 | mmailとmlistedit権限が必要 | E-01 (1189行目) | ○ |
| C-03 | レイアウトが無効化される | E-01 (1191行目) | ○ |
| C-04 | Mailモデルでグループデータを取得 | E-01 (1195-1196行目), E-02 | ○ |
| C-05 | ステータスをucwords()で整形して表示 | E-03 (15行目) | ○ |
| C-06 | 投稿数をMGroupCount()で取得 | E-03 (16行目) | ○ |
| C-07 | 投稿数はリンクとして表示 | E-03 (16行目) | ○ |
| C-08 | 購読者数をMSubscriberCount()で取得 | E-03 (17行目) | ○ |
| C-09 | SaveボタンはpostDialog()を使用 | E-03 (27行目) | ○ |
| C-10 | Saveボタンは/admin/mail/groupsave/を呼び出す | E-03 (27行目) | ○ |
| C-11 | DeleteボタンはID != 1の条件 | E-03 (28行目) | ○ |
| C-12 | Deleteボタンはmlistdelete権限が必要 | E-03 (28行目) | ○ |
| C-13 | DeleteボタンはgetDialog()を使用 | E-03 (29行目) | ○ |
| C-14 | Publishボタンはステータス != publishedの条件 | E-03 (31行目) | ○ |
| C-15 | Publishボタンはmlistpublish権限が必要 | E-03 (31行目) | ○ |
| C-16 | PublishボタンはgetDialog()を使用 | E-03 (32行目) | ○ |
| C-17 | Mail...ボタンはgoTo()を使用 | E-03 (34行目) | ○ |
| C-18 | Mail...ボタンは/admin/mail/へ遷移 | E-03 (34行目) | ○ |
| C-19 | ContentPaneで自動的にAjax読み込み | E-04 (35-36行目) | ○ |
| C-20 | preload="true"で即時読み込み | E-04 (35行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。本画面はシンプルなパーシャルビューであり、すべての主張がソースコードで確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: グループIDが無効な場合のエラーハンドリングが明示的でない（空のレスポンスが返る）
- 0: FCKeditorの更新（MyFCKObject.UpdateEditorFormValue()）は親画面依存

## 6) レビュアーチェックリスト（最小）
- [ ] グループが存在しない場合の表示を確認
- [ ] 権限不足時の動作を確認
- [ ] FCKeditorとの連携が正常に動作することを確認
- [ ] ID=1の場合のDeleteボタン非表示を確認
