---
generated_at: 2026-02-11 19:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-メールリスト画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先度の高いレビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/MailController.php` - maillistAction()（261-343行目）
- E-02: `application/models/Mail.php` - newMail(), fetchGroup()
- E-03: `application/modules/admin/views/scripts/mail/maillist.phtml` - 新規作成フォームUI定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.70の定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連機能の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは/admin/mail/maillist/ | E-03 (11, 46行目), E-01 (261行目) | ○ |
| C-02 | mmailとmmailnew権限が必要 | E-01 (263行目) | ○ |
| C-03 | レイアウトが無効化される | E-01 (265行目) | ○ |
| C-04 | 宛先リスト選択はFilteringSelect使用 | E-03 (14-22行目) | ○ |
| C-05 | MListSelect()で選択肢を生成 | E-03 (21行目) | ○ |
| C-06 | 件名入力はValidationTextBox使用 | E-03 (26-37行目) | ○ |
| C-07 | CreateボタンはdoDialog()を使用 | E-03 (46行目) | ○ |
| C-08 | Cancelボタンはダイアログを閉じる | E-03 (51-52行目) | ○ |
| C-09 | バリデーションで宛先必須チェック | E-01 (284-288行目) | ○ |
| C-10 | バリデーションで件名必須チェック | E-01 (290-295行目) | ○ |
| C-11 | fetchGroup()でグループのテンプレートを取得 | E-01 (303行目) | ○ |
| C-12 | mail_typeは'G'が設定される | E-01 (304行目) | ○ |
| C-13 | mail_slaveにグループIDが設定される | E-01 (305行目) | ○ |
| C-14 | mail_textにグループのテキストテンプレートが設定される | E-01 (307行目) | ○ |
| C-15 | mail_htmlにグループのHTMLテンプレートが設定される | E-01 (308行目) | ○ |
| C-16 | mail_userにログインユーザーIDが設定される | E-01 (309行目) | ○ |
| C-17 | 成功時は「Mail Created」メッセージ | E-01 (313行目) | ○ |
| C-18 | 成功時はContinueボタンを表示 | E-01 (316行目) | ○ |
| C-19 | Continueボタンはメール編集画面へ遷移 | E-01 (316行目) | ○ |
| C-20 | posted == 'N'の場合のみフォーム表示 | E-03 (9行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。本画面はメーリングリスト宛メール新規作成ダイアログであり、すべての主張がソースコードで確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 存在しないグループIDが指定された場合のエラーハンドリングが不明確
- 0: グループにテンプレートが未設定の場合、空の本文でメールが作成される

## 6) レビュアーチェックリスト（最小）
- [ ] MListSelect()が適切なメーリングリストを返すか確認
- [ ] グループのテンプレートが正しく本文に反映されるか確認
- [ ] Continueボタンで正しいメール編集画面に遷移するか確認
- [ ] 権限不足時の動作を確認
