---
generated_at: 2026-02-11 18:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：71-ロール別メール画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **メール管理画面からのアクセス方法**：New Role Mailボタンの存在確認が必要
  2. **権限名称の正確性**：ACLリソース名の実装確認
  3. **Continueボタン遷移先**：遷移先URLの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/views/scripts/mail/mailrole.phtml` - ビューテンプレート
- E-02: `application/modules/admin/controllers/MailController.php` - コントローラー（346-428行目: mailroleAction）
- E-03: `application/models/Mail.php` - Mailモデル（310-328行目: newMail）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（159-160行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（72行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はAjaxダイアログとして表示される | E-01（11行目: doDialog関数呼び出し） | ○ |
| C-02 | 宛先ロール選択はFilteringSelectで実装 | E-01（14-22行目） | ○ |
| C-03 | 件名入力はValidationTextBoxで実装 | E-01（26-37行目） | ○ |
| C-04 | ロールIDはIntegerフィルタで処理 | E-02（357-360行目） | ○ |
| C-05 | 件名はStringTrimフィルタで処理 | E-02（361-365行目） | ○ |
| C-06 | mmailとmmailnewの両権限が必要 | E-02（348行目） | ○ |
| C-07 | メール作成時にmail_typeは'R'が設定される | E-02（388行目） | ○ |
| C-08 | メール作成時にmail_statusは'draft'が設定される | E-03（317行目） | ○ |
| C-09 | 作成成功時にContinueボタンが表示される | E-02（396-401行目） | ○ |
| C-10 | CancelボタンでダイアログがHideされる | E-01（48-52行目） | ○ |
| C-11 | レイアウトは無効化される | E-02（350行目: disableLayout） | ○ |
| C-12 | URLは/admin/mail/mailrole/ | E-02（346行目: mailroleAction） | ○ |
| C-13 | 関連機能は59と61 | E-04（159-160行目） | ○ |
| C-14 | 画面No.71に対応 | E-05（72行目） | ○ |
| C-15 | URoleSelect()でロール一覧を取得 | E-01（21行目） | ○ |
| C-16 | バリデーションエラー時にメッセージ表示 | E-02（403-412行目） | ○ |
| C-17 | 権限不足時にprivilegesアクションに転送 | E-02（422-424行目） | ○ |
| C-18 | New Role Mailボタンからアクセス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について：メール管理画面（manage.phtml）でのNew Role Mailボタンの実装を確認できていません
  - 候補：`application/modules/admin/views/scripts/mail/manage.phtml` の確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面の基本機能は全てコードで確認可能
- 1: 中リスク - アクセス経路のボタン名称は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] メール管理画面（manage.phtml）のボタン名称を確認
- [ ] URoleSelect()ビューヘルパーの実装を確認
- [ ] 実際のACLリソース名（mmail, mmailnew）がシステムに存在するか確認
- [ ] common.jsのdoDialog()関数の動作確認
