---
generated_at: 2026-02-11 19:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：78-アセットプロパティ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/views/scripts/assets/properties.phtml` - ビューテンプレート
- E-02: `application/modules/admin/controllers/AssetsController.php` - コントローラー（1013-1038行目: propertiesAction）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（172行目）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（79行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はAjaxダイアログとして表示 | E-01（getDialog呼び出しによる表示） | ○ |
| C-02 | レイアウトは無効化される | E-02（1017行目: disableLayout） | ○ |
| C-03 | fassets権限が必要 | E-02（1015行目） | ○ |
| C-04 | URLパラメータassetでアセットID取得 | E-02（1019行目） | ○ |
| C-05 | assetsテーブルからアセット情報取得 | E-02（1023-1028行目） | ○ |
| C-06 | ファイル名（asset_name + extension）表示 | E-01（12行目） | ○ |
| C-07 | MIMEタイプ（asset_mime）表示 | E-01（16行目） | ○ |
| C-08 | ファイルサイズ（asset_size）表示 | E-01（20行目） | ○ |
| C-09 | アップロード日時（asset_date）表示 | E-01（24行目） | ○ |
| C-10 | 最終更新日時（asset_modified）表示 | E-01（28行目） | ○ |
| C-11 | URLは/admin/assets/properties/ | E-02（1013行目: propertiesAction） | ○ |
| C-12 | 関連機能は62 | E-03（172行目） | ○ |
| C-13 | 画面No.78に対応 | E-04（79行目） | ○ |
| C-14 | 権限不足時にprivilegesアクションに転送 | E-02（1033-1035行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対応する根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面の基本機能は全てコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] MakeDate()ビューヘルパーの実装を確認
- [ ] FormatBytes()ビューヘルパーの実装を確認（ファイルサイズフォーマット用）
- [ ] getDialog()関数の動作確認
