---
generated_at: 2026-02-11 11:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-アカウント有効化画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **有効化キーの安全性**：MD5(email + password)の推測可能性評価
  2. **有効化リンクの有効期限**：期限設定の有無確認
  3. **再有効化要求への対応**：既に有効化済みの場合の処理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/AuthController.php` (activateAction: 463-532行目)
- E-02: `application/modules/default/views/scripts/auth/activate.phtml` (全体)
- E-03: `database.sql` (users: 347-361行目, users_profiles: 457-477行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (No.8行)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (画面No=8の行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | activateActionがエントリーポイント | E-01 (463行目) | ○ |
| C-02 | URLパラメータ（id, key）取得 | E-01 (465-466行目) | ○ |
| C-03 | id/key両方存在確認 | E-01 (468行目) | ○ |
| C-04 | SELECT users JOIN users_profiles | E-01 (473-479行目) | ○ |
| C-05 | user_status='inactive'条件 | E-01 (477行目) | ○ |
| C-06 | ユーザー存在確認（count判定） | E-01 (484行目) | ○ |
| C-07 | UPDATE user_status='active' | E-01 (489-494行目) | ○ |
| C-08 | 有効化完了メール送信 | E-01 (496-511行目) | ○ |
| C-09 | メール内容にログインURL等含む | E-01 (497-507行目) | ○ |
| C-10 | posted='Y'設定 | E-01 (513行目) | ○ |
| C-11 | リダイレクト（method=activated） | E-01 (515行目) | ○ |
| C-12 | ユーザー不存在時エラーメッセージ | E-01 (521行目) | ○ |
| C-13 | パラメータ不足時エラーメッセージ | E-01 (529行目) | ○ |
| C-14 | RenderMessages()でエラー表示 | E-02 (31行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 本画面については主要な情報はすべて確認済み
- セキュリティ観点での追加確認事項：
  - 有効化リンクの有効期限設定の有無
  - 有効化キー（MD5(email + password)）の安全性評価

## 5) リスクフラグ（レビュー観点）
- 0: パラメータ検証（低リスク - コード確認済み）
- 0: DB更新処理（低リスク - コード確認済み）
- 0: リダイレクト処理（低リスク - コード確認済み）
- 2: 有効化キーの安全性（高リスク - MD5(email+password)は推測可能な場合あり）
- 2: 有効化リンク有効期限（高リスク - 期限設定なしの場合、セキュリティリスク）

## 6) レビュアーチェックリスト（最小）
- [ ] activateActionの処理フローが設計書と一致するか確認
- [ ] 有効化キー（user_key）の生成ロジックの安全性を評価
- [ ] 有効化リンクの有効期限設定の有無を確認
- [ ] 既に有効化済みユーザーへの再有効化試行時の挙動を確認
- [ ] エラーメッセージが情報漏洩につながらないか確認
