---
generated_at: 2026-02-11 19:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：80-フォルダ新規作成画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/views/scripts/assets/foldernew.phtml` - ビューテンプレート
- E-02: `application/modules/admin/controllers/AssetsController.php` - コントローラー（631-727行目: foldernewAction）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（175-176行目）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（81行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はAjaxダイアログとして表示 | E-01（11行目: doDialog関数呼び出し） | ○ |
| C-02 | レイアウトは無効化される | E-02（635行目: disableLayout） | ○ |
| C-03 | fassetsとffoldernew権限が必要 | E-02（633行目） | ○ |
| C-04 | URLパラメータparentで親フォルダID取得 | E-02（637行目） | ○ |
| C-05 | foldertitleはNotEmpty必須 | E-02（646-650行目） | ○ |
| C-06 | 同名フォルダ重複チェック実行 | E-02（657-666行目） | ○ |
| C-07 | folder_parentにparentパラメータ値をINSERT | E-02（678行目） | ○ |
| C-08 | folder_nameにfoldertitleをINSERT | E-02（679行目） | ○ |
| C-09 | folder_dateにNOW()をINSERT | E-02（680行目） | ○ |
| C-10 | folder_modifyにNOW()をINSERT | E-02（681行目） | ○ |
| C-11 | URLは/admin/assets/foldernew/ | E-02（631行目: foldernewAction） | ○ |
| C-12 | 関連機能は62と61 | E-03（175-176行目） | ○ |
| C-13 | 画面No.80に対応 | E-04（81行目） | ○ |
| C-14 | 成功時にFolder Createdメッセージ表示 | E-02（687-692行目） | ○ |
| C-15 | 権限不足時にprivilegesアクションに転送 | E-02（722-724行目） | ○ |
| C-16 | Closeボタンで画面リロード | E-02（691行目: location.reload(true)） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対応する根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面の基本機能は全てコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] doDialog()関数の動作確認
- [ ] 同名フォルダ重複チェックの動作確認
- [ ] 各権限（fassets, ffoldernew）がACLに定義されているか確認
