---
generated_at: 2026-02-11 18:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：81-フォルダプロパティ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/AssetsController.php` 920-945行目（folderpropertiesAction）
- E-02: `application/modules/admin/views/scripts/assets/folderproperties.phtml` 1-37行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 178-179行目
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 82行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はAjaxダイアログとして表示される | E-01（924行目：$this->_helper->layout->disableLayout()） | ○ |
| C-02 | URLは/admin/assets/folderproperties/folder/{folder_id}/ | E-01（920行目：folderpropertiesAction定義） | ○ |
| C-03 | fassets権限が必要 | E-01（922行目：$this->view->acl->isAllowed(..., 'fassets')） | ○ |
| C-04 | folder_name, folder_date, folder_modifyを表示 | E-02（12, 16, 20行目：各フィールド参照） | ○ |
| C-05 | Editボタンでフォルダ編集画面へ遷移 | E-02（25-30行目：getDialog呼び出し） | ○ |
| C-06 | Closeボタンでダイアログを閉じる | E-02（31-36行目：dijit.byId('ajaxDialog').hide()） | ○ |
| C-07 | assets_foldersテーブルからデータ取得 | E-01（931-936行目：SELECT文） | ○ |
| C-08 | MakeDateヘルパーで日付フォーマット | E-02（16, 20行目：$this->MakeDate呼び出し） | ○ |
| C-09 | 日付形式は「jS F Y g:i:sa」 | E-02（16行目：'jS F Y g:i:sa'） | ○ |
| C-10 | 権限なしの場合は権限エラー画面へ転送 | E-01（940-943行目：$this->_forward('privileges','error','admin')） | ○ |
| C-11 | dijit.form.Buttonウィジェットを使用 | E-02（25, 31行目：dojoType="dijit.form.Button"） | ○ |
| C-12 | propertiesTableクラスのテーブル構造 | E-02（9行目：class="propertiesTable"） | ○ |
| C-13 | 機能No.29「アセット編集」が主機能 | E-03（178行目） | ○ |
| C-14 | 機能No.63「入力検証」が補助機能 | E-03（179行目） | ○ |
| C-15 | 画面No.81、カテゴリは「管理 - アセット」 | E-04（82行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 表示項目（folder_name, folder_date, folder_modify）がビジネス要件と一致しているか確認
- [ ] 日付フォーマット「jS F Y g:i:sa」がシステム全体で統一されているか確認
- [ ] Editボタンの遷移先パスが正しいか確認
