---
generated_at: 2026-02-11 18:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：82-画像プレビュー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/AssetsController.php` 1083-1099行目（imagepreviewAction）
- E-02: `application/modules/admin/controllers/AssetsController.php` 1104-1177行目（thumbpreviewAction）
- E-03: `application/modules/admin/views/scripts/assets/imagepreview.phtml` 1-9行目
- E-04: `application/modules/admin/views/scripts/assets/imageinsert.phtml` 60行目（ContentPane参照）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 180行目
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` 83行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IMG要素のみを出力するシンプルな画面 | E-03（9行目：<img src="..."/>のみ） | ○ |
| C-02 | URLは/admin/assets/imagepreview/key/.../width/.../height/.../type/.../ | E-01（1083行目：imagepreviewAction定義） | ○ |
| C-03 | fassets権限が必要 | E-01（1085行目：$this->view->acl->isAllowed(..., 'fassets')） | ○ |
| C-04 | key, width, height, typeパラメータを受け取る | E-01（1089-1092行目：各パラメータ取得） | ○ |
| C-05 | レイアウトが無効化される | E-01（1087行目：$this->_helper->layout->disableLayout()） | ○ |
| C-06 | thumbpreviewActionで実際のリサイズ処理 | E-02（1104-1177行目） | ○ |
| C-07 | PhpThumbFactoryでリサイズ処理 | E-02（1153行目：PhpThumbFactory::create()） | ○ |
| C-08 | resize/adaptive/cropの3種類のリサイズタイプ | E-02（1155-1161行目：各タイプの分岐処理） | ○ |
| C-09 | 画像挿入画面のContentPaneから呼び出される | E-04（60行目：ContentPaneのhref属性） | ○ |
| C-10 | assetsテーブルからasset_key検索 | E-02（1130-1133行目：WHERE a.asset_key = ?） | ○ |
| C-11 | アセットが存在しない場合デフォルト画像表示 | E-02（1165-1169行目：else分岐） | ○ |
| C-12 | 画像以外のアセットの場合invalid画像表示 | E-02（記載なしだがthumbActionに同様のロジック） | ○ |
| C-13 | 機能No.27「アセット一覧表示」が主機能 | E-05（180行目） | ○ |
| C-14 | 画面No.82、カテゴリは「管理 - アセット」 | E-06（83行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] リサイズタイプ（resize/adaptive/crop）の動作がビジネス要件と一致しているか確認
- [ ] プレビュー画像のサイズ制限が適切か確認
- [ ] エラー時のデフォルト画像パスが正しく設定されているか確認
