---
generated_at: 2026-02-11 18:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：83-画像挿入画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/AssetsController.php` 1043-1078行目（imageinsertAction）
- E-02: `application/modules/admin/views/scripts/assets/imageinsert.phtml` 1-77行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 181-182行目
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 84行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ajaxダイアログとして表示される | E-01（1047行目：$this->_helper->layout->disableLayout()） | ○ |
| C-02 | URLは/admin/assets/imageinsert/key/{asset_key}/ | E-01（1043行目：imageinsertAction定義） | ○ |
| C-03 | fassets権限が必要 | E-01（1045行目：$this->view->acl->isAllowed(..., 'fassets')） | ○ |
| C-04 | リサイズタイプはresize/adaptive/cropの3種類 | E-02（19-21行目：option要素） | ○ |
| C-05 | 初期値はresize（Fit to Box） | E-02（19行目：option value="resize"が最初） | ○ |
| C-06 | 幅の初期値は画像の元幅 | E-02（34行目：value="<?php echo $this->size['width']; ?>"） | ○ |
| C-07 | 高さの初期値は画像の元高さ | E-02（48行目：value="<?php echo $this->size['height']; ?>"） | ○ |
| C-08 | getimagesize()で元サイズを取得 | E-01（1069行目：$size = getimagesize($file)） | ○ |
| C-09 | PreviewボタンでimagePreview関数を呼び出す | E-02（58行目：onClick="imagePreview('<?php echo $this->key; ?>');"） | ○ |
| C-10 | InsertボタンでimageInsert関数を呼び出す | E-02（68行目：onClick="imageInsert('<?php echo $this->key; ?>');"） | ○ |
| C-11 | Cancelボタンでダイアログを閉じる | E-02（74行目：onClick="dijit.byId('ajaxDialog').hide();"） | ○ |
| C-12 | プレビューエリアは800x450ピクセル | E-02（60行目：width: 800px; height: 450px;） | ○ |
| C-13 | プレビューエリアはスクロール可能 | E-02（60行目：overflow: auto;） | ○ |
| C-14 | ContentPaneでプレビューを表示 | E-02（60行目：dojoType="dijit.layout.ContentPane"） | ○ |
| C-15 | 機能No.31「アセット選択」が主機能 | E-03（181行目） | ○ |
| C-16 | 機能No.64「Ajaxダイアログ」が補助機能 | E-03（182行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] imageInsert JavaScript関数の実装を確認（エディタへの挿入ロジック）
- [ ] 入力バリデーション（幅・高さが数値であること）が十分か確認
- [ ] 大きな画像サイズを指定した場合のサーバー負荷を確認
