---
generated_at: 2026-02-11 18:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：84-リンク挿入画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/AssetsController.php` 1183-1196行目（linkinsertAction）
- E-02: `application/modules/admin/controllers/AssetsController.php` 140-195行目（downloadAction）
- E-03: `application/modules/admin/controllers/AssetsController.php` 200-255行目（openAction）
- E-04: `application/modules/admin/views/scripts/assets/linkinsert.phtml` 1-38行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 183-184行目
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` 85行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ajaxダイアログとして表示される | E-01（1187行目：$this->_helper->layout->disableLayout()） | ○ |
| C-02 | URLは/admin/assets/linkinsert/key/{asset_key}/ | E-01（1183行目：linkinsertAction定義） | ○ |
| C-03 | fassets権限が必要 | E-01（1185行目：$this->view->acl->isAllowed(..., 'fassets')） | ○ |
| C-04 | リンクタイプはdownload/openの2種類 | E-04（13, 19行目：value="download", value="open"） | ○ |
| C-05 | 初期値はdownload | E-04（13行目：checked="checked"） | ○ |
| C-06 | ラジオボタンでリンクタイプを選択 | E-04（13, 19行目：dojoType="dijit.form.RadioButton"） | ○ |
| C-07 | InsertボタンでlinkInsert関数を呼び出す | E-04（30行目：onClick="linkInsert('<?php echo $this->key; ?>');"） | ○ |
| C-08 | Cancelボタンでダイアログを閉じる | E-04（36行目：onClick="dijit.byId('ajaxDialog').hide();"） | ○ |
| C-09 | downloadActionはContent-Disposition: attachmentを設定 | E-02（174行目：'Content-Disposition', 'attachment;...'） | ○ |
| C-10 | openActionはContent-Disposition: inlineを設定 | E-03（234行目：'Content-Disposition', 'inline;...'） | ○ |
| C-11 | 画面表示時にDB参照なし | E-01（1183-1196行目：DB参照処理なし） | ○ |
| C-12 | 機能No.31「アセット選択」が主機能 | E-05（183行目） | ○ |
| C-13 | 機能No.64「Ajaxダイアログ」が補助機能 | E-05（184行目） | ○ |
| C-14 | 画面No.84、カテゴリは「管理 - アセット」 | E-06（85行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] linkInsert JavaScript関数の実装を確認（エディタへの挿入ロジック）
- [ ] downloadAction/openActionで適切なMIMEタイプが設定されているか確認
- [ ] セキュリティ観点でファイルダウンロードの権限チェックが十分か確認
