---
generated_at: 2026-02-11 18:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-コメント管理画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/CommentsController.php` 53-124行目（manageAction）
- E-02: `application/modules/admin/controllers/CommentsController.php` 165-205行目（deleteAction）
- E-03: `application/modules/admin/controllers/CommentsController.php` 210-287行目（approveAction）
- E-04: `application/modules/admin/views/scripts/comments/manage.phtml` 1-86行目
- E-05: `application/models/Comments.php` 1-106行目
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 185-188行目
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` 86行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | gcomments権限が必要 | E-01（55行目：$this->view->acl->isAllowed(..., 'gcomments')） | ○ |
| C-02 | 1ページ15件のページネーション | E-01（112行目：setItemCountPerPage(15)） | ○ |
| C-03 | ページレンジは5件 | E-01（113行目：setPageRange(5)） | ○ |
| C-04 | author/type/slaveパラメータでフィルタ可能 | E-01（59-63行目：各パラメータ取得）、E-01（75-107行目：条件分岐） | ○ |
| C-05 | commentsとusersテーブルをJOIN | E-01（84, 91, 100, 105行目：join句） | ○ |
| C-06 | 未承認コメントはnotapprovedクラス | E-04（42行目：class="comFieldset<?php if ...?> notapproved"） | ○ |
| C-07 | gcommentsstatus権限で承認操作表示 | E-04（43, 51行目：$this->acl->isAllowed(..., 'gcommentsstatus')） | ○ |
| C-08 | gcommentdelete権限で削除操作表示 | E-04（43, 47行目：$this->acl->isAllowed(..., 'gcommentdelete')） | ○ |
| C-09 | マウスオーバーで操作ボタン表示 | E-04（42行目：onMouseOver="toggleDisp..."） | ○ |
| C-10 | approveComment関数で承認操作 | E-04（45, 53行目：onClick="approveComment(...)"） | ○ |
| C-11 | deleteComment関数で削除操作 | E-04（45, 49行目：onClick="deleteComment(...)"） | ○ |
| C-12 | ApproveでUPDATE comment_approved='Y' | E-03（229-234行目：$data = array('comment_approved' => 'Y')） | ○ |
| C-13 | DisapproveでUPDATE comment_approved='N' | E-03（255-261行目：$data = array('comment_approved' => 'N')） | ○ |
| C-14 | DeleteでDELETE FROM comments | E-02（181行目：$registry->db->delete('comments', ...)） | ○ |
| C-15 | 日付形式はd/m/Y | E-04（64行目：$this->MakeDate('d/m/Y',...)） | ○ |
| C-16 | コメントなし時は「No Comments!」 | E-04（75行目：<div class="cErr">No Comments!</div>） | ○ |
| C-17 | cslaveDetailsヘルパーでコンテンツ詳細取得 | E-04（35, 68行目：$this->cslaveDetails(...)） | ○ |
| C-18 | 機能No.44「コメント一覧表示」が主機能 | E-06（185行目） | ○ |
| C-19 | 機能No.62「ページネーション」が補助機能 | E-06（186行目） | ○ |
| C-20 | 画面No.85、カテゴリは「管理 - コメント」 | E-07（86行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] approveComment/deleteComment JavaScript関数の実装を確認
- [ ] Ajax操作後のエラーハンドリングが適切か確認
- [ ] コメント削除時に関連データ（返信等）の処理が必要か確認
