---
generated_at: 2026-02-11 18:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：86-コメント表示画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/CommentsController.php` 129-160行目（showAction）
- E-02: `application/modules/admin/controllers/CommentsController.php` 165-205行目（deleteAction）
- E-03: `application/modules/admin/controllers/CommentsController.php` 210-287行目（approveAction）
- E-04: `application/modules/admin/views/scripts/comments/show.phtml` 1-37行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 189-190行目
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` 87行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | gcomments権限が必要 | E-01（131行目：$this->view->acl->isAllowed(..., 'gcomments')） | ○ |
| C-02 | レイアウト無効化される | E-01（133行目：$this->_helper->layout->disableLayout()） | ○ |
| C-03 | type/slaveパラメータでフィルタ | E-01（135-136行目：$slave, $type取得）、E-01（146-147行目：where句） | ○ |
| C-04 | 全件取得（ページネーションなし） | E-01（152行目：$registry->db->fetchall、Paginator未使用） | ○ |
| C-05 | commentsとusersテーブルをJOIN | E-01（148行目：join句） | ○ |
| C-06 | 未承認コメントはnotapprovedクラス | E-04（11行目：class="comFieldset<?php if ...?> notapproved"） | ○ |
| C-07 | gcommentsstatus権限で承認操作表示 | E-04（12, 20行目：$this->acl->isAllowed(..., 'gcommentsstatus')） | ○ |
| C-08 | gcommentdelete権限で削除操作表示 | E-04（12, 16行目：$this->acl->isAllowed(..., 'gcommentdelete')） | ○ |
| C-09 | ajax=1パラメータでリロードなし | E-04（14, 18行目：,1); ）、E-02（187行目：if ($ajax != 1)分岐） | ○ |
| C-10 | 著者リンクはユーザー編集画面へ | E-04（26行目：/admin/users/edit/id/<?php echo $comment['user_id']; ?>） | ○ |
| C-11 | 日付形式はd/m/Y | E-04（27行目：$this->MakeDate('d/m/Y',...)） | ○ |
| C-12 | コメントなし時は「No Comments!」 | E-04（35行目：<div class="cErr">No Comments!</div>） | ○ |
| C-13 | ApproveでUPDATE comment_approved='Y' | E-03（229-234行目） | ○ |
| C-14 | DeleteでDELETE FROM comments | E-02（181行目） | ○ |
| C-15 | 機能No.45「コメント表示」が主機能 | E-05（189行目） | ○ |
| C-16 | 機能No.47「コメント承認/非承認」が補助機能 | E-05（190行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ajax=1パラメータでの非リロード動作が正しく機能するか確認
- [ ] 呼び出し元（記事詳細、ページ詳細等）のContentPane設定を確認
- [ ] コメント削除後のUI更新が必要か確認（現状はダイアログ表示のみ）
