---
generated_at: 2026-02-11 19:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：87-ローテーター管理画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/RotatorsController.php` 29-47行目（manageAction）
- E-02: `application/modules/admin/views/scripts/rotators/manage.phtml` 1-75行目
- E-03: `application/models/Rotators.php` 24-54行目（fetchRotators）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 191-193行目
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 88行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rotrotators権限が必要 | E-01（31行目：$this->view->acl->isAllowed(..., 'rotrotators')） | ○ |
| C-02 | 1ページ15件のページネーション | E-01（33行目：$this->_request->setParam('items',15)） | ○ |
| C-03 | ページレンジは5件 | E-01（34行目：$this->_request->setParam('range',5)） | ○ |
| C-04 | Rotatorsモデルを使用 | E-01（38行目：$rotators = new Rotators()） | ○ |
| C-05 | rot_nameで名前順ソート | E-03（28行目：$select->order('r.rot_name ASC')） | ○ |
| C-06 | テーブルヘッダーはRotator/Dimensions/Slides/Paging/Delay | E-02（32-36行目：<th>各項目</th>） | ○ |
| C-07 | マウスオーバーでEdit表示 | E-02（41行目：onMouseOver="toggleVis('edit..."） | ○ |
| C-08 | ローテーター名からedit画面へリンク | E-02（43行目：/admin/rotators/edit/id/<?php echo $rotator['rot_id']; ?>） | ○ |
| C-09 | rotSlideCountヘルパーでスライド数表示 | E-02（47行目：$this->rotSlideCount($rotator['rot_id'])） | ○ |
| C-10 | Pagingはアイコン表示（Y/N） | E-02（49-53行目：if/elseif分岐でアイコン表示） | ○ |
| C-11 | Delayは数値表示 | E-02（55行目：<?php echo $rotator['rot_delay']; ?>） | ○ |
| C-12 | ローテーターなし時は「No Rotators!」 | E-02（61行目：<div class="cUpd">No Rotators!</div>） | ○ |
| C-13 | 機能No.39「ローテーター一覧表示」が主機能 | E-04（191行目） | ○ |
| C-14 | 機能No.62「ページネーション」が補助機能 | E-04（192行目） | ○ |
| C-15 | 画面No.87、カテゴリは「管理 - ローテーター」 | E-05（88行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] rotSlideCountビューヘルパーの実装を確認
- [ ] ローテーター新規作成機能の有無を確認（現状は一覧のみ）
- [ ] Pagingアイコンのツールチップ表示を確認
