---
generated_at: 2026-02-11 19:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：88-ローテーター編集画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/RotatorsController.php` 53-80行目（editAction）
- E-02: `application/modules/admin/views/scripts/rotators/edit.phtml` 1-102行目
- E-03: `application/models/Rotators.php` 61-96行目（fetchSlides）、103-116行目（fetchRotator）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 194-196行目
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 89行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rotrotators && rotrotatoredit権限が必要 | E-01（55行目：両方のisAllowed） | ○ |
| C-02 | fetchRotatorでローテーター情報取得 | E-01（66行目）、E-03（103-116行目） | ○ |
| C-03 | fetchSlidesでスライド一覧取得 | E-01（72行目）、E-03（61-96行目） | ○ |
| C-04 | ローテーターが存在しない場合リダイレクト | E-01（68-70行目：if(!count(...)) redirector） | ○ |
| C-05 | New Slideボタンでslidenewダイアログ呼び出し | E-02（38行目：getDialog('/admin/rotators/slidenew/...')） | ○ |
| C-06 | Rotators...ボタンで管理画面へ遷移 | E-02（39行目：goTo('/admin/rotators/')） | ○ |
| C-07 | Detailsエリアにタグ形式で情報表示 | E-02（49-56行目：class="tagItm"） | ○ |
| C-08 | Pagingはアイコン表示 | E-02（51-55行目：if/elseif分岐でアイコン） | ○ |
| C-09 | テーブルヘッダーはImage/Title/Caption/Link/Priority | E-02（66-70行目：<th>各項目</th>） | ○ |
| C-10 | サムネイルは60x60px | E-02（76行目：/60/60/） | ○ |
| C-11 | タイトルクリックでスライド編集ダイアログ | E-02（78行目：getDialog('/admin/rotators/slide/id/...')） | ○ |
| C-12 | Edit/Deleteリンクがマウスオーバーで表示 | E-02（75行目：onMouseOver="toggleVis..."）、E-02（79行目） | ○ |
| C-13 | DeleteでslidedeleteダイアログURLを呼び出し | E-02（79行目：getDialog('/admin/rotators/slidedelete/...')） | ○ |
| C-14 | スライドなし時は「No Slides!」 | E-02（89行目：<div class="cUpd">No Slides!</div>） | ○ |
| C-15 | rots_orderで優先度表示 | E-02（83行目：<?php echo $slide['rots_order']; ?>） | ○ |
| C-16 | 機能No.40「ローテーター編集」が主機能 | E-04（194行目） | ○ |
| C-17 | 機能No.43「スライド削除」が遷移先機能 | E-04（196行目） | ○ |
| C-18 | 画面No.88、カテゴリは「管理 - ローテーター」 | E-05（89行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ローテーター本体の編集機能がないことを確認（意図的かどうか）
- [ ] スライドの並び替え（ドラッグ&ドロップ等）機能の有無を確認
- [ ] スライド削除時の関連データ処理を確認
