---
generated_at: 2026-02-11 19:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：89-スライド編集画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/RotatorsController.php` 171-257行目（slideAction）
- E-02: `application/modules/admin/views/scripts/rotators/slide.phtml` 1-115行目
- E-03: `application/models/Rotators.php` 123-136行目（fetchSlide）、179-190行目（updateSlide）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 197-199行目
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 90行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rotrotators && rotrotatoredit権限が必要 | E-01（173行目：両方のisAllowed） | ○ |
| C-02 | レイアウト無効化 | E-01（175行目：$this->_helper->layout->disableLayout()） | ○ |
| C-03 | fetchSlideでスライド情報取得 | E-01（181行目）、E-03（123-136行目） | ○ |
| C-04 | slidetitleはrequired、NotEmpty | E-01（190-195行目）、E-02（14-25行目：required="true"） | ○ |
| C-05 | slidedescriptionはallowEmpty | E-01（196行目） | ○ |
| C-06 | slidelinkはrequired、NotEmpty | E-01（197-201行目）、E-02（43-54行目：required="true"） | ○ |
| C-07 | slidepriorityはrequired、整数のみ | E-01（203-208行目）、E-02（58-70行目：regExp="^([0-9 ]+)$"） | ○ |
| C-08 | assetはrequired、NotEmpty | E-01（209-214行目） | ○ |
| C-09 | updateSlideでDB更新 | E-01（221-227行目）、E-03（179-190行目） | ○ |
| C-10 | 成功時「Slide Saved」メッセージ | E-01（229行目：echo '...<div class="cUpd">Slide Saved</div>...'） | ○ |
| C-11 | 画像プレビューは180x180px | E-02（77行目：/180/180/type/resize） | ○ |
| C-12 | assetFileフィールドはreadonly | E-02（91行目：readonly="readonly"） | ○ |
| C-13 | Browse...ボタンでopenAssetMan呼び出し | E-02（94行目：openAssetMan('image','select','asset')） | ○ |
| C-14 | SaveボタンでdoDialog呼び出し | E-02（106行目：doDialog('/admin/rotators/slide/id/...')） | ○ |
| C-15 | Cancelボタンでダイアログを閉じる | E-02（112行目：dijit.byId('ajaxDialog').hide()） | ○ |
| C-16 | POSTでない場合はposted='N' | E-01（247行目）、E-02（9行目：if($this->posted == 'N')） | ○ |
| C-17 | RenderMessagesヘルパーでエラー表示 | E-02（10行目：$this->RenderMessages($this->messages)） | ○ |
| C-18 | 機能No.42「スライド編集」が主機能 | E-04（197行目） | ○ |
| C-19 | 機能No.31「アセット選択」が補助機能 | E-04（199行目） | ○ |
| C-20 | 画面No.89、カテゴリは「管理 - ローテーター」 | E-05（90行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] リンクURLのフォーマットバリデーションが必要か確認
- [ ] 優先度の重複チェックが必要か確認
- [ ] 画像アセットが削除された場合の処理を確認
