---
generated_at: 2026-02-11 19:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-スライド新規作成画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/RotatorsController.php` 85-166行目（slidenewAction）
- E-02: `application/modules/admin/views/scripts/rotators/slidenew.phtml` 1-115行目
- E-03: `application/models/Rotators.php` 142-159行目（newSlide）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 200-202行目
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 91行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | レイアウト無効化 | E-01（87行目：$this->_helper->layout->disableLayout()） | ○ |
| C-02 | rotatorパラメータを取得 | E-01（89行目：$this->view->rotator = $this->_getParam('rotator')） | ○ |
| C-03 | slidetitleはrequired、NotEmpty | E-01（98-103行目）、E-02（14-25行目：required="true"） | ○ |
| C-04 | slidedescriptionはallowEmpty | E-01（104行目） | ○ |
| C-05 | slidelinkはrequired、NotEmpty | E-01（105-110行目）、E-02（43-54行目：required="true"） | ○ |
| C-06 | slidepriorityはrequired、整数のみ | E-01（111-116行目）、E-02（58-70行目：regExp="^([0-9 ]+)$"） | ○ |
| C-07 | assetはrequired、NotEmpty | E-01（117-122行目） | ○ |
| C-08 | newSlideでDB挿入 | E-01（129-136行目）、E-03（142-159行目） | ○ |
| C-09 | 成功時「Slide Created」メッセージ | E-01（139行目：echo '...<div class="cUpd">Slide Created</div>...'） | ○ |
| C-10 | 画像プレビューは180x180px | E-02（77行目：/180/180/type/resize） | ○ |
| C-11 | assetFileフィールドはreadonly | E-02（91行目：readonly="readonly"） | ○ |
| C-12 | Browse...ボタンでopenAssetMan呼び出し | E-02（94行目：openAssetMan('image','select','asset')） | ○ |
| C-13 | CreateボタンでdoDialog呼び出し | E-02（106行目：doDialog('/admin/rotators/slidenew/rotator/...')） | ○ |
| C-14 | Cancelボタンでダイアログを閉じる | E-02（112行目：dijit.byId('ajaxDialog').hide()） | ○ |
| C-15 | POSTでない場合はposted='N' | E-01（162行目）、E-02（9行目：if($this->posted == 'N')） | ○ |
| C-16 | RenderMessagesヘルパーでエラー表示 | E-02（10行目：$this->RenderMessages($this->messages)） | ○ |
| C-17 | 機能No.41「スライド新規作成」が主機能 | E-04（200行目） | ○ |
| C-18 | 画面No.90、カテゴリは「管理 - ローテーター」 | E-05（91行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり
- 注意点：slidenewActionには権限チェックが実装されていない（親画面で制御される前提）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限チェックがないことの妥当性を確認（親画面での制御で十分か）
- [ ] リンクURLのフォーマットバリデーションが必要か確認
- [ ] 優先度の重複チェックが必要か確認
- [ ] 画像アセットが削除された場合の処理を確認
