---
generated_at: 2026-02-11 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：91-管理者エラー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **本番環境でのエラー詳細非表示の推奨**：設定ファイル未確認のため根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/ErrorController.php` - 管理画面エラーコントローラー
- E-02: `library/CMS/Controller/Action/Error.php` - エラーコントローラー基底クラス
- E-03: `application/modules/admin/views/scripts/error/error.phtml` - エラー表示テンプレート
- E-04: `application/layouts/admin-auth.phtml` - 認証・エラー用レイアウト
- E-05: `library/CMS/Acl/Factory.php` - ACLファクトリクラス
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | errorActionは404エラーとアプリケーションエラーを判定する | E-01 行27-41のswitch文 | ○ |
| C-02 | 404エラー時はHTTPステータス404を設定する | E-01 行31 setRawHeader('HTTP/1.1 404 Not Found') | ○ |
| C-03 | 404エラー時のタイトルは「HTTP/1.1 404 Not Found」 | E-01 行32 | ○ |
| C-04 | 404エラー時のメッセージは「The resource you requested could not be found.」 | E-01 行33 | ○ |
| C-05 | アプリケーションエラー時のタイトルは「Application Error」 | E-01 行38 | ○ |
| C-06 | アプリケーションエラー時は例外オブジェクトをメッセージに設定 | E-01 行39 | ○ |
| C-07 | レイアウトは「admin-auth」を使用 | E-01 行13, 行24 | ○ |
| C-08 | preDispatchで認証状態を確認しACLを構築 | E-02 行17-40 | ○ |
| C-09 | 未認証時はゲストロール（role_id=2）を設定 | E-02 行32 | ○ |
| C-10 | error.phtmlでpre要素内にメッセージを表示 | E-03 行21 | ○ |
| C-11 | URLパターンは/admin/error/error | E-01クラス名・メソッド名から推定 | ○ |
| C-12 | 画面No.91は「管理者エラー画面」 | E-07 行92 | ○ |
| C-13 | 関連機能はNo.61「アクセス制御」 | E-06 行203 | ○ |
| C-14 | admin-authレイアウトはナビゲーションメニューを含まない | E-04 全体構造を確認 | ○ |
| C-15 | CMS_Acl_FactoryがusersテーブルからACLを構築 | E-05 行42-82 | ○ |
| C-16 | headTitleでサイト名とエラーを連結 | E-03 行16 | ○ |
| C-17 | dojo.parserをonloadで実行 | E-03 行9 | ○ |
| C-18 | 本番環境では例外詳細を非表示にすべき（推奨） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 本番環境でのエラー表示設定に関する設定ファイルが未確認
  - 候補：application.ini / php.ini / Zend Framework設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードに基づいた記述であり、信頼性が高い
- 1: 中リスク - 本番環境での運用推奨事項は実際の設定確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] errorAction内のエラー種別判定ロジックが正確か確認
- [ ] HTTPステータスコード設定が適切か確認
- [ ] 本番環境でのエラー詳細表示に関するセキュリティ設定を確認
- [ ] admin-authレイアウトが認証画面とエラー画面で適切に共有されているか確認
