---
generated_at: 2026-02-11 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：92-管理者404エラー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/ErrorController.php` - 管理画面エラーコントローラー（行48-55: notfoundAction）
- E-02: `library/CMS/Controller/Action/Error.php` - エラーコントローラー基底クラス
- E-03: `application/modules/admin/views/scripts/error/notfound.phtml` - 404エラー表示テンプレート
- E-04: `application/layouts/admin-auth.phtml` - 認証・エラー用レイアウト
- E-05: `library/CMS/Acl/Factory.php` - ACLファクトリクラス
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（行204）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行93）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | notfoundActionはHTTPステータス404を設定する | E-01 行52 setRawHeader('HTTP/1.1 404 Not Found') | ○ |
| C-02 | タイトルは「HTTP/1.1 404 Not Found」 | E-01 行53 | ○ |
| C-03 | メッセージは「The resource you requested could not be found.」 | E-01 行54 | ○ |
| C-04 | レイアウトは「admin-auth」を使用 | E-01 行50 setLayout()呼び出し, 行13 'admin-auth'設定 | ○ |
| C-05 | preDispatchで認証状態を確認しACLを構築 | E-02 行17-40 | ○ |
| C-06 | 未認証時はゲストロール（role_id=2）を設定 | E-02 行32 | ○ |
| C-07 | notfound.phtmlでメッセージを表示 | E-03 行19-22 | ○ |
| C-08 | URLパターンは/admin/error/notfound | E-01クラス名・メソッド名から推定 | ○ |
| C-09 | 画面No.92は「管理者404エラー画面」 | E-07 行93 | ○ |
| C-10 | 関連機能はNo.61「アクセス制御」 | E-06 行204 | ○ |
| C-11 | admin-authレイアウトはナビゲーションメニューを含まない | E-04 全体構造を確認 | ○ |
| C-12 | CMS_Acl_FactoryがusersテーブルからACLを構築 | E-05 行42-82 | ○ |
| C-13 | headTitleでサイト名とエラーを連結 | E-03 行16 | ○ |
| C-14 | dojo.parserをonloadで実行 | E-03 行9 | ○ |
| C-15 | notfound.phtmlはpre要素を使用しない（error.phtmlとの違い） | E-03 行20 vs E-01参照のerror.phtml行21 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張にソースコード上の根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードに基づいた記述であり、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] notfoundActionのHTTPステータスコード設定が適切か確認
- [ ] エラーメッセージが英語のみであることを確認（多言語対応の必要性検討）
- [ ] notfound.phtmlとerror.phtmlの表示形式の違い（preタグの有無）が意図的か確認
- [ ] 他コントローラーからの_forward()呼び出しパターンが適切か確認
