---
generated_at: 2026-02-11 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：93-権限エラー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/ErrorController.php` - 管理画面エラーコントローラー（行61-68: privilegesAction）
- E-02: `library/CMS/Controller/Action/Error.php` - エラーコントローラー基底クラス
- E-03: `application/modules/admin/views/scripts/error/privileges.phtml` - 権限エラー表示テンプレート
- E-04: `application/layouts/admin-auth.phtml` - 認証・エラー用レイアウト
- E-05: `library/CMS/Acl/Factory.php` - ACLファクトリクラス
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（行205）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行94）
- E-08: `application/modules/admin/controllers/ArticlesController.php` - 権限チェックパターンの参照例
- E-09: `application/modules/admin/controllers/PagesController.php` - 権限チェックパターンの参照例
- E-10: `database.sql` - ACL関連テーブル定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | privilegesActionはHTTPステータス403を設定する | E-01 行65 setRawHeader('HTTP/1.1 403 Forbidden') | ○ |
| C-02 | タイトルは「HTTP/1.1 403 Forbidden」 | E-01 行66 | ○ |
| C-03 | メッセージは「You don't have permission to access this resource.」 | E-01 行67 | ○ |
| C-04 | レイアウトは「admin-auth」を使用 | E-01 行63 setLayout()呼び出し, 行13 'admin-auth'設定 | ○ |
| C-05 | preDispatchで認証状態を確認しACLを構築 | E-02 行17-40 | ○ |
| C-06 | privileges.phtmlでメッセージを表示 | E-03 行19-22 | ○ |
| C-07 | URLパターンは/admin/error/privileges | E-01クラス名・メソッド名から推定 | ○ |
| C-08 | 画面No.93は「権限エラー画面」 | E-07 行94 | ○ |
| C-09 | 関連機能はNo.61「アクセス制御」 | E-06 行205 | ○ |
| C-10 | admin-authレイアウトはナビゲーションメニューを含まない | E-04 全体構造を確認 | ○ |
| C-11 | 権限チェックは$this->view->acl->isAllowed()で行われる | E-08 行32, E-09 行44等 | ○ |
| C-12 | 権限チェック失敗時は_forward('privileges','error','admin')で転送 | E-08 行47, E-09 行45等 | ○ |
| C-13 | CMS_Acl_FactoryがusersテーブルからACLを構築 | E-05 行42-82 | ○ |
| C-14 | users_rolesテーブルにロール情報が格納 | E-10 行576-590 | ○ |
| C-15 | users_resourcesテーブルにリソース情報が格納 | E-10 行483-520 | ○ |
| C-16 | users_privilegesテーブルに権限情報が格納 | E-10 行367-398 | ○ |
| C-17 | headTitleでサイト名とエラーを連結 | E-03 行16 | ○ |
| C-18 | dojo.parserをonloadで実行 | E-03 行9 | ○ |
| C-19 | 複数リソースの組み合わせで権限チェックされる場合がある | E-08 行57 (aarticles & aarticleedit) | ○ |
| C-20 | 権限チェックは各管理コントローラーで実施される | E-08, E-09 および他コントローラーで確認 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張にソースコード上の根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードに基づいた記述であり、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] privilegesActionのHTTPステータスコード設定が適切か確認
- [ ] エラーメッセージが英語のみであることを確認（多言語対応の必要性検討）
- [ ] 各コントローラーでの権限チェックパターンが一貫しているか確認
- [ ] ACL構築時のデータベースクエリが適切にキャッシュされているか確認（パフォーマンス観点）
- [ ] 権限エラー発生時のログ出力が適切に行われているか確認（監査ログ観点）
