---
generated_at: 2026-02-11 18:15:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：結合テストケース一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **IT-024（Google Maps Geocoding）**：外部API連携の実際の動作確認が必要
  2. **IT-039（Remember Me）**：Cookie設定のセキュリティ検証が必要
  3. **IT-004/IT-016（メール送信）**：メール送信設定の環境依存性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/legacycms-master/application/modules/admin/controllers/AuthController.php`
- E-02: `/Users/tomoka.baba/Work/legacycms-master/application/modules/admin/controllers/ArticlesController.php`
- E-03: `/Users/tomoka.baba/Work/legacycms-master/application/models/Articles.php`
- E-04: `/Users/tomoka.baba/Work/legacycms-master/application/modules/admin/controllers/PagesController.php`
- E-05: `/Users/tomoka.baba/Work/legacycms-master/application/models/Pages.php`
- E-06: `/Users/tomoka.baba/Work/legacycms-master/application/modules/admin/controllers/UsersController.php`
- E-07: `/Users/tomoka.baba/Work/legacycms-master/application/modules/admin/controllers/EventsController.php`
- E-08: `/Users/tomoka.baba/Work/legacycms-master/application/modules/admin/controllers/CommentsController.php`
- E-09: `/Users/tomoka.baba/Work/legacycms-master/application/models/Comments.php`
- E-10: `/Users/tomoka.baba/Work/legacycms-master/application/models/Mail.php`
- E-11: `/Users/tomoka.baba/Work/legacycms-master/application/models/Tags.php`
- E-12: `/Users/tomoka.baba/Work/legacycms-master/database.sql`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: ログイン成功時にセッションが作成され管理画面にリダイレクト | E-01 (loginAction L59-162) | ○ |
| C-02 | IT-002: 存在しないユーザーでFAILURE_IDENTITY_NOT_FOUND | E-01 (loginAction L140-143) | ○ |
| C-03 | IT-003: パスワード不一致でFAILURE_CREDENTIAL_INVALID | E-01 (loginAction L144-146) | ○ |
| C-04 | IT-004: パスワードリセットでDB更新とメール送信 | E-01 (passwordAction L171-256) | ○ |
| C-05 | IT-005: 記事作成でarticlesテーブルにINSERT | E-02 (newAction), E-03 (newArticle) | ○ |
| C-06 | IT-006: 記事更新でarticle_editが更新 | E-02 (saveAction), E-03 (updateArticle L314-369) | ○ |
| C-07 | IT-007: 記事削除で関連タグ・コメントも削除 | E-03 (deleteArticle L260-277) | ○ |
| C-08 | IT-008: 記事公開でステータスと公開日時が更新 | E-02 (publishAction), E-03 (updateArticleStatus) | ○ |
| C-09 | IT-009: カテゴリ削除時に記事がデフォルトカテゴリに移動 | E-03 (deleteCategory L283-308) | ○ |
| C-10 | IT-010: ページ作成でpagesテーブルにINSERT | E-04 (newAction), E-05 (newPage) | ○ |
| C-11 | IT-011: ページ更新でスラッグ重複チェック | E-04 (saveAction L141-162) | ○ |
| C-12 | IT-012: ページ削除で関連タグも削除 | E-05 (deletePage L187-201) | ○ |
| C-13 | IT-013: ユーザー作成でusersとusers_profilesにINSERT | E-06 (newAction L590-746) | ○ |
| C-14 | IT-014: ユーザー更新でusersとusers_profiles両方更新 | E-06 (saveAction L345-507) | ○ |
| C-15 | IT-015: ユーザー更新時にmail_subscriptions更新 | E-06 (saveAction L447-467) | ○ |
| C-16 | IT-016: 管理者パスワードリセットでDB更新とメール送信 | E-06 (passwordAction L263-340) | ○ |
| C-17 | IT-017: ロール保存時にusers_privileges更新 | E-06 (rolesaveAction L789-902) | ○ |
| C-18 | IT-018: ロール削除時にユーザー移行と権限削除 | E-06 (roledeleteAction L1012-1096) | ○ |
| C-19 | IT-019: イベント作成でeventsテーブルにINSERT | E-07 (new2Action L762-877) | ○ |
| C-20 | IT-020: イベント更新でeventsテーブル更新 | E-07 (saveAction L257-444) | ○ |
| C-21 | IT-021: イベント削除で関連コメントも削除 | E-07 (deleteAction L199-252) | ○ |
| C-22 | IT-022: イベントカテゴリ削除時にイベントがデフォルトカテゴリに移動 | E-07 (categorydeleteAction L979-1044) | ○ |
| C-23 | IT-023: ベニュー削除時にイベントがデフォルトベニューに移動 | E-07 (venuedeleteAction L1453-1519) | ○ |
| C-24 | IT-024: ベニュー作成時にGoogle Maps APIでジオコーディング | E-07 (venuenewAction L1524-1634) | △ |
| C-25 | IT-025: コメント削除でcommentsテーブルからDELETE | E-08 (deleteAction L165-205) | ○ |
| C-26 | IT-026: コメント承認でcomment_approved更新 | E-08 (approveAction L210-287) | ○ |
| C-27 | IT-027: メール作成でmailテーブルにINSERT | E-10 (newMail L310-328) | ○ |
| C-28 | IT-028: メール削除で関連添付ファイルも削除 | E-10 (deleteMail L352-366) | ○ |
| C-29 | IT-029: メールグループ削除時のメール移動と購読削除 | E-10 (deleteGroup L372-400) | ○ |
| C-30 | IT-030: 記事削除時にタグも削除（tag_type=A） | E-11 (deleteSlaveTag), E-03 (deleteArticle) | ○ |
| C-31 | IT-031: ページ削除時にタグも削除（tag_type=P） | E-11 (deleteSlaveTag), E-05 (deletePage) | ○ |
| C-32 | IT-032: 権限チェックによるアクセス許可 | E-02, E-04, E-06, E-07, E-08 (acl->isAllowed) | ○ |
| C-33 | IT-033: 権限チェックによるアクセス拒否 | E-02, E-04, E-06, E-07, E-08 (_forward privileges error) | ○ |
| C-34 | IT-034: 記事フィルタリングとページネーション | E-03 (fetchArticles L101-162) | ○ |
| C-35 | IT-035: ユーザー検索とフィルタリング | E-06 (manageAction L72-204) | ○ |
| C-36 | IT-036: イベントフィルタリング | E-07 (manageAction L123-194) | ○ |
| C-37 | IT-037: コメントフィルタリング | E-08 (manageAction L53-124), E-09 (fetchComments) | ○ |
| C-38 | IT-038: 新規ロール作成時の権限継承 | E-06 (rolenewAction L907-1007) | ○ |
| C-39 | IT-039: ログイン時のCookie設定（Remember Me） | E-01 (loginAction L130-136) | △ |
| C-40 | IT-040: ログアウト処理とリダイレクト | E-01 (logoutAction L164-169) | ○ |
| C-41 | IT-041: ベニューフィルタリング | E-07 (venuesAction L1318-1379) | ○ |
| C-42 | IT-042: 記事カテゴリ更新 | E-02 (categoryAction), E-03 (updateCategory) | ○ |
| C-43 | IT-043: イベントカテゴリ更新とベニュー連携 | E-07 (categorysaveAction L1121-1212) | ○ |
| C-44 | IT-044: メールグループ更新 | E-10 (updateGroup L424-442) | ○ |
| C-45 | IT-045: 記事詳細でのコメント表示 | E-08 (showAction L129-160) | ○ |

## 4) 不足情報（Unknown / Missing）
- **IT-024（Google Maps Geocoding）**：Google Maps API v2のgeocoding機能はdeprecated。現在のAPI仕様との互換性確認が必要
  - 候補：Google Maps Platform公式ドキュメント / APIキー設定ファイル / エラーハンドリング実装
- **IT-039（Remember Me Cookie）**：Cookieにパスワードを平文で保存している可能性。セキュリティ上の懸念
  - 候補：セキュリティ要件定義書 / 暗号化仕様
- **IT-004/IT-016（メール送信）**：Zend_Mail設定の環境依存性。SMTPサーバー設定の確認が必要
  - 候補：application/configs/*.ini / registry->mail設定

## 5) リスクフラグ（レビュー観点）
- **2: 高リスク** - IT-024: 外部API（Google Maps）のdeprecated API使用の可能性
- **2: 高リスク** - IT-039: Cookieへのパスワード平文保存のセキュリティリスク
- **1: 中リスク** - IT-004/IT-016: メール送信機能の環境依存性
- **1: 中リスク** - SQL構築におけるパラメータバインディングの一部不備（直接文字列結合）
- **0: 低リスク** - その他のDB連携テストケースは実装コードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] IT-024: Google Maps APIキーの有効性と現行APIとの互換性を確認
- [ ] IT-039: Cookieセキュリティの設計意図を確認（HttpOnly, Secure属性等）
- [ ] IT-004/IT-016: テスト環境でのメール送信設定を確認
- [ ] ACL関連テスト（IT-032/IT-033）: users_privilegesテーブルのテストデータ準備を確認
- [ ] 外部キー制約がない環境での整合性テスト手順を確認（MyISAMエンジン使用）
- [ ] ページネーション境界値テストの追加検討
