# 通知設計書 1-パスワードリセット通知（管理画面）

## 概要

本ドキュメントは、管理画面からパスワードをリセットした際にユーザーに送信されるパスワードリセット通知メールの設計仕様を記載する。

### 本通知の処理概要

本通知は、管理画面のパスワードリセット機能を使用してユーザーがパスワードを忘れた場合に、新しいパスワードを生成してメールで通知する機能である。

**業務上の目的・背景**：ユーザーがパスワードを忘れた場合、システムへのアクセスを回復する手段として不可欠な機能である。管理画面からのパスワードリセットは、管理者自身または特定の権限を持つユーザーがアクセスする際に使用され、システムのセキュリティを維持しながらも利便性を確保するために設計されている。

**通知の送信タイミング**：管理画面のパスワードリセットフォーム（/admin/auth/password）で有効なメールアドレスを入力し、フォームをPOST送信した際に送信される。バリデーション成功後、データベースのパスワード更新完了時にメール送信が実行される。

**通知の受信者**：パスワードリセットをリクエストしたユーザー本人。usersテーブルに登録されているメールアドレス（user_email）宛に送信される。

**通知内容の概要**：新しく生成されたランダムパスワード（8文字）と、サイト名およびサイトURLが含まれるテキストメール。

**期待されるアクション**：受信者はメールに記載された新しいパスワードを使用してログインし、セキュリティのため速やかにパスワードを変更することが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

パスワードリセットフォームで入力されたメールアドレスに対応するユーザーを、usersテーブルから検索して送信先を決定する。user_emailカラムに対してZend_Validate_Db_RecordExistsによる存在確認バリデーションが実行される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | {registry.site.site.email} |
| 送信元名称 | {registry.site.site.name} |
| 件名 | New Password For {registry.site.site.name} |
| 形式 | テキスト |

### 本文テンプレート

```
You have received this e-mail because you (or someone else) have asked for a new password for {site_name}.

Your new password is: {password}

Regards,
{site_name}
{site_url}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルは送信されない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| site_name | サイト名 | registry.site.site.name | Yes |
| site_url | サイトURL | registry.site.site.url | Yes |
| password | 新規生成パスワード | generatePassword()関数で生成 | Yes |
| user_email | 受信者メールアドレス | users.user_email | Yes |
| user_name | 受信者氏名 | users_profiles.upro_first + upro_last | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | パスワードリセットフォーム送信 | メールアドレスがusersテーブルに存在する | 管理画面の/admin/auth/passwordでフォームをPOST送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| メールアドレス未登録 | 入力されたメールアドレスがusersテーブルに存在しない場合、メールは送信されない |
| バリデーションエラー | メールアドレス形式が不正な場合、メールは送信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[パスワードリセットフォーム送信] --> B{バリデーションチェック}
    B -->|メールアドレス形式不正| C[エラーメッセージ表示]
    B -->|メールアドレス未登録| C
    B -->|バリデーション成功| D[ユーザー情報取得]
    D --> E[新規パスワード生成]
    E --> F[新規Salt生成]
    F --> G[パスワードハッシュ化]
    G --> H[usersテーブル更新]
    H --> I[Zend_Mailインスタンス生成]
    I --> J[メール本文設定]
    J --> K[送信元・送信先設定]
    K --> L[メール送信実行]
    L --> M[送信完了画面表示]
    C --> N[終了]
    M --> N
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー情報取得 | メールアドレス、ユーザーID |
| users_profiles | プロフィール情報取得 | 氏名（姓名） |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| user_id | ユーザー識別 | WHERE user_email = ? |
| user_email | 送信先メールアドレス | WHERE user_email = ? |

#### users_profiles

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| upro_first | 名（First Name） | WHERE upro_userid = user_id |
| upro_last | 姓（Last Name） | WHERE upro_userid = user_id |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| users | UPDATE | パスワードとSaltの更新 |

#### usersテーブル更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | user_password | md5(site_key + password + salt) | MD5ハッシュ化されたパスワード |
| UPDATE | user_salt | ランダム生成文字列（8文字） | パスワードハッシュ用Salt |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| メールアドレス未入力 | フォームでメールアドレスが空 | エラーメッセージ「Missing E-mail Address」を表示 |
| メールアドレス形式不正 | 入力値がメールアドレス形式でない | エラーメッセージ「Invalid E-mail Address」を表示 |
| ユーザー未登録 | メールアドレスがusersテーブルに存在しない | エラーメッセージ「Invalid E-mail Address - entered e-mail address is not associated with an existing account」を表示 |
| メール送信失敗 | SMTP接続エラー等 | Zend_Mailが例外をスロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限は設けられていない。24時間いつでも送信可能。

## セキュリティ考慮事項

- 新規パスワードはメール本文に平文で記載されるため、メール傍受のリスクがある
- パスワードは8文字のランダム文字列（英数字）で生成される
- パスワードはMD5ハッシュ化され、サイトキーとSaltと連結してデータベースに保存される
- MD5は現在推奨されないハッシュアルゴリズムであり、セキュリティ強化の検討が必要
- パスワードリセット要求に対するレート制限がないため、ブルートフォース攻撃のリスクがある

## 備考

- 本機能はZend Framework 1.x系のZend_Mailコンポーネントを使用している
- パスワード生成には`generatePassword()`メソッドを使用し、srand関数で乱数シードを初期化している
- 送信設定はレジストリ（`$registry->mail`）で管理されるトランスポート設定に依存する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、メール送信に必要なデータ構造を理解することが重要である。ユーザー情報とプロフィール情報の関係性を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | users テーブル | データベース | user_id, user_email, user_password, user_salt の構造 |
| 1-2 | users_profiles テーブル | データベース | upro_userid, upro_first, upro_last の構造 |

**読解のコツ**: Zend Framework 1.xではモデルクラスを使わず直接SQLビルダー（Zend_Db_Select）でクエリを構築することが多い。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーとアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AuthController.php | `application/modules/admin/controllers/AuthController.php` | passwordAction()メソッドがエントリーポイント |

**主要処理フロー**:
1. **行171**: `passwordAction()`メソッド開始
2. **行175**: POSTリクエストの判定
3. **行179-192**: バリデーション設定（メールアドレス形式、DB存在確認）
4. **行196**: バリデーション実行
5. **行200-208**: ユーザー情報のDB検索
6. **行212-213**: 新規パスワードとSalt生成
7. **行216-219**: パスワードハッシュデータ作成
8. **行222**: usersテーブル更新
9. **行224-235**: Zend_Mailでメール送信

#### Step 3: パスワード生成ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AuthController.php | `application/modules/admin/controllers/AuthController.php` | generatePassword()メソッド |

**主要処理フロー**:
- **行25-40**: generatePassword()メソッド
- **行27**: 使用文字セット（紛らわしい文字を除外したa-z, A-Z, 0-9）
- **行28**: srandで乱数シード初期化
- **行32-36**: 8文字のランダム文字列生成ループ

### プログラム呼び出し階層図

```
Admin_AuthController::passwordAction()
    │
    ├─ Zend_Filter_Input (バリデーション)
    │      └─ Zend_Validate_Db_RecordExists (users.user_email)
    │
    ├─ Zend_Registry::getInstance()->db->select() (ユーザー情報取得)
    │      └─ users + users_profiles JOIN
    │
    ├─ generatePassword() (パスワード生成)
    │
    ├─ Zend_Registry::getInstance()->db->update() (パスワード更新)
    │
    └─ Zend_Mail (メール送信)
           ├─ setBodyText()
           ├─ setFrom()
           ├─ addTo()
           ├─ setSubject()
           └─ send()
```

### データフロー図

```
[入力]               [処理]                    [出力]

POSTデータ ───────▶ バリデーション ───────▶ エラー/続行判定
(email)                    │
                           ▼
                    ユーザー情報取得
                    (users + profiles)
                           │
                           ▼
                    パスワード生成 ───────▶ 新パスワード(8文字)
                    Salt生成 ────────────▶ 新Salt(8文字)
                           │
                           ▼
                    ハッシュ化 ───────────▶ MD5(key+pass+salt)
                           │
                           ▼
                    DB更新 ───────────────▶ usersテーブル
                           │
                           ▼
                    メール送信 ───────────▶ ユーザーメールアドレス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AuthController.php | `application/modules/admin/controllers/AuthController.php` | ソース | パスワードリセット処理のコントローラー |
| CMS_Controller_Action_Auth | `library/CMS/Controller/Action/Auth.php` | ソース | 認証系コントローラーの基底クラス |
| password.phtml | `application/modules/admin/views/scripts/auth/password.phtml` | テンプレート | パスワードリセットフォームのビュー |
| admin-auth.phtml | `application/layouts/scripts/admin-auth.phtml` | テンプレート | 認証画面用レイアウト |
