# 通知設計書 4-アカウント有効化完了通知

## 概要

本ドキュメントは、アカウント有効化完了時にログインURLと設定URLを含むメールを送信する機能の設計仕様を記載する。

### 本通知の処理概要

本通知は、ユーザーがアカウント有効化リンクをクリックしてアカウントを有効化した際に、ログイン情報と関連URLを含む完了通知メールを送信する機能である。

**業務上の目的・背景**：アカウント有効化の完了をユーザーに確認させ、システム利用開始に必要な情報を提供するための機能である。ログインURL、設定変更URL、パスワードリセットURLを提供することで、ユーザーが次に取るべきアクションを明確にし、システムの利用開始をスムーズにする。また、アカウント有効化の完了記録としてメールを残すことで、後日の問い合わせ対応にも役立つ。

**通知の送信タイミング**：有効化URL（/auth/activate/id/{id}/key/{key}/）にアクセスし、ユーザーID・キーの検証が成功してユーザーステータスがactiveに更新された後にメール送信が実行される。

**通知の受信者**：有効化を完了したユーザー本人。usersテーブルに登録されているメールアドレス（user_email）宛に送信される。

**通知内容の概要**：有効化完了メッセージと、ログインURL、設定URL、パスワードリセットURLが含まれるテキストメール。

**期待されるアクション**：受信者はメールに記載されたログインURLからシステムにログインし、必要に応じて設定変更を行うことが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

有効化URLのパラメータ（id, key）から対象ユーザーを特定し、usersテーブルから取得したメールアドレスに送信する。user_id, user_key, user_status='inactive'の3条件でユーザーを特定する。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | {registry.site.site.email} |
| 送信元名称 | {registry.site.site.name} |
| 件名 | {registry.site.site.name} Account Activated |
| 形式 | テキスト |

### 本文テンプレート

```
Thank you for activating your account.

You can login to your account here: {site_url}/auth/login/

You can change your account settings here: {site_url}/settings/

If you have forgotten your password you can reset it here: {site_url}/auth/password/

Regards,
{site_name}
{site_url}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルは送信されない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| site_name | サイト名 | registry.site.site.name | Yes |
| site_url | サイトURL | registry.site.site.url | Yes |
| user_email | 受信者メールアドレス | users.user_email | Yes |
| user_name | 受信者氏名 | users_profiles.upro_first + upro_last | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| URL操作 | 有効化URLアクセス | ユーザーID・キー検証成功かつステータスがinactive | /auth/activate/id/{id}/key/{key}/にGETアクセス |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ユーザー未存在 | 指定されたIDのユーザーが存在しない場合 |
| キー不一致 | 指定されたキーがuser_keyと一致しない場合 |
| 既に有効化済み | user_statusが'active'以外でない（inactiveでない）場合 |
| パラメータ不足 | idまたはkeyパラメータが不足している場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[有効化URLアクセス] --> B{パラメータ存在チェック}
    B -->|id/key不足| C[エラーメッセージ表示]
    B -->|パラメータあり| D[ユーザー検索]
    D --> E{ユーザー存在 & key一致 & inactive?}
    E -->|条件不一致| C
    E -->|条件一致| F[user_status を active に更新]
    F --> G[Zend_Mailインスタンス生成]
    G --> H[メール本文設定]
    H --> I[送信元・送信先設定]
    I --> J[メール送信実行]
    J --> K[view->posted = 'Y' 設定]
    K --> L[ログインページへリダイレクト]
    C --> M[終了]
    L --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー情報取得・検証 | id, key, statusの3条件で検索 |
| users_profiles | プロフィール情報取得 | 氏名取得用 |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| user_id | ユーザー識別 | URLパラメータから |
| user_email | 送信先メールアドレス | WHERE user_id = ? AND user_key = ? AND user_status = 'inactive' |
| user_key | 有効化キー検証 | WHERE条件 |
| user_status | ステータス検証 | WHERE条件 |

#### users_profiles

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| upro_first | 名（First Name） | JOIN ON upro_userid = user_id |
| upro_last | 姓（Last Name） | JOIN ON upro_userid = user_id |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| users | UPDATE | ステータスをactiveに変更 |

#### usersテーブル更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | user_status | 'active' | WHERE user_id = {検証済みユーザーID} |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| パラメータ不足 | idまたはkeyが未指定 | エラーメッセージ「Invalid Credentials - the credentials you supplied cannot be matched to an account awaiting activation」を表示 |
| ユーザー不存在 | 指定条件に一致するユーザーがいない | 同上のエラーメッセージを表示 |
| メール送信失敗 | SMTP接続エラー等 | Zend_Mailが例外をスロー（catch処理なし） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限は設けられていない。24時間いつでも送信可能。

## セキュリティ考慮事項

- 有効化URLにはユーザーIDとキーが含まれるため、URLの漏洩リスクに注意
- 有効化キーはmd5(email + password)で生成されており、予測困難性が低い可能性がある
- 有効化URLに有効期限が設定されていない
- 有効化処理後はログインページにリダイレクトされ、methodパラメータでactivatedフラグが渡される

## 備考

- 本機能はZend Framework 1.x系のZend_Mailコンポーネントを使用している
- 有効化成功後は/auth/login?method=activatedにリダイレクトされる
- 送信設定はレジストリ（`$registry->mail`）で管理されるトランスポート設定に依存する
- 有効化処理とメール送信の間にトランザクション制御がない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、有効化処理に必要なデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | users テーブル | データベース | user_id, user_email, user_key, user_status の構造と関係 |
| 1-2 | users_profiles テーブル | データベース | upro_userid, upro_first, upro_last の構造 |

**読解のコツ**: 有効化処理ではuser_statusの状態遷移（inactive -> active）が重要。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーとアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AuthController.php | `application/modules/default/controllers/AuthController.php` | activateAction()メソッドがエントリーポイント |

**主要処理フロー**:
1. **行463**: `activateAction()`メソッド開始
2. **行465-466**: URLパラメータ（id, key）の取得
3. **行468**: パラメータ存在チェック
4. **行470**: レジストリ取得
5. **行473-479**: ユーザー検索SQL（user_id, user_key, user_status='inactive'の3条件）
6. **行482**: 検索結果取得
7. **行484**: ユーザー存在チェック
8. **行486**: ユーザー情報をviewに設定
9. **行489-491**: ステータス更新データ作成
10. **行494**: usersテーブルUPDATE
11. **行496-511**: Zend_Mailでメール送信
12. **行513**: view->posted = 'Y' 設定
13. **行515**: ログインページへリダイレクト

### プログラム呼び出し階層図

```
AuthController::activateAction()
    │
    ├─ URLパラメータ取得 (id, key)
    │
    ├─ Zend_Registry::getInstance()->db->select() (ユーザー検索)
    │      └─ users + users_profiles JOIN
    │          WHERE user_id = ? AND user_key = ? AND user_status = 'inactive'
    │
    ├─ Zend_Registry::getInstance()->db->update() (ステータス更新)
    │      └─ users (user_status = 'active')
    │
    ├─ Zend_Mail (メール送信)
    │      ├─ setBodyText()
    │      ├─ setFrom()
    │      ├─ addTo()
    │      ├─ setSubject()
    │      └─ send()
    │
    └─ _helper->redirector() (ログインページへ)
           └─ /auth/login?method=activated
```

### データフロー図

```
[入力]                    [処理]                    [出力]

URLパラメータ ─────▶ パラメータ検証 ─────────▶ エラー/続行判定
(id, key)                  │
                           ▼
                     ユーザー検索
                     (user_id + key + inactive)
                           │
                           ▼
                     ステータス更新 ────────▶ users.user_status = 'active'
                           │
                           ▼
                     メール本文生成
                     - ログインURL
                     - 設定URL
                     - パスワードリセットURL
                           │
                           ▼
                     メール送信 ────────────▶ ユーザーメールアドレス
                           │
                           ▼
                     リダイレクト ──────────▶ /auth/login?method=activated
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AuthController.php | `application/modules/default/controllers/AuthController.php` | ソース | アカウント有効化処理のコントローラー |
| CMS_Controller_Action_Auth | `library/CMS/Controller/Action/Auth.php` | ソース | 認証系コントローラーの基底クラス |
| activate.phtml | `application/modules/default/views/scripts/auth/activate.phtml` | テンプレート | 有効化画面のビュー |
| login.phtml | `application/modules/default/views/scripts/auth/login.phtml` | テンプレート | リダイレクト先のログイン画面 |
