# 通知設計書 5-管理者パスワードリセット通知

## 概要

本ドキュメントは、管理者がユーザーのパスワードをリセットした際に、新しいパスワードをメールで通知する機能の設計仕様を記載する。

### 本通知の処理概要

本通知は、管理者がユーザー管理画面から特定ユーザーのパスワードをリセットした際に、対象ユーザーに新しいパスワードを含むメールを送信する機能である。

**業務上の目的・背景**：ユーザーからのパスワード忘れの問い合わせに対して、管理者が直接対応できる機能である。ユーザー自身がパスワードリセット機能を利用できない場合（メールアクセス不可、操作方法不明など）に、管理者介入によるアカウント復旧手段として機能する。ヘルプデスク業務の一環として使用されることを想定している。

**通知の送信タイミング**：管理画面のユーザー管理（/admin/users/password）でパスワードリセット確認ダイアログを経てconfirm=1でリクエストした際に送信される。

**通知の受信者**：パスワードリセット対象となったユーザー本人。usersテーブルに登録されているメールアドレス（user_email）宛に送信される。

**通知内容の概要**：新しく生成されたランダムパスワード（8文字）と、サイト名およびサイトURLが含まれるテキストメール。管理者によるリセットである旨も記載される。

**期待されるアクション**：受信者はメールに記載された新しいパスワードを使用してログインし、セキュリティのため速やかにパスワードを変更することが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

URLパラメータで指定されたユーザーIDに対応するユーザーを、usersテーブルから検索して送信先を決定する。管理者の権限チェック（uusers + upassword）が事前に行われる。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | {registry.site.site.email} |
| 送信元名称 | {registry.site.site.name} |
| 件名 | Password Reset |
| 形式 | テキスト |

### 本文テンプレート

```
Your password has been reset by a Site Administrator.

Your new password is: {password}

Regards,
{site_name}
{site_url}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルは送信されない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| site_name | サイト名 | registry.site.site.name | Yes |
| site_url | サイトURL | registry.site.site.url | Yes |
| password | 新規生成パスワード | generatePassword()関数で生成 | Yes |
| user_email | 受信者メールアドレス | users.user_email | Yes |
| user_name | 受信者氏名 | users_profiles.upro_first + upro_last | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | パスワードリセット確認ボタン押下 | confirm=1かつ管理者権限あり | 管理画面の/admin/users/password/id/{id}/confirm/1/ |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 権限不足 | 操作者にuusersまたはupassword権限がない場合 |
| ユーザーID未指定 | URLパラメータにidが含まれていない場合 |
| 確認未完了 | confirm=1でない（初回表示時）場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[パスワードリセットリクエスト] --> B{権限チェック}
    B -->|権限なし| C[権限エラー画面]
    B -->|権限あり| D{confirm=1?}
    D -->|No| E[確認ダイアログ表示]
    D -->|Yes| F[ユーザー情報取得]
    F --> G[新規パスワード生成]
    G --> H[新規Salt生成]
    H --> I[パスワードハッシュ化]
    I --> J[usersテーブル更新]
    J --> K[Zend_Mailインスタンス生成]
    K --> L[メール本文設定]
    L --> M[送信元・送信先設定]
    M --> N[メール送信実行]
    N --> O[完了メッセージ表示]
    C --> P[終了]
    E --> P
    O --> P
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー情報取得 | メールアドレス、ユーザーID |
| users_profiles | プロフィール情報取得 | 氏名（姓名） |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| user_id | ユーザー識別 | WHERE user_id = ? |
| user_email | 送信先メールアドレス | WHERE user_id = ? |

#### users_profiles

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| upro_first | 名（First Name） | JOIN ON upro_userid = user_id |
| upro_last | 姓（Last Name） | JOIN ON upro_userid = user_id |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| users | UPDATE | パスワードとSaltの更新 |

#### usersテーブル更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | user_password | md5(site_key + password + salt) | MD5ハッシュ化されたパスワード |
| UPDATE | user_salt | ランダム生成文字列（8文字） | パスワードハッシュ用Salt |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 権限エラー | uusersまたはupassword権限がない | 権限エラー画面（privileges）にフォワード |
| ユーザーID未指定 | URLパラメータにidがない | 確認ダイアログを表示（実質的にはエラー） |
| メール送信失敗 | SMTP接続エラー等 | Zend_Mailが例外をスロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限は設けられていない。24時間いつでも送信可能。

## セキュリティ考慮事項

- 新規パスワードはメール本文に平文で記載されるため、メール傍受のリスクがある
- パスワードは8文字のランダム文字列（英数字）で生成される
- パスワードはMD5ハッシュ化され、サイトキーとSaltと連結してデータベースに保存される
- MD5は現在推奨されないハッシュアルゴリズムであり、セキュリティ強化の検討が必要
- 管理者権限（uusers + upassword）による操作制限あり
- 確認ダイアログによる誤操作防止機能あり
- 監査ログ機能は実装されていない

## 備考

- 本機能はZend Framework 1.x系のZend_Mailコンポーネントを使用している
- パスワード生成には`generatePassword()`メソッドを使用
- AJAX経由のダイアログ操作（getDialog関数）が使用される
- 完了時にはJavaScriptでページリロードが実行される
- 送信設定はレジストリ（`$registry->mail`）で管理されるトランスポート設定に依存する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、メール送信に必要なデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | users テーブル | データベース | user_id, user_email, user_password, user_salt の構造 |
| 1-2 | users_profiles テーブル | データベース | upro_userid, upro_first, upro_last の構造 |

**読解のコツ**: 管理者によるパスワードリセットは、ユーザー自身によるリセット（No.1, No.2）と同様の更新処理を行う。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーとアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | passwordAction()メソッドがエントリーポイント |

**主要処理フロー**:
1. **行263**: `passwordAction()`メソッド開始
2. **行265**: 権限チェック（uusers AND upassword）
3. **行267-268**: レイアウト・ビュー無効化
4. **行270-271**: URLパラメータ取得（confirm, id）
5. **行273**: confirm=1かつユーザーID存在チェック
6. **行275**: レジストリ取得
7. **行278-282**: ユーザー検索SQL（users + users_profiles JOIN）
8. **行285**: 検索結果取得
9. **行287**: ユーザー情報をviewに設定
10. **行289-290**: 新規パスワードとSalt生成
11. **行292-295**: パスワードハッシュデータ作成
12. **行297**: usersテーブルUPDATE
13. **行299-310**: Zend_Mailでメール送信
14. **行312-320**: 完了メッセージHTML出力

#### Step 3: パスワード生成ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | generatePassword()メソッド |

**主要処理フロー**:
- **行44-59**: generatePassword()メソッド
- **行46**: 使用文字セット（紛らわしい文字を除外したa-z, A-Z, 0-9）
- **行47**: srandで乱数シード初期化
- **行51-55**: 8文字のランダム文字列生成ループ

### プログラム呼び出し階層図

```
Admin_UsersController::passwordAction()
    │
    ├─ ACL権限チェック (uusers AND upassword)
    │
    ├─ URLパラメータ取得 (confirm, id)
    │
    ├─ Zend_Registry::getInstance()->db->select() (ユーザー情報取得)
    │      └─ users + users_profiles JOIN
    │
    ├─ generatePassword() (パスワード生成)
    │
    ├─ generatePassword() (Salt生成)
    │
    ├─ Zend_Registry::getInstance()->db->update() (パスワード更新)
    │
    └─ Zend_Mail (メール送信)
           ├─ setBodyText()
           ├─ setFrom()
           ├─ addTo()
           ├─ setSubject()
           └─ send()
```

### データフロー図

```
[入力]                    [処理]                    [出力]

URLパラメータ ─────▶ 権限チェック ──────────▶ エラー/続行判定
(id, confirm)              │
                           ▼
                     confirm判定
                           │
              ┌────────────┴────────────┐
              ▼                          ▼
         confirm!=1                 confirm=1
         確認ダイアログ              ユーザー情報取得
                                        │
                                        ▼
                                  パスワード生成 ───▶ 新パスワード(8文字)
                                  Salt生成 ────────▶ 新Salt(8文字)
                                        │
                                        ▼
                                  ハッシュ化 ────────▶ MD5(key+pass+salt)
                                        │
                                        ▼
                                  DB更新 ───────────▶ usersテーブル
                                        │
                                        ▼
                                  メール送信 ────────▶ ユーザーメールアドレス
                                        │
                                        ▼
                                  完了メッセージHTML
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UsersController.php | `application/modules/admin/controllers/UsersController.php` | ソース | 管理者パスワードリセット処理のコントローラー |
| CMS_Controller_Action_Admin | `library/CMS/Controller/Action/Admin.php` | ソース | 管理画面コントローラーの基底クラス |
| admin.phtml | `application/layouts/scripts/admin.phtml` | テンプレート | 管理画面用レイアウト |
