# 通知設計書 6-新規アカウント作成通知

## 概要

本ドキュメントは、管理者が新規ユーザーを作成した際に、アカウント情報（メールアドレスとパスワード）をメールで通知する機能の設計仕様を記載する。

### 本通知の処理概要

本通知は、管理者がユーザー管理画面から新規ユーザーアカウントを作成した際に、作成されたユーザーに対してログイン情報を含むメールを送信する機能である。

**業務上の目的・背景**：管理者によるユーザープロビジョニング機能である。ユーザー自身が登録するセルフサービス型とは異なり、管理者が組織内のユーザーアカウントを一括管理する場合に使用される。新規ユーザーに対して即座にログイン可能な状態で通知を送信し、システム利用開始の迅速化を図る。また、有効化ステップを省略して即時アクティブ状態でアカウントを作成できる点が特徴である。

**通知の送信タイミング**：管理画面の新規ユーザー作成フォーム（/admin/users/new）でユーザー情報を入力し、フォームをPOST送信した際に送信される。バリデーション成功後、ユーザーデータとプロフィールデータのDB挿入完了時にメール送信が実行される。

**通知の受信者**：新規作成されたユーザー本人。登録フォームで入力されたメールアドレス宛に送信される。

**通知内容の概要**：作成されたメールアドレスと自動生成されたパスワード、サイト名およびサイトURLが含まれるテキストメール。

**期待されるアクション**：受信者はメールに記載されたログイン情報を使用してシステムにログインし、セキュリティのため速やかにパスワードを変更することが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

管理者がフォームで入力したメールアドレスに対して送信する。ただし、Zend_Validate_Db_NoRecordExistsによりusersテーブルに同一メールアドレスが存在しないことを事前に確認する。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | {registry.site.site.email} |
| 送信元名称 | {registry.site.site.name} |
| 件名 | {registry.site.site.name} Account Details |
| 形式 | テキスト |

### 本文テンプレート

```
An administrator has created your account.

You account details are:

E-mail Address: {email}
Password: {password}

Regards,
{site_name}
{site_url}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルは送信されない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| site_name | サイト名 | registry.site.site.name | Yes |
| site_url | サイトURL | registry.site.site.url | Yes |
| email | ログイン用メールアドレス | 入力フォームから | Yes |
| password | 自動生成パスワード | createRandomPassword()で生成 | Yes |
| user_name | 受信者氏名 | 入力フォームから（first + last） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 新規ユーザー作成フォーム送信 | 全バリデーション成功かつ管理者権限あり | 管理画面の/admin/users/newでフォームをPOST送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 権限不足 | 操作者にuusersまたはunewuser権限がない場合 |
| メールアドレス重複 | 入力されたメールアドレスがusersテーブルに既に存在する場合 |
| エイリアス重複 | 入力されたエイリアスがusersテーブルに既に存在する場合 |
| バリデーションエラー | 必須項目の未入力、形式不正など |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[新規ユーザー作成フォーム送信] --> B{権限チェック}
    B -->|権限なし| C[権限エラー画面]
    B -->|権限あり| D{バリデーションチェック}
    D -->|メールアドレス重複| E[エラーメッセージ表示]
    D -->|エイリアス重複| E
    D -->|バリデーション成功| F[パスワード自動生成]
    F --> G[ユーザーキー生成]
    G --> H[usersテーブルINSERT]
    H --> I[lastInsertId取得]
    I --> J[users_profilesテーブルINSERT]
    J --> K[Zend_Mailインスタンス生成]
    K --> L[メール本文設定]
    L --> M[送信元・送信先設定]
    M --> N[メール送信実行]
    N --> O[完了メッセージ表示]
    C --> P[終了]
    E --> P
    O --> P
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | メールアドレス重複チェック | Zend_Validate_Db_NoRecordExists |

### テーブル別参照項目詳細

#### users（重複チェック用）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| user_email | メールアドレス重複確認 | バリデーション時 |
| user_alias | エイリアス重複確認 | バリデーション時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| users | INSERT | 新規ユーザー登録 |
| users_profiles | INSERT | プロフィール情報登録 |

#### usersテーブルINSERT

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | user_alias | 入力値 | ユーザーエイリアス |
| INSERT | user_email | 入力値 | メールアドレス |
| INSERT | user_role | 入力値 | ユーザーロール |
| INSERT | user_password | md5(password) | パスワード（MD5のみ、Saltなし） |
| INSERT | user_key | md5(email + password) | ユーザーキー |
| INSERT | user_date | NOW() | 登録日時 |
| INSERT | user_mailformat | 'text' | メール受信形式（固定値） |
| INSERT | user_status | 'active' | 初期ステータス（即時有効） |

#### users_profilesテーブルINSERT

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | upro_userid | lastInsertId() | ユーザーID |
| INSERT | upro_first | 入力値 | 名 |
| INSERT | upro_last | 入力値 | 姓 |
| INSERT | upro_country | 入力値 | 国 |
| INSERT | upro_date | NOW() | 登録日時 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 権限エラー | uusersまたはunewuser権限がない | 権限エラー画面（privileges）にフォワード |
| メールアドレス重複 | usersテーブルに同一メールアドレスが存在 | エラーメッセージ「Invalid E-mail Address - e-mail address in use」を表示 |
| エイリアス重複 | usersテーブルに同一エイリアスが存在 | エラーメッセージ「Invalid Alias - alias in use」を表示 |
| メール送信失敗 | SMTP接続エラー等 | Zend_Mailが例外をスロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限は設けられていない。24時間いつでも送信可能。

## セキュリティ考慮事項

- 新規パスワードはメール本文に平文で記載されるため、メール傍受のリスクがある
- パスワードはcreateRandomPassword()で自動生成される（実装は確認が必要）
- パスワードはMD5のみでハッシュ化され、Saltが使用されていない（他の処理と異なる実装）
- MD5は現在推奨されないハッシュアルゴリズムであり、セキュリティ強化の検討が必要
- 管理者権限（uusers + unewuser）による操作制限あり
- アカウントはuser_status='active'で作成され、有効化ステップを経ずに即時利用可能

## 備考

- 本機能はZend Framework 1.x系のZend_Mailコンポーネントを使用している
- パスワード生成には`createRandomPassword()`メソッドを使用（コード上での定義確認が必要）
- user_mailformatは'text'で固定登録される
- フロントからの登録（No.3）とは異なり、有効化プロセスがスキップされる
- Saltが使用されていないパスワードハッシュ実装は他の処理との一貫性がない
- 送信設定はレジストリ（`$registry->mail`）で管理されるトランスポート設定に依存する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ユーザー登録に必要なデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | users テーブル | データベース | user_id, user_email, user_alias, user_password, user_status の構造 |
| 1-2 | users_profiles テーブル | データベース | upro_userid, upro_first, upro_last, upro_country の構造 |

**読解のコツ**: 管理者作成とセルフ登録のデータ構造は同じだが、初期ステータスが異なる（active vs inactive）。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーとアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | newAction()メソッドがエントリーポイント |

**主要処理フロー**:
1. **行590**: `newAction()`メソッド開始
2. **行592**: 権限チェック（uusers AND unewuser）
3. **行594**: レイアウト無効化
4. **行599**: POSTリクエスト判定
5. **行601**: パスワード自動生成（createRandomPassword()）
6. **行603-652**: バリデーション設定
7. **行654**: バリデーション実行
8. **行656**: バリデーション成功判定
9. **行658**: レジストリ取得
10. **行660**: ユーザーキー生成
11. **行663-672**: ユーザーデータ作成
12. **行675**: usersテーブルINSERT
13. **行677**: lastInsertId取得
14. **行680-686**: プロフィールデータ作成
15. **行689**: users_profilesテーブルINSERT
16. **行691-705**: Zend_Mailでメール送信

### プログラム呼び出し階層図

```
Admin_UsersController::newAction()
    │
    ├─ ACL権限チェック (uusers AND unewuser)
    │
    ├─ createRandomPassword() (パスワード生成)
    │
    ├─ Zend_Filter_Input (バリデーション)
    │      ├─ Zend_Validate_Db_NoRecordExists (users.user_email)
    │      └─ Zend_Validate_Db_NoRecordExists (users.user_alias)
    │
    ├─ Zend_Registry::getInstance()->db->insert() (ユーザー登録)
    │      ├─ users
    │      └─ users_profiles
    │
    └─ Zend_Mail (メール送信)
           ├─ setBodyText()
           ├─ setFrom()
           ├─ addTo()
           ├─ setSubject()
           └─ send()
```

### データフロー図

```
[入力]                    [処理]                    [出力]

フォームデータ ─────▶ 権限チェック ──────────▶ エラー/続行判定
(email, alias,              │
first, last,                ▼
country, role)        バリデーション ──────────▶ エラー/続行判定
                           │
                           ▼
                     パスワード生成 ────────▶ ランダムパスワード
                     ユーザーキー生成 ─────▶ md5(email+pass)
                           │
                           ▼
                     DB INSERT ────────────▶ users (status='active')
                           │                users_profiles
                           ▼
                     メール本文生成
                     - Email: {email}
                     - Password: {password}
                           │
                           ▼
                     メール送信 ────────────▶ ユーザーメールアドレス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UsersController.php | `application/modules/admin/controllers/UsersController.php` | ソース | 新規ユーザー作成処理のコントローラー |
| CMS_Controller_Action_Admin | `library/CMS/Controller/Action/Admin.php` | ソース | 管理画面コントローラーの基底クラス |
| new.phtml | `application/modules/admin/views/scripts/users/new.phtml` | テンプレート | 新規ユーザー作成フォームのビュー |
| admin.phtml | `application/layouts/scripts/admin.phtml` | テンプレート | 管理画面用レイアウト |
