---
generated_at: 2026-02-11 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：2-パスワードリセット通知（フロント）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **ビューテンプレートファイルの存在**：ファイルシステム上での確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `application/modules/default/controllers/AuthController.php` - 行160-243
- E-02: `application/modules/default/controllers/AuthController.php` - 行37-52（generatepassword）
- E-03: `application/modules/default/controllers/AuthController.php` - 行212-223（Zend_Mail送信処理）
- E-04: `application/modules/default/controllers/AuthController.php` - 行166-180（バリデーション設定）
- E-05: `application/modules/default/controllers/AuthController.php` - 行188-196（ユーザー情報取得SQL）
- E-06: `application/modules/default/controllers/AuthController.php` - 行204-210（パスワード更新処理）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知No.2の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フロント画面のpasswordActionでパスワードリセット処理を実行 | E-01 | ○ |
| C-02 | 送信方式は同期（リクエスト処理内で直接送信） | E-03 | ○ |
| C-03 | Zend_Mailを使用してメール送信 | E-03 | ○ |
| C-04 | generatepassword()で8文字のパスワード生成（小文字メソッド名） | E-02 | ○ |
| C-05 | パスワード生成にsrand関数で乱数シード初期化 | E-02 | ○ |
| C-06 | メール件名は「New Password For {site_name}」 | E-03 (行222) | ○ |
| C-07 | 送信元アドレスはregistry.site.site.email | E-03 (行220) | ○ |
| C-08 | 送信元名称はregistry.site.site.name | E-03 (行220) | ○ |
| C-09 | メール形式はテキスト（setBodyText使用） | E-03 (行213) | ○ |
| C-10 | Zend_Validate_Db_RecordExistsでメールアドレス存在確認 | E-04 (行176) | ○ |
| C-11 | usersテーブルとusers_profilesテーブルをJOINで取得 | E-05 | ○ |
| C-12 | パスワードはMD5でハッシュ化 | E-06 (行205) | ○ |
| C-13 | site_key + password + saltの形式でハッシュ | E-06 (行205) | ○ |
| C-14 | Saltも別途generatepasswordで生成 | E-01 (行201) | ○ |
| C-15 | usersテーブルのuser_passwordとuser_saltを更新 | E-06 | ○ |
| C-16 | 送信先はuser_emailとupro_first + upro_last | E-03 (行221) | ○ |
| C-17 | リトライ機能なし | E-03 | ○ |
| C-18 | POSTリクエスト時のみ処理実行 | E-01 (行162) | ○ |
| C-19 | バリデーション失敗時はエラーメッセージ表示 | E-01 (行227-236) | ○ |
| C-20 | 成功時はview->posted = 'Y'を設定 | E-01 (行225) | ○ |
| C-21 | EmailAddressバリデータを使用 | E-04 (行175) | ○ |
| C-22 | フィルタでStringTrim, StringToLowerを適用 | E-04 (行166-168) | ○ |
| C-23 | default モジュールのコントローラーで実装 | E-01 | ○ |
| C-24 | ビューテンプレートはpassword.phtml | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ビューテンプレート（password.phtml）の存在確認
  - 候補：`application/modules/default/views/scripts/auth/password.phtml`
  - 理由：コントローラー規約からの推測であり、実ファイルの読み込み確認が未実施

## 5) リスクフラグ（レビュー観点）
- リスク2（高）：フロント画面は一般公開されており、レート制限がないためDoS攻撃のリスクが高い
- リスク1（高）：MD5ハッシュアルゴリズムは現在非推奨。セキュリティ面での脆弱性あり
- リスク1（中）：パスワードをメール本文に平文で記載するセキュリティリスク
- リスク0（低）：ビューテンプレートの存在はZend Frameworkの規約に従えば高確率で存在

## 6) レビュアーチェックリスト（最小）
- [ ] password.phtmlテンプレートファイルの存在確認
- [ ] registry.site設定の実際の値確認
- [ ] SMTPトランスポート設定（$registry->mail）の確認
- [ ] フロント画面へのレート制限実装検討
- [ ] MD5ハッシュのセキュリティリスク許容可否の判断
- [ ] 管理画面版（No.1）との差分が意図的かどうかの確認
