---
generated_at: 2026-02-11 10:40:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：3-アカウント登録確認通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **ビューテンプレートファイルの存在**：ファイルシステム上での確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `application/modules/default/controllers/AuthController.php` - 行253-461
- E-02: `application/modules/default/controllers/AuthController.php` - 行255-265（CAPTCHA設定）
- E-03: `application/modules/default/controllers/AuthController.php` - 行412-429（Zend_Mail送信処理）
- E-04: `application/modules/default/controllers/AuthController.php` - 行282-352（バリデーション設定）
- E-05: `application/modules/default/controllers/AuthController.php` - 行364-391（DB INSERT処理）
- E-06: `application/modules/default/controllers/AuthController.php` - 行360-361（キー生成処理）
- E-07: `application/modules/default/controllers/AuthController.php` - 行394-410（メーリングリスト購読処理）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知No.3の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | registerActionでユーザー登録処理を実行 | E-01 | ○ |
| C-02 | 送信方式は同期（リクエスト処理内で直接送信） | E-03 | ○ |
| C-03 | Zend_Mailを使用してメール送信 | E-03 (行413) | ○ |
| C-04 | メール件名は「{site_name} Account Activation」 | E-03 (行425) | ○ |
| C-05 | 送信元アドレスはregistry.site.site.email | E-03 (行423) | ○ |
| C-06 | 送信元名称はregistry.site.site.name | E-03 (行423) | ○ |
| C-07 | メール形式はテキスト（setBodyText使用） | E-03 (行414) | ○ |
| C-08 | Zend_Validate_Db_NoRecordExistsでメールアドレス重複チェック | E-04 (行293) | ○ |
| C-09 | Zend_Validate_Db_NoRecordExistsでエイリアス重複チェック | E-04 (行301) | ○ |
| C-10 | usersテーブルにuser_status='inactive'でINSERT | E-05 (行372) | ○ |
| C-11 | users_profilesテーブルにプロフィールデータINSERT | E-05 (行380-391) | ○ |
| C-12 | mail_subscriptionsテーブルに購読データINSERT（選択時） | E-07 | ○ |
| C-13 | ユーザーキーはmd5(email + password)で生成 | E-06 (行361) | ○ |
| C-14 | Saltはgeneratepassword()で生成 | E-06 (行360) | ○ |
| C-15 | 有効化URLは/auth/activate/id/{id}/key/{key}/形式 | E-03 (行418) | ○ |
| C-16 | CAPTCHAはZend_Captcha_Imageを使用 | E-02 | ○ |
| C-17 | CAPTCHAフォントはEnvy Code R.ttfを使用 | E-02 (行257) | ○ |
| C-18 | CAPTCHAの文字数は7文字 | E-02 (行256) | ○ |
| C-19 | try-catchでメール送信エラーをハンドリング | E-03 (行412, 427) | ○ |
| C-20 | lastInsertId()でユーザーIDを取得 | E-05 (行378) | ○ |
| C-21 | パスワードはMD5でハッシュ化 | E-05 (行367) | ○ |
| C-22 | mail_groupsテーブルからmgroup_open='Y'の一覧取得 | E-01 (行270-276) | ○ |
| C-23 | POSTリクエスト時のみ処理実行 | E-01 (行278) | ○ |
| C-24 | バリデーション失敗時はview->posted = 'N'設定 | E-01 (行433) | ○ |
| C-25 | CAPTCHA検証も同時に実行 | E-01 (行356) | ○ |
| C-26 | パスワード最小文字数は8文字 | E-04 (行322) | ○ |
| C-27 | 国名は必須入力 | E-04 (行333-338) | ○ |
| C-28 | ビューテンプレートはregister.phtml | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ビューテンプレート（register.phtml）の存在確認
  - 候補：`application/modules/default/views/scripts/auth/register.phtml`
  - 理由：コントローラー規約からの推測であり、実ファイルの読み込み確認が未実施

## 5) リスクフラグ（レビュー観点）
- リスク2（高）：有効化キーがmd5(email+password)で予測可能性がある
- リスク2（高）：有効化リンクに有効期限がない
- リスク1（高）：MD5ハッシュアルゴリズムは現在非推奨
- リスク1（中）：メール送信エラー時に例外メッセージがそのまま出力される可能性
- リスク0（低）：ビューテンプレートの存在はZend Frameworkの規約に従えば高確率で存在

## 6) レビュアーチェックリスト（最小）
- [ ] register.phtmlテンプレートファイルの存在確認
- [ ] 有効化キー生成ロジックのセキュリティ評価
- [ ] 有効化リンクの有効期限実装検討
- [ ] registry.site設定の実際の値確認
- [ ] SMTPトランスポート設定（$registry->mail）の確認
- [ ] CAPTCHAフォントファイルの存在確認
- [ ] メール送信エラー時のエラーハンドリング改善検討
