---
generated_at: 2026-02-11 10:50:00
metrics:
  claims_total: 23
  claims_with_evidence: 23
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-管理者パスワードリセット通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：23 / 23、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、高信頼度

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `application/modules/admin/controllers/UsersController.php` - 行263-340
- E-02: `application/modules/admin/controllers/UsersController.php` - 行44-59（generatePassword）
- E-03: `application/modules/admin/controllers/UsersController.php` - 行299-310（Zend_Mail送信処理）
- E-04: `application/modules/admin/controllers/UsersController.php` - 行265（権限チェック）
- E-05: `application/modules/admin/controllers/UsersController.php` - 行278-285（ユーザー情報取得SQL）
- E-06: `application/modules/admin/controllers/UsersController.php` - 行292-297（パスワード更新処理）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知No.5の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | passwordActionでパスワードリセット処理を実行 | E-01 | ○ |
| C-02 | 送信方式は同期（リクエスト処理内で直接送信） | E-03 | ○ |
| C-03 | Zend_Mailを使用してメール送信 | E-03 (行299) | ○ |
| C-04 | generatePassword()で8文字のパスワード生成 | E-02 | ○ |
| C-05 | パスワード生成にsrand関数で乱数シード初期化 | E-02 (行47) | ○ |
| C-06 | メール件名は「Password Reset」 | E-03 (行309) | ○ |
| C-07 | 送信元アドレスはregistry.site.site.email | E-03 (行307) | ○ |
| C-08 | 送信元名称はregistry.site.site.name | E-03 (行307) | ○ |
| C-09 | メール形式はテキスト（setBodyText使用） | E-03 (行300) | ○ |
| C-10 | uusersとupassword両方の権限が必要 | E-04 | ○ |
| C-11 | usersとusers_profilesをJOINで取得 | E-05 | ○ |
| C-12 | パスワードはMD5でハッシュ化 | E-06 (行293) | ○ |
| C-13 | site_key + password + saltの形式でハッシュ | E-06 (行293) | ○ |
| C-14 | Saltも別途generatePasswordで生成 | E-01 (行290) | ○ |
| C-15 | usersテーブルのuser_passwordとuser_saltを更新 | E-06 | ○ |
| C-16 | 送信先はuser_emailとupro_first + upro_last | E-03 (行308) | ○ |
| C-17 | リトライ機能なし | E-03 | ○ |
| C-18 | confirm=1の場合のみ処理実行 | E-01 (行273) | ○ |
| C-19 | confirm!=1の場合は確認ダイアログ表示 | E-01 (行322-330) | ○ |
| C-20 | レイアウト無効化 | E-01 (行267) | ○ |
| C-21 | ビュー無効化 | E-01 (行268) | ○ |
| C-22 | 完了後にJavaScriptでページリロード | E-01 (行319) | ○ |
| C-23 | メール本文に「by a Site Administrator」記載 | E-03 (行300) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- リスク1（高）：MD5ハッシュアルゴリズムは現在非推奨。セキュリティ面での脆弱性あり
- リスク1（中）：パスワードをメール本文に平文で記載するセキュリティリスク
- リスク1（中）：監査ログ機能が実装されていないため、誰がいつリセットしたか追跡困難
- リスク0（低）：権限チェックによる不正操作防止は実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] registry.site設定の実際の値確認
- [ ] SMTPトランスポート設定（$registry->mail）の確認
- [ ] MD5ハッシュのセキュリティリスク許容可否の判断
- [ ] 監査ログ機能の追加検討
- [ ] ACL設定（uusers, upassword）の確認
