---
generated_at: 2026-02-11 10:55:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：6-新規アカウント作成通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **createRandomPassword()メソッドの定義場所**：ソースコード上で定義が確認できない
  2. **ビューテンプレートファイルの存在**：ファイルシステム上での確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `application/modules/admin/controllers/UsersController.php` - 行590-746
- E-02: `application/modules/admin/controllers/UsersController.php` - 行691-705（Zend_Mail送信処理）
- E-03: `application/modules/admin/controllers/UsersController.php` - 行603-652（バリデーション設定）
- E-04: `application/modules/admin/controllers/UsersController.php` - 行663-689（DB INSERT処理）
- E-05: `application/modules/admin/controllers/UsersController.php` - 行592（権限チェック）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知No.6の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | newActionで新規ユーザー作成処理を実行 | E-01 | ○ |
| C-02 | 送信方式は同期（リクエスト処理内で直接送信） | E-02 | ○ |
| C-03 | Zend_Mailを使用してメール送信 | E-02 (行691) | ○ |
| C-04 | メール件名は「{site_name} Account Details」 | E-02 (行704) | ○ |
| C-05 | 送信元アドレスはregistry.site.site.email | E-02 (行702) | ○ |
| C-06 | 送信元名称はregistry.site.site.name | E-02 (行702) | ○ |
| C-07 | メール形式はテキスト（setBodyText使用） | E-02 (行692) | ○ |
| C-08 | uusersとunewuser両方の権限が必要 | E-05 | ○ |
| C-09 | Zend_Validate_Db_NoRecordExistsでメールアドレス重複チェック | E-03 (行614) | ○ |
| C-10 | Zend_Validate_Db_NoRecordExistsでエイリアス重複チェック | E-03 (行622) | ○ |
| C-11 | usersテーブルにuser_status='active'でINSERT | E-04 (行671) | ○ |
| C-12 | users_profilesテーブルにプロフィールデータINSERT | E-04 (行680-689) | ○ |
| C-13 | ユーザーキーはmd5(email + password)で生成 | E-04 (行660) | ○ |
| C-14 | パスワードはmd5のみでハッシュ化（Saltなし） | E-04 (行667) | ○ |
| C-15 | user_mailformatは'text'固定 | E-04 (行670) | ○ |
| C-16 | レイアウト無効化 | E-01 (行594) | ○ |
| C-17 | POSTリクエスト時のみ処理実行 | E-01 (行599) | ○ |
| C-18 | バリデーション失敗時はview->posted = 'N'設定 | E-01 (行719) | ○ |
| C-19 | 名前に英字・ハイフン・アポストロフィ・スペースのみ許可 | E-03 (行629, 637) | ○ |
| C-20 | メール本文にメールアドレスを含む | E-02 (行696) | ○ |
| C-21 | メール本文にパスワードを含む | E-02 (行697) | ○ |
| C-22 | lastInsertId()でユーザーIDを取得 | E-04 (行677) | ○ |
| C-23 | ロールはDigitsバリデータで検証 | E-03 (行648) | ○ |
| C-24 | 国名は必須入力 | E-03 (行640-643) | ○ |
| C-25 | createRandomPassword()でパスワード生成 | **根拠なし** | △ |
| C-26 | ビューテンプレートはnew.phtml | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- createRandomPassword()メソッドの定義場所
  - 候補：UsersController.php内、または親クラス、または未定義（エラーの可能性）
  - 理由：コード上で呼び出されているが、同ファイル内にはgeneratePassword()のみ定義。基底クラスまたはヘルパーに存在する可能性
- ビューテンプレート（new.phtml）の存在確認
  - 候補：`application/modules/admin/views/scripts/users/new.phtml`
  - 理由：コントローラー規約からの推測であり、実ファイルの読み込み確認が未実施

## 5) リスクフラグ（レビュー観点）
- リスク2（高）：パスワードハッシュにSaltが使用されていない（他の処理と不整合）
- リスク2（高）：createRandomPassword()メソッドが見つからない（実行時エラーの可能性）
- リスク1（高）：MD5ハッシュアルゴリズムは現在非推奨
- リスク1（中）：パスワードをメール本文に平文で記載するセキュリティリスク
- リスク0（低）：ビューテンプレートの存在はZend Frameworkの規約に従えば高確率で存在

## 6) レビュアーチェックリスト（最小）
- [ ] createRandomPassword()メソッドの定義場所確認
- [ ] パスワードハッシュへのSalt追加検討（他処理との一貫性）
- [ ] new.phtmlテンプレートファイルの存在確認
- [ ] registry.site設定の実際の値確認
- [ ] SMTPトランスポート設定（$registry->mail）の確認
- [ ] ACL設定（uusers, unewuser）の確認
- [ ] MD5ハッシュのセキュリティリスク許容可否の判断
