---
generated_at: 2026-02-11 11:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：7-テストメール送信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **AttachmentsモデルのfetchAttachmentsメソッド**：モデルファイルの読み込み確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `application/modules/admin/controllers/MailController.php` - 行512-695
- E-02: `application/modules/admin/controllers/MailController.php` - 行586-644（メール送信処理）
- E-03: `application/modules/admin/controllers/MailController.php` - 行524-562（バリデーション設定）
- E-04: `application/modules/admin/controllers/MailController.php` - 行577-582（メール情報更新）
- E-05: `application/modules/admin/controllers/MailController.php` - 行514（権限チェック）
- E-06: `application/models/Mail.php` - 行270-284（fetchMail）
- E-07: `application/models/Mail.php` - 行406-418（updateMail）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知No.7の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sendtestActionでテストメール送信処理を実行 | E-01 | ○ |
| C-02 | 送信方式は同期（リクエスト処理内で直接送信） | E-02 | ○ |
| C-03 | Zend_Mailを使用してメール送信 | E-02 (行588) | ○ |
| C-04 | 送信先はログインユーザーのメールアドレス | E-02 (行591) | ○ |
| C-05 | 送信先表示名はログインユーザーのエイリアス | E-02 (行591) | ○ |
| C-06 | 送信元アドレスはregistry.site.site.email | E-02 (行590) | ○ |
| C-07 | 送信元名称はregistry.site.site.name | E-02 (行590) | ○ |
| C-08 | mmailとmmailsend両方の権限が必要 | E-05 | ○ |
| C-09 | テキスト本文はsetBodyTextで設定 | E-02 (行589) | ○ |
| C-10 | HTML本文はsetBodyHtmlで設定 | E-02 (行609) | ○ |
| C-11 | 添付ファイルはcreateAttachmentで添付 | E-02 (行594-600) | ○ |
| C-12 | mail_status='sent'の場合はエラー | E-01 (行575, 653-661) | ○ |
| C-13 | バリデーション前にメール情報を更新 | E-04 | ○ |
| C-14 | updateMail後に再度fetchMailで取得 | E-01 (行584) | ○ |
| C-15 | text/html両方ある場合は両方送信 | E-02 (行586-624) | ○ |
| C-16 | textのみの場合はテキストメール送信 | E-02 (行626-644) | ○ |
| C-17 | htmlのみの場合はHTMLメール送信 | E-02 (行606-624) | ○ |
| C-18 | 両方なしの場合も空本文で送信 | E-02 (行626-644) | ○ |
| C-19 | confirm=1の場合のみ処理実行 | E-01 (行522) | ○ |
| C-20 | confirm!=1の場合は確認ダイアログ表示 | E-01 (行677-686) | ○ |
| C-21 | レイアウト無効化 | E-01 (行516) | ○ |
| C-22 | ビュー無効化 | E-01 (行517) | ○ |
| C-23 | html_entity_decodeでHTML本文をデコード | E-04 (行581) | ○ |
| C-24 | 添付ファイルパスはsyspathから取得 | E-02 (行596) | ○ |
| C-25 | 添付ファイル名はasset_name + extension | E-02 (行598) | ○ |
| C-26 | Mailモデルでメール情報取得 | E-06 | ○ |
| C-27 | Mailモデルでメール情報更新 | E-07 | ○ |
| C-28 | Attachmentsモデルで添付ファイル情報取得 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- AttachmentsモデルのfetchAttachmentsメソッドの詳細確認
  - 候補：`application/models/Attachments.php`
  - 理由：コード上で呼び出されているが、モデルファイルの読み込み確認が未実施

## 5) リスクフラグ（レビュー観点）
- リスク1（中）：html_entity_decodeがXSS攻撃のリスクを含む可能性
- リスク1（中）：添付ファイルパスにパストラバーサルのリスク
- リスク0（低）：テスト送信は操作者本人にのみ送信されるため、誤送信リスクは低い
- リスク0（低）：権限チェックと確認ダイアログによる操作制限あり

## 6) レビュアーチェックリスト（最小）
- [ ] AttachmentsモデルのfetchAttachmentsメソッド確認
- [ ] registry.site設定の実際の値確認
- [ ] registry.assets.assets.syspath設定の確認
- [ ] SMTPトランスポート設定（$registry->mail）の確認
- [ ] ACL設定（mmail, mmailsend）の確認
- [ ] HTML本文のXSS対策確認
- [ ] 添付ファイルパスのセキュリティ確認
