---
generated_at: 2026-02-11 11:10:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：9-ロール別メール配信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **送信完了後のmail_status更新**：送信後にステータスが'sent'に更新されるか確認が必要
  2. **$htmltmailタイポ問題**：行936のタイポが実際にエラーを起こすか確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `application/modules/admin/controllers/MailController.php` - 行700-1158
- E-02: `application/modules/admin/controllers/MailController.php` - 行887-995（ロール別配信処理）
- E-03: `application/modules/admin/controllers/MailController.php` - 行889-942（text/html両方送信）
- E-04: `application/modules/admin/controllers/MailController.php` - 行891-893（fetchUsers呼び出し）
- E-05: `application/models/Mail.php` - 行249-264（fetchUsers）
- E-06: `application/models/Mail.php` - 行270-284（fetchMail）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知No.9の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sendActionでメール送信処理を実行 | E-01 | ○ |
| C-02 | mail_type='R'の場合にロール別配信実行 | E-02 (行887) | ○ |
| C-03 | Zend_Mailを使用してメール送信 | E-03 (行895) | ○ |
| C-04 | BCCでユーザーに送信 | E-02 (行903) | ○ |
| C-05 | Toにはサイトメールアドレスとサイト名を設定 | E-03 (行897) | ○ |
| C-06 | 送信元アドレスはregistry.site.site.email | E-03 (行899) | ○ |
| C-07 | 送信元名称はregistry.site.site.name | E-03 (行899) | ○ |
| C-08 | mmailとmmailsend両方の権限が必要 | E-01 (行702) | ○ |
| C-09 | text/html両方の場合は形式別に2回送信 | E-03 | ○ |
| C-10 | fetchUsersでrole=mail_slaveフィルタ | E-04 (行891) | ○ |
| C-11 | fetchUsersでformat='text'フィルタ | E-03 (行892) | ○ |
| C-12 | fetchUsersでformat='html'フィルタ | E-03 (行918) | ○ |
| C-13 | htmlのみの場合は全ユーザーにHTML送信 | E-02 (行943-967) | ○ |
| C-14 | textのみの場合は全ユーザーにテキスト送信 | E-02 (行969-993) | ○ |
| C-15 | fetchUsersでuser_roleフィルタ | E-05 (行256-257) | ○ |
| C-16 | fetchUsersでuser_mailformatフィルタ | E-05 (行259-260) | ○ |
| C-17 | 添付ファイルはcreateAttachmentで添付 | E-03 (行907-913) | ○ |
| C-18 | mail_status='sent'の場合はエラー | E-01 (行763, 1116-1124) | ○ |
| C-19 | confirm=1の場合のみ処理実行 | E-01 (行710) | ○ |
| C-20 | confirm!=1の場合は確認ダイアログ表示 | E-01 (行1140-1148) | ○ |
| C-21 | レイアウト無効化 | E-01 (行704) | ○ |
| C-22 | ビュー無効化 | E-01 (行705) | ○ |
| C-23 | html_entity_decodeでHTML本文をデコード | E-01 (行769) | ○ |
| C-24 | 添付ファイルパスはsyspathから取得 | E-03 (行909) | ○ |
| C-25 | Mailモデルでメール情報取得 | E-06 | ○ |
| C-26 | Mailモデルでメール情報更新 | E-01 (行765-770) | ○ |
| C-27 | ユーザーはuser_emailとuser_aliasを持つ | E-05 | ○ |
| C-28 | user_roleでロール判定 | E-05 (行256-257) | ○ |
| C-29 | user_mailformatでテキスト/HTML判定 | E-05 (行259-260) | ○ |
| C-30 | usersテーブルからユーザー取得 | E-05 (行252) | ○ |
| C-31 | 送信完了後にmail_statusを'sent'に更新 | **根拠なし** | △ |
| C-32 | 行936に$htmltmailタイポが存在 | E-03 (行936) | ○ |

## 4) 不足情報（Unknown / Missing）
- 送信完了後のmail_status更新処理
  - コード上で送信後のステータス更新処理が確認できない
  - mail_statusが'sent'に変更される箇所の特定が必要
  - 送信成功時のステータス遷移フローの確認が必要
- $htmltmailタイポの影響範囲
  - 行936で`$htmltmail`と記述されているが、変数名は`$htmlmail`
  - 実行時にエラーが発生するか、または未定義変数として処理されるか要確認

## 5) リスクフラグ（レビュー観点）
- リスク2（高）：送信完了後のステータス更新が実装されていない可能性（再送信リスク）
- リスク2（高）：行936のタイポ（$htmltmail）がHTMLメール送信時にエラーを起こす可能性
- リスク1（中）：BCCで大量送信時のSMTPサーバー負荷・制限
- リスク1（中）：html_entity_decodeがXSS攻撃のリスクを含む可能性
- リスク0（低）：権限チェックと確認ダイアログによる操作制限あり
- リスク0（低）：BCCにより受信者同士のアドレスは非公開

## 6) レビュアーチェックリスト（最小）
- [ ] 送信完了後のmail_status更新処理の有無確認
- [ ] 行936のタイポ（$htmltmail -> $htmlmail）の修正要否確認
- [ ] SMTPサーバーのBCC数制限確認
- [ ] registry.site設定の実際の値確認
- [ ] registry.assets.assets.syspath設定の確認
- [ ] SMTPトランスポート設定（$registry->mail）の確認
- [ ] ACL設定（mmail, mmailsend）の確認
- [ ] HTML本文のXSS対策確認
- [ ] ロールID（user_role）の値の確認
