---
generated_at: 2026-02-11 10:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **対応ブラウザ情報**：ソースコード内に明示的な記載なし
  2. **Cookieの有効期限（約3ヶ月）**：設定ファイルの確認が必要
  3. **CAPTCHA設定値の詳細**：設定ファイルでの確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - システム概要、技術スタック
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 93画面の一覧
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 64機能の一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能の対応
- E-05: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 28業務要件
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移フロー
- E-07: `docs/code-to-docs/画面設計書/1-ホーム画面.md` - ホーム画面仕様
- E-08: `docs/code-to-docs/画面設計書/5-ログイン画面.md` - ログイン画面仕様
- E-09: `docs/code-to-docs/画面設計書/32-管理ダッシュボード.md` - 管理ダッシュボード仕様
- E-10: `docs/code-to-docs/画面設計書/33-管理者ログイン画面.md` - 管理者ログイン仕様
- E-11: `docs/code-to-docs/画面設計書/35-記事管理画面.md` - 記事管理画面仕様
- E-12: `docs/code-to-docs/画面設計書/41-ユーザー管理画面.md` - ユーザー管理画面仕様
- E-13: `docs/code-to-docs/画面設計書/64-メール管理画面.md` - メール管理画面仕様
- E-14: `docs/code-to-docs/画面設計書/4-お問い合わせ画面.md` - お問い合わせ画面仕様

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Legacy CMSはZend Framework 1ベースのPHP製CMS | E-01 | ○ |
| C-02 | 記事、イベント、ページ、リソースの管理が可能 | E-01, E-03 | ○ |
| C-03 | ユーザー認証はZend_Authを使用 | E-08, E-10 | ○ |
| C-04 | パスワードはMD5ハッシュ化（site.key + password + salt） | E-08, E-10 | ○ |
| C-05 | Remember me機能でCookieに約3ヶ月保存 | E-08, E-10 | ○ |
| C-06 | ログインURLは/auth/login | E-08 | ○ |
| C-07 | 管理画面URLは/admin/auth/login | E-10 | ○ |
| C-08 | パスワードリセットはメールで送信 | E-05 (BR-AUTH-002) | ○ |
| C-09 | ホーム画面は最新記事5件を表示 | E-07 | ○ |
| C-10 | 画像ローテーターはHomePageという名前 | E-07 | ○ |
| C-11 | 次回イベント3件を表示 | E-07 | ○ |
| C-12 | 管理ダッシュボードは7種類の統計を表示 | E-09 | ○ |
| C-13 | 各統計セクションはACLで権限制御 | E-09 | ○ |
| C-14 | 記事管理はaarticles権限が必要 | E-11 | ○ |
| C-15 | 新規記事作成にはaarticlenew権限が必要 | E-11 | ○ |
| C-16 | 記事削除時はタグ、コメント、検索インデックスも削除 | E-11 | ○ |
| C-17 | ページネーションは1ページ15件 | E-11, E-12, E-13 | ○ |
| C-18 | ユーザー管理にはuusers権限が必要 | E-12 | ○ |
| C-19 | ユーザーステータスはActive/Inactive/Suspended | E-12 | ○ |
| C-20 | ロールID 1-3は削除不可（システム既定） | E-12 | ○ |
| C-21 | メール送信タイプは3種類（G/R/U） | E-13 | ○ |
| C-22 | メーリングリストID=1は削除不可 | E-13 | ○ |
| C-23 | お問い合わせフォームはCAPTCHA認証付き | E-14 | ○ |
| C-24 | CAPTCHA設定: wordLen=7, fontSize=22, 180x60px | E-14 | ○ |
| C-25 | お問い合わせはメール送信のみ（DB保存なし） | E-14 | ○ |
| C-26 | 検索はZend_Search_Luceneを使用 | E-01, E-03 (No.60) | ○ |
| C-27 | ユーザー登録後にメール認証が必要 | E-02 (No.8) | ○ |
| C-28 | 記事のステータスはdraft/published | E-05 (BR-ART-002) | ○ |
| C-29 | イベントには開始日時・終了日時がある | E-05 (BR-EVENT-001) | ○ |
| C-30 | アセット管理でサムネイル自動生成 | E-05 (BR-ASSET-003) | ○ |
| C-31 | コメントには承認ワークフローあり | E-05 (BR-COMMENT-002) | ○ |
| C-32 | ACLはZend_Aclを使用 | E-09, E-05 (BR-ACL-001) | ○ |
| C-33 | フロントエンドとadminの2モジュール構成 | E-01, E-06 | ○ |
| C-34 | Dojoツールキットを使用 | E-07, E-08, E-09, E-11 | ○ |
| C-35 | ユーザー設定画面は/settings/ | E-02 (No.26) | ○ |
| C-36 | パスワード変更画面は/settings/password/ | E-02 (No.27) | ○ |
| C-37 | 購読設定画面は/settings/subscriptions/ | E-02 (No.28) | ○ |
| C-38 | 記事カテゴリID=1はデフォルトで削除不可 | E-11 | ○ |
| C-39 | エラーメッセージ"Unable to authenticate identity" | E-08, E-10 | ○ |
| C-40 | 404エラー画面の存在 | E-02 (No.29, 92) | ○ |
| C-41 | 権限エラー画面の存在 | E-02 (No.93) | ○ |
| C-42 | サイト閉鎖画面の存在 | E-02 (No.31) | ○ |
| C-43 | 対応ブラウザ（Chrome, Edge, Safari, Firefox） | **根拠なし** | △ |
| C-44 | Cookie有効期限の具体的な値（7889231秒） | E-08（コード参照が望ましい） | △ |
| C-45 | Google Maps APIによる地図表示 | E-14（設定依存の可能性） | △ |

## 4) 不足情報（Unknown / Missing）
- **対応ブラウザ情報**：ソースコードおよびドキュメント内に明示的な記載がないため、一般的な推奨ブラウザを記載
  - 候補：package.jsonやドキュメント、要件定義書での確認
- **Cookie有効期限の詳細**：画面設計書に記載があるが、設定ファイルでの実装確認が望ましい
  - 候補：site.ini / application/configs/配下の設定ファイル
- **Google Maps API設定**：お問い合わせ画面でGoogle Maps表示があるが、APIキー設定等の詳細は確認できていない
  - 候補：JavaScript設定ファイル / contact.js

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: システム概要、基本機能、画面遷移 - 複数の根拠で確認済み
- **0（低リスク）**: ログイン・ログアウト手順 - 画面設計書で詳細確認済み
- **0（低リスク）**: 管理機能の操作手順 - 画面設計書、機能一覧で確認済み
- **1（中リスク）**: 対応ブラウザ - 根拠なし、一般的な推奨を記載
- **1（中リスク）**: サポート連絡方法 - 具体的な連絡先情報はサイト設定依存
- **0（低リスク）**: エラーメッセージ - 画面設計書で確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] システム概要が実際のシステムと一致しているか確認
- [ ] ログイン手順が実際の画面と一致しているか確認
- [ ] 対応ブラウザ情報が適切か確認（根拠なしのため要検討）
- [ ] 管理機能の操作手順が実際の画面と一致しているか確認
- [ ] 権限名（aarticles, uusers等）が正確か確認
- [ ] お問い合わせフォームのCAPTCHA設定が実際と一致しているか確認
- [ ] エラーメッセージが実際の表示と一致しているか確認
- [ ] サポート連絡方法が組織の運用に適切か確認
