# Legacy CMS 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（TOP画面）](#3-トップページtop画面)

**【業務フローに沿った機能】**
4. [【STEP1】コンテンツ作成機能（記事・ページ・イベントの作成）](#4-step1コンテンツ作成機能記事ページイベントの作成)
5. [【STEP2】コンテンツ閲覧機能（公開サイトでの閲覧）](#5-step2コンテンツ閲覧機能公開サイトでの閲覧)
6. [【STEP3】ユーザー登録・お問い合わせ機能](#6-step3ユーザー登録お問い合わせ機能)
7. [【STEP4-5】管理・処理完了（管理者向け）](#7-step4-5管理処理完了管理者向け)

**【サポート機能】**
8. [検索機能](#8-検索機能)
9. [お問合せ機能](#9-お問合せ機能)
10. [マイページ機能（ユーザー設定）](#10-マイページ機能ユーザー設定)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 Legacy CMSとは

Legacy CMSは、Zend Framework 1をベースとしたPHP製コンテンツ管理システム（CMS）です。小規模なデジタルエージェンシー向けに開発され、記事、イベント、リソース、ページなどの多様なコンテンツタイプを管理できる多機能CMSです。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **コンテンツ管理** | 記事の作成・編集・公開、静的ページの管理、イベント情報の管理 |
| **ユーザー管理** | ユーザーアカウントの作成・編集・削除、ロールの割り当て、権限の管理 |
| **コミュニケーション** | メール配信、コメント管理、お問い合わせ対応 |
| **アセット管理** | 画像・ファイルのアップロード、フォルダ管理、サムネイル生成 |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します：

```
┌─────────────────────────────────────────────────────────────────┐
│                        業務フロー                                │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  【STEP 1】管理者がコンテンツ（記事・ページ・イベント）を作成・公開 │
│      ↓                                                          │
│  【STEP 2】一般ユーザーが公開サイトでコンテンツを閲覧             │
│      ↓                                                          │
│  【STEP 3】一般ユーザーがお問い合わせや登録を行う                 │
│      ↓                                                          │
│  【STEP 4】管理者がコメントの承認やユーザー管理を行う             │
│      ↓                                                          │
│  【STEP 5】管理者がメール配信を行い、処理を完了                   │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **管理者** | コンテンツの作成・編集・公開、ユーザー管理、コメント承認、メール配信、システム設定 |
| **一般ユーザー** | コンテンツの閲覧、コメント投稿、お問い合わせ、ユーザー登録、設定変更 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| 記事管理 | 記事の作成・編集・公開・削除 | STEP 1 |
| ページ管理 | 静的ページの作成・編集・公開 | STEP 1 |
| イベント管理 | イベント情報の登録・編集・公開 | STEP 1 |
| コンテンツ閲覧 | 記事・ページ・イベントの閲覧 | STEP 2 |
| ユーザー登録 | 新規アカウントの作成 | STEP 3 |
| お問い合わせ | サイト運営者への連絡 | STEP 3 |
| コメント管理 | コメントの投稿・承認・削除 | STEP 4 |
| ユーザー管理 | ユーザーアカウントの管理 | STEP 4 |
| メール配信 | ニュースレター・通知メールの送信 | STEP 5 |
| 検索 | サイト内全文検索 | 随時参照 |
| マイページ | ユーザー個人設定 | 随時利用 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 管理者（Administrator） | システム全体の管理権限を持つユーザー。全機能にアクセス可能 |
| 一般ユーザー（User） | サイトに登録したユーザー。コンテンツ閲覧、コメント投稿、設定変更が可能 |
| ゲスト（Guest） | 未登録・未ログインのユーザー。公開コンテンツの閲覧のみ可能 |

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

---

## 2. ログイン・ログアウト手順

### 2.1 フロントエンド（公開サイト）へのログイン方法

1. ブラウザでサイトのログインページ（`/auth/login`）にアクセスします
2. ログイン画面が表示されます

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| E-mail address | 登録済みのメールアドレスを入力 |
| Password | パスワードを入力（4文字以上） |
| Remember me? | チェックを入れるとログイン情報が保存されます（約3ヶ月間有効） |

3. 「Login」ボタンをクリックします
4. 認証に成功すると、元のページまたはホーム画面が表示されます

**注意事項：**
- パスワードを忘れた場合は、「Forgotten your password?」リンクをクリックしてパスワードをリセットできます

### 2.2 管理画面へのログイン方法

1. ブラウザで管理画面のログインページ（`/admin/auth/login`）にアクセスします
2. 管理者ログイン画面が表示されます

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| E-mail address | 管理者アカウントのメールアドレスを入力 |
| Password | パスワードを入力（4文字以上） |
| Remember me? | チェックを入れるとログイン情報が保存されます |

3. 「Login」ボタンをクリックします
4. 認証に成功すると、管理ダッシュボードが表示されます

### 2.3 ログアウト方法

**フロントエンド：**
1. 画面上部のナビゲーションまたはユーザーメニューから「Logout」を選択します
2. ログイン画面に戻ります

**管理画面：**
1. 管理画面のメニューから「Logout」を選択します
2. 管理者ログイン画面に戻ります

### 2.4 パスワードを忘れた場合

1. ログイン画面で「Forgotten your password?」リンクをクリックします
2. パスワードリセット画面が表示されます
3. 登録済みのメールアドレスを入力し、「Reset Password」ボタンをクリックします
4. 入力したメールアドレス宛にパスワードリセット用のリンクが送信されます
5. メール内のリンクをクリックし、新しいパスワードを設定します

---

## 3. トップページ（TOP画面）

### 3.1 フロントエンド（公開サイト）TOP画面

フロントエンドのホーム画面は、サイト訪問者が最初にアクセスするランディングページです。

**主な表示内容：**

| 表示エリア | 説明 |
|-----------|------|
| 画像ローテーター | サイトのビジュアルコンテンツがスライドショー形式で表示されます |
| 最新記事一覧 | 公開済みの最新記事5件が表示されます |
| 検索ボックス | サイト内検索ができます |
| 次回イベント | 直近3件のイベント情報が表示されます |
| タグクラウド | 記事のタグが表示され、クリックで関連記事を検索できます |
| 登録/ログインボックス | 未ログインの場合は登録案内が表示されます |

**操作方法：**

- 記事タイトルをクリック → 記事詳細画面へ遷移
- 「Read More」をクリック → 記事の続きを表示
- カテゴリ名をクリック → カテゴリ別記事一覧へ遷移
- 著者名をクリック → 著者別記事一覧へ遷移
- タグをクリック → タグ別記事一覧へ遷移

### 3.2 管理者向けTOP画面（管理ダッシュボード）

管理ダッシュボードは、管理者がログイン後に最初に表示される画面です。

**主な表示内容：**

| 表示エリア | 説明 | 必要な権限 |
|-----------|------|----------|
| Articles | 記事の統計情報と管理リンク | aarticles |
| Comments | コメントの統計情報と管理リンク | gcomments |
| Events | イベントの統計情報と管理リンク | eevents |
| Mail | メールの統計情報と管理リンク | mmail |
| Pages | ページの統計情報と管理リンク | ppages |
| Rotators | ローテーターの統計情報と管理リンク | rotrotators |
| Users | ユーザーの統計情報と管理リンク | uusers |

**操作方法：**

各セクションのリンクをクリックすると、対応する管理画面に遷移します：
- 「Articles」 → 記事管理画面（`/admin/articles/`）
- 「Users」 → ユーザー管理画面（`/admin/users/`）
- 「Events」 → イベント管理画面（`/admin/events/`）
- 「Pages」 → ページ管理画面（`/admin/pages/`）
- 「Mail」 → メール管理画面（`/admin/mail/`）
- 「Settings」 → 設定画面（`/admin/settings/`）

---

## 4. 【STEP1】コンテンツ作成機能（記事・ページ・イベントの作成）

> **業務フローでの位置**: 管理者がコンテンツを作成・編集し、公開するステップです。

### 4.1 記事の作成

**業務シーン：** 新しい記事を作成してサイトに公開する場合

**前提条件：**
- 管理画面にログインしていること
- aarticles権限およびaarticlenew権限を持っていること

**操作手順：**

1. 管理ダッシュボードから「Articles」をクリックして記事管理画面へ遷移します
2. 「New Article」ボタンをクリックします
3. 記事新規作成ダイアログが表示されます
4. 以下の項目を入力します：
   - **Title**: 記事のタイトル
   - **Category**: カテゴリを選択
   - **Intro**: 導入文（記事一覧に表示される概要）
   - **Content**: 本文（WYSIWYGエディタで編集可能）
   - **Tags**: タグ（カンマ区切りで複数入力可能）
   - **Status**: 「Draft」（下書き）または「Published」（公開）を選択
5. 「Save」ボタンをクリックして保存します

**注意点・Tips：**
- 記事を「Published」状態にすると、即座にサイトに公開されます
- 「Draft」状態にしておくと、下書きとして保存され、公開されません
- 画像を挿入する場合は、エディタの画像挿入ボタンを使用してアセットから選択します

### 4.2 記事の編集

**操作手順：**

1. 記事管理画面（`/admin/articles/manage/`）を開きます
2. 編集したい記事のタイトルをクリックします
3. 記事編集画面が表示されます
4. 内容を修正し、「Save」ボタンをクリックします

**フィルタリング機能：**

- **カテゴリでフィルタ**: 左側のカテゴリ一覧からカテゴリをクリック
- **著者でフィルタ**: 著者名をクリック
- **ソート**: テーブルのヘッダー（Article, Author, Category, Date）をクリック

### 4.3 記事の削除

**操作手順：**

1. 記事管理画面で削除したい記事の行にマウスを乗せます
2. 「Delete」リンクが表示されるのでクリックします
3. 確認ダイアログで「OK」をクリックします
4. 記事が削除されます

**注意点：**
- 削除すると関連するコメント、タグ、検索インデックスも削除されます
- 削除は取り消しできません

### 4.4 ページの作成・編集

**操作手順：**

1. 管理ダッシュボードから「Pages」をクリックしてページ管理画面へ遷移します
2. 「New Page」ボタンをクリックします
3. 以下の項目を入力します：
   - **Title**: ページのタイトル
   - **Slug**: URL用のスラッグ（URLに使用される識別子）
   - **Content**: 本文
   - **Status**: 「Draft」または「Published」
4. 「Save」ボタンをクリックして保存します

### 4.5 イベントの作成・編集

**操作手順：**

1. 管理ダッシュボードから「Events」をクリックしてイベント管理画面へ遷移します
2. 「New Event」ボタンをクリックします
3. 以下の項目を入力します：
   - **Title**: イベントのタイトル
   - **Category**: カテゴリを選択
   - **Venue**: 会場を選択
   - **Start Date/Time**: 開始日時
   - **End Date/Time**: 終了日時
   - **Description**: 説明文
   - **Status**: 「Draft」または「Published」
4. 「Save」ボタンをクリックして保存します

---

## 5. 【STEP2】コンテンツ閲覧機能（公開サイトでの閲覧）

> **業務フローでの位置**: 一般ユーザーが公開されたコンテンツを閲覧するステップです。

### 5.1 記事の閲覧

**操作手順：**

1. ホーム画面の最新記事一覧から記事タイトルをクリックします
2. または、記事一覧画面（`/articles/`）にアクセスして記事を選択します
3. 記事詳細画面が表示され、以下の情報を確認できます：
   - 記事タイトル
   - 著者名
   - 公開日時
   - カテゴリ
   - 本文
   - タグ
   - コメント

**フィルタリング機能：**

- **カテゴリ別**: `/articles/category/{カテゴリ名}/`
- **著者別**: `/articles/author/{著者名}/`
- **タグ別**: `/articles/tag/{タグ名}/`
- **月別アーカイブ**: `/articles/archive/{年}/{月}/`

### 5.2 イベントの閲覧

**操作手順：**

1. イベント一覧画面（`/events/`）にアクセスします
2. イベントタイトルをクリックして詳細を表示します
3. カレンダー表示（`/events/calendar/`）で月別のイベントを確認できます

### 5.3 静的ページの閲覧

**操作手順：**

1. ナビゲーションメニューからページリンクをクリックします
2. または、直接URL（`/pages/{スラッグ}/`）にアクセスします

---

## 6. 【STEP3】ユーザー登録・お問い合わせ機能

> **業務フローでの位置**: 一般ユーザーがサイトに登録したり、お問い合わせを行うステップです。

### 6.1 ユーザー登録

**操作手順：**

1. ホーム画面の登録案内ボックスまたはログイン画面から「Register」リンクをクリックします
2. ユーザー登録画面（`/auth/register`）が表示されます
3. 以下の項目を入力します：
   - **Name**: 名前
   - **E-mail address**: メールアドレス
   - **Password**: パスワード（4文字以上）
   - **Confirm Password**: パスワード（確認用）
4. 「Register」ボタンをクリックします
5. 入力したメールアドレス宛に確認メールが送信されます
6. メール内のリンクをクリックしてアカウントを有効化します
7. ログイン画面にリダイレクトされ、ログインできるようになります

### 6.2 お問い合わせの送信

**操作手順：**

1. お問い合わせ画面（`/contact/`）にアクセスします
2. 以下の項目を入力します：
   - **Name**: お名前（3文字以上）
   - **E-mail address**: メールアドレス
   - **Subject**: 件名
   - **Message**: お問い合わせ内容
   - **Verification Code**: 画像に表示されている認証コードを入力
3. 「Send Message」ボタンをクリックします
4. 「Your message has been sent.」と表示されれば送信完了です

**注意点：**
- CAPTCHA認証コードは大文字・小文字を正確に入力してください
- 認証コードが読みにくい場合は、ページを更新して新しい画像を取得してください

---

## 7. 【STEP4-5】管理・処理完了（管理者向け）

> **業務フローでの位置**: 管理者がユーザー管理、コメント承認、メール配信を行い、処理を完了するステップです。

### 7.1 ユーザー管理

**業務シーン：** ユーザーアカウントの確認・編集・ロール変更を行う場合

**操作手順：**

1. 管理ダッシュボードから「Users」をクリックしてユーザー管理画面へ遷移します
2. ユーザー一覧が表示されます
3. 以下の操作が可能です：

**ユーザーの検索：**
- 検索ボックスにキーワードを入力して「Go」をクリック
- ステータス（Active/Inactive/Suspended）でフィルタ
- ロールでフィルタ

**ユーザーの編集：**
1. ユーザー名をクリックして編集画面を開きます
2. 情報を編集し、「Save」をクリックします

**新規ユーザーの作成：**
1. 「New User」ボタンをクリックします
2. 必要な情報を入力し、「Save」をクリックします

**ロールの管理：**
1. 「New Role」ボタンをクリックして新しいロールを作成できます
2. 既存のロールは右クリックメニューから編集・削除できます

### 7.2 コメント管理

**業務シーン：** 投稿されたコメントを確認・承認・削除する場合

**操作手順：**

1. 管理ダッシュボードから「Comments」をクリックしてコメント管理画面へ遷移します
2. コメント一覧が表示されます
3. コメントをクリックして詳細を確認します
4. 以下の操作が可能です：
   - **承認**: 未承認のコメントを公開する
   - **非承認**: 承認済みのコメントを非公開にする
   - **削除**: コメントを削除する

### 7.3 メール配信

**業務シーン：** ユーザーやメーリングリストにメールを送信する場合

**操作手順：**

1. 管理ダッシュボードから「Mail」をクリックしてメール管理画面へ遷移します
2. 以下の操作が可能です：

**メーリングリスト宛にメールを送信：**
1. 「New Mail」ボタンのドロップダウンから「Mailing List」を選択します
2. 宛先のメーリングリストを選択します
3. 件名と本文を入力し、「Send」をクリックします

**ロール宛にメールを送信：**
1. 「New Mail」ボタンのドロップダウンから「Role」を選択します
2. 宛先のロールを選択します
3. 件名と本文を入力し、「Send」をクリックします

**メーリングリストの管理：**
1. 「New Mailing List」ボタンをクリックして新しいリストを作成できます
2. 既存のリストは右クリックメニューから編集・削除できます

---

## 8. 検索機能

### 8.1 サイト内検索

**操作手順：**

1. サイドバーまたはヘッダーの検索ボックスにキーワードを入力します
2. 「Search」ボタンをクリックまたはEnterキーを押します
3. 検索結果画面（`/index/search?query={キーワード}`）が表示されます
4. 検索結果から目的のコンテンツをクリックして詳細を表示します

**検索対象：**
- 記事のタイトル、本文
- ページのタイトル、本文
- イベントのタイトル、説明

---

## 9. お問合せ機能

### 9.1 お問い合わせを作成する

「6.2 お問い合わせの送信」を参照してください。

### 9.2 管理者へのお問い合わせ確認

お問い合わせはサイト設定で指定されたメールアドレスに送信されます。管理者はメールを確認し、必要に応じて返信を行います。

---

## 10. マイページ機能（ユーザー設定）

### 10.1 マイページにアクセスする

**操作手順：**

1. サイトにログインします
2. ユーザーメニューから「Settings」をクリックします
3. ユーザー設定画面（`/settings/`）が表示されます

### 10.2 設定変更

**プロフィール情報の変更：**
1. ユーザー設定画面で情報を編集します
2. 「Save」ボタンをクリックします

**パスワードの変更：**
1. ユーザー設定画面から「Change Password」リンクをクリックします
2. パスワード変更画面（`/settings/password/`）が表示されます
3. 現在のパスワードと新しいパスワードを入力します
4. 「Change Password」ボタンをクリックします

**メール購読設定の変更：**
1. ユーザー設定画面から「Subscriptions」リンクをクリックします
2. 購読設定画面（`/settings/subscriptions/`）が表示されます
3. 購読したいメーリングリストにチェックを入れます
4. 「Save」ボタンをクリックします

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【STEP 1】管理者がコンテンツを作成・公開 → 4章参照
    ↓
【STEP 2】一般ユーザーがコンテンツを閲覧 → 5章参照
    ↓
【STEP 3】一般ユーザーが登録・お問い合わせ → 6章参照
    ↓
【STEP 4】管理者がユーザー・コメントを管理 → 7章参照
    ↓
【STEP 5】管理者がメール配信を行い完了 → 7章参照
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### 11.1 【管理者】STEP1: コンテンツの作成・公開

1. 管理画面にログインします（`/admin/auth/login/`）
2. ダッシュボードで各コンテンツの統計を確認します
3. 必要に応じて新しい記事、ページ、イベントを作成します
4. 作成したコンテンツを「Published」状態にして公開します

**日常的なチェック項目：**
- [ ] 新しい記事のスケジュール確認
- [ ] 下書き状態のコンテンツの確認
- [ ] イベントの日程確認

### 11.2 【一般ユーザー】STEP2: コンテンツの閲覧

1. サイトにアクセスします
2. ホーム画面で最新記事やイベントを確認します
3. 興味のあるコンテンツをクリックして詳細を読みます
4. 必要に応じてコメントを投稿します

### 11.3 【一般ユーザー】STEP3: 登録・お問い合わせ

1. 未登録の場合は、ユーザー登録を行います
2. 質問や要望がある場合は、お問い合わせフォームから連絡します
3. 登録後は、メール購読設定を確認・変更します

### 11.4 【管理者】STEP4-5: 管理・処理完了

1. 新規登録ユーザーの確認を行います
2. 投稿されたコメントを確認・承認します
3. お問い合わせメールに対応します
4. 必要に応じてメール配信を行います

**日常的なチェック項目：**
- [ ] 未承認コメントの確認
- [ ] 新規ユーザーの確認
- [ ] お問い合わせメールの確認
- [ ] メール配信のスケジュール確認

---

## 12. よくある質問と対処法

### 12.1 ログインに関するQ&A

**Q: ログインできません**

A: 以下を確認してください：
1. メールアドレスとパスワードが正しいか確認してください
2. Caps Lockがオンになっていないか確認してください
3. アカウントが有効化されているか確認してください（登録後のメール認証が必要）
4. アカウントが「Suspended」状態になっていないか管理者に確認してください

**Q: パスワードを忘れました**

A: ログイン画面の「Forgotten your password?」リンクからパスワードをリセットしてください。登録済みのメールアドレス宛にリセットリンクが送信されます。

### 12.2 コンテンツ管理に関するQ&A

**Q: 記事を公開したが、サイトに表示されません**

A: 以下を確認してください：
1. 記事のステータスが「Published」になっているか確認してください
2. 公開日時が未来の日付になっていないか確認してください
3. ブラウザのキャッシュをクリアしてみてください

**Q: 画像をアップロードできません**

A: 以下を確認してください：
1. 画像のファイルサイズが許容範囲内か確認してください
2. 対応している画像形式（JPEG, PNG, GIF）か確認してください
3. アセット管理画面でアップロード先のフォルダを選択してから再度お試しください

### 12.3 お問い合わせに関するQ&A

**Q: お問い合わせフォームが送信できません**

A: 以下を確認してください：
1. 全ての必須項目が入力されているか確認してください
2. メールアドレスの形式が正しいか確認してください
3. 認証コード（CAPTCHA）が正確に入力されているか確認してください
4. 認証コードが読みにくい場合は、ページを更新して新しい画像を取得してください

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| Unable to authenticate identity | メールアドレスまたはパスワードが間違っている | 正しい認証情報を入力してください |
| E-mail address is required | メールアドレスが入力されていない | メールアドレスを入力してください |
| Invalid e-mail address | メールアドレスの形式が不正 | 正しいメールアドレスを入力してください |
| Password must be at least 4 characters | パスワードが短すぎる | 4文字以上のパスワードを入力してください |
| Invalid Verification Code | CAPTCHA認証コードが間違っている | 画像に表示されているコードを正確に入力してください |
| Not Found | ユーザーが存在しない | 登録済みのメールアドレスを確認してください |
| Access Denied | 権限がない | 管理者に権限の付与を依頼してください |

### 13.2 よくあるトラブルと解決方法

**トラブル: ページが表示されない（404エラー）**

解決方法：
1. URLが正しいか確認してください
2. コンテンツが公開状態になっているか確認してください
3. ブラウザのキャッシュをクリアしてください

**トラブル: 画面が正しく表示されない（レイアウト崩れ）**

解決方法：
1. ブラウザを最新版に更新してください
2. JavaScriptが有効になっているか確認してください
3. 別のブラウザで試してみてください

**トラブル: メールが届かない**

解決方法：
1. 迷惑メールフォルダを確認してください
2. メールアドレスが正しいか確認してください
3. サーバーのメール設定を管理者に確認してもらってください

### 13.3 サポートへの連絡方法

上記の対処法で解決しない場合は、以下の方法でサポートに連絡してください：

1. サイトのお問い合わせフォーム（`/contact/`）から問い合わせる
2. 管理者に直接連絡する

連絡時には以下の情報を添えてください：
- 発生している問題の詳細
- エラーメッセージ（表示されている場合）
- 操作手順（どのような操作で問題が発生したか）
- 使用しているブラウザとバージョン

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-02-11 | 初版作成 |

---

*本マニュアルは、Legacy CMSのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
