---
generated_at: 2026-02-11 20:15:00
metrics:
  claims_total: 45
  claims_with_evidence: 38
  claims_without_evidence: 7
confidence_derived: 0.84
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.84**
  - 根拠あり：38 / 45、根拠なし：7
- 優先レビュー（高）
  1. **NFT-013 ブルートフォース攻撃耐性テスト**：アカウントロック機能の実装確認が必要
  2. **NFT-040 複数インスタンス動作テスト**：セッション共有機構の実装確認が必要
  3. **NFT-006 同時接続ユーザー負荷テスト**：具体的な性能基準値は推定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/bootstrap.php` - Zend Framework初期化処理
- E-02: `application/initializer.php` - アプリケーション初期化・環境設定
- E-03: `application/modules/admin/controllers/AuthController.php` - 認証処理実装
- E-04: `library/CMS/Controller/Action/Admin.php` - 管理者認証・ACL処理
- E-05: `library/CMS/Controller/Action/Auth.php` - 認証基底クラス
- E-06: `library/CMS/Acl/Factory.php` - ACL（アクセス制御リスト）生成
- E-07: `library/CMS/Password/Strength.php` - パスワード強度チェック
- E-08: `application/modules/admin/controllers/UsersController.php` - ユーザー管理
- E-09: `application/modules/admin/controllers/AssetsController.php` - アセット管理・ファイルアップロード
- E-10: `application/models/Search.php` - Lucene検索インデックス
- E-11: `database.sql` - データベーススキーマ定義
- E-12: `.travis.yml` - CI設定（PHP互換性テスト）
- E-13: `composer.json` - 依存パッケージ定義
- E-14: `bin/install.php` - インストールスクリプト
- E-15: `README.md` - インストール手順・要件

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: Zend Framework1ベースのMVCアーキテクチャ | E-01, E-02 | ○ |
| C-02 | NFT-002: MD5ハッシュ+salt認証処理 | E-03 (line 114, 217) | ○ |
| C-03 | NFT-003: users/users_profiles/users_roles JOIN | E-08, E-11 | ○ |
| C-04 | NFT-004: Zend_Search_Lucene使用 | E-10 | ○ |
| C-05 | NFT-005: PhpThumbライブラリ使用 | E-09 (line 312-320), E-13 | ○ |
| C-06 | NFT-006: 同時接続50ユーザー性能基準 | **根拠なし** | △ |
| C-07 | NFT-007: assets_foldersテーブル使用 | E-09, E-11 | ○ |
| C-08 | NFT-008: SMTP SSL接続（ポート465） | E-02 (line 107-116) | ○ |
| C-09 | NFT-009: Zend_Cache lifetime=10秒 | E-02 (line 122-133) | ○ |
| C-10 | NFT-010: サムネイルキャッシュ | E-09 (line 302-322) | ○ |
| C-11 | NFT-011: PHP 5.2-7対応 | E-12 | ○ |
| C-12 | NFT-012: Zend_Paginator使用 | E-08 (line 181-184) | ○ |
| C-13 | NFT-013: アカウントロック機能 | **根拠なし - 機能未実装の可能性** | △ |
| C-14 | NFT-014: PHPSESSID使用 | E-04 (line 25-44) | ○ |
| C-15 | NFT-015: CMS_Password_Strength使用 | E-07 | ○ |
| C-16 | NFT-016: Remember Me Cookie平文問題 | E-03 (line 131-132) | ○ |
| C-17 | NFT-017: 73リソースACL | E-11 (users_resources), E-06 | ○ |
| C-18 | NFT-018: Administrator/User/Guestロール | E-11 (users_roles) | ○ |
| C-19 | NFT-019: Zend_Db prepared statements | E-08 (全体), E-09 (全体) | ○ |
| C-20 | NFT-020: Zend_Filter_Input使用 | E-03, E-08 | ○ |
| C-21 | NFT-021: Zend_Validate_EmailAddress使用 | E-03 (line 82-90) | ○ |
| C-22 | NFT-022: finfo_file MIME検証 | E-09 (line 468-471) | ○ |
| C-23 | NFT-023: asset_keyによるアクセス制御 | E-09 | ○ |
| C-24 | NFT-024: HTTPS通信 | **根拠なし - Apache設定依存** | △ |
| C-25 | NFT-025: SMTP SSL通信 | E-02 (line 109-110) | ○ |
| C-26 | NFT-026: 本番環境エラー非表示 | E-02 (line 80-85) | ○ |
| C-27 | NFT-027: error_reporting(0) | E-02 (line 82) | ○ |
| C-28 | NFT-028: Zend_Db_Table使用 | E-02 (line 185) | ○ |
| C-29 | NFT-029: PHPファイルセッション | E-04 | ○ |
| C-30 | NFT-030: database.sql復元 | E-11 | ○ |
| C-31 | NFT-031: アセットファイルバックアップ | E-09, E-15 | ○ |
| C-32 | NFT-032: ヘルスチェック | **根拠なし - 実装未確認** | △ |
| C-33 | NFT-033: PHP 5.2互換性 | E-12 | ○ |
| C-34 | NFT-034: PHP 7互換性 | E-12 (line 11, 33) | ○ |
| C-35 | NFT-035: Dojo Toolkit使用 | E-08 (出力HTML) | ○ |
| C-36 | NFT-036: utf8mb4文字コード | E-11 | ○ |
| C-37 | NFT-037: エラーログ出力 | E-02 | ○ |
| C-38 | NFT-038: Zend_Config_Ini使用 | E-02 (line 91-104) | ○ |
| C-39 | NFT-039: composer.json依存関係 | E-13 | ○ |
| C-40 | NFT-040: セッション共有機構 | **根拠なし - 外部ストア未実装** | △ |
| C-41 | NFT-041: 大量データ対応 | E-08, E-12 | ○ |
| C-42 | NFT-042: フォルダ階層管理 | E-09, E-11 | ○ |
| C-43 | NFT-043: bin/install.php | E-14 | ○ |
| C-44 | NFT-044: バージョン2.1 | E-01 (line 5) | ○ |
| C-45 | NFT-045: Zend_Validateメッセージ | E-03, E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- **NFT-006 性能基準値**：50同時ユーザー・5秒以内は一般的なWeb基準からの推定値であり、実際のSLA定義やパフォーマンス要件定義書が不在
  - 候補：運用SLA定義 / パフォーマンス要件定義書 / 負荷テスト結果レポート
- **NFT-013 アカウントロック機能**：ブルートフォース対策のロック機能がコード内に確認できない
  - 候補：セキュリティ要件定義書 / ログイン失敗カウント実装
- **NFT-024 HTTPS設定**：アプリケーションレベルでのHTTPS強制設定がなく、Webサーバー設定依存
  - 候補：Apache/Nginx設定ファイル / インフラ設計書
- **NFT-032 ヘルスチェック**：専用のヘルスチェックエンドポイント実装が未確認
  - 候補：監視設計書 / ヘルスチェックエンドポイント実装
- **NFT-040 分散セッション**：ファイルベースセッションのため、複数インスタンス構成でのセッション共有が困難
  - 候補：Redis/Memcached設定 / セッションストア設計書

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**: NFT-016 Remember Me Cookie平文保存 - パスワードがCookieに平文保存されるセキュリティ脆弱性
- **リスク2（高）**: NFT-013 アカウントロック未実装 - ブルートフォース攻撃への耐性が不明
- **リスク1（中）**: NFT-040 ファイルセッション - スケールアウト時にセッション共有問題
- **リスク1（中）**: NFT-011 MD5ハッシュ使用 - より強力なハッシュアルゴリズム（bcrypt等）への移行推奨
- **リスク0（低）**: NFT-033 PHP 5.2サポート - EOLバージョンのサポートは将来的に削除検討

## 6) レビュアーチェックリスト（最小）
- [ ] NFT-016: Remember Me機能のCookie処理がセキュリティ要件を満たすか確認
- [ ] NFT-013: ブルートフォース攻撃対策（アカウントロック、CAPTCHA等）の必要性を確認
- [ ] NFT-006/NFT-007/NFT-008: 性能基準値が実際の運用要件と整合するか確認
- [ ] NFT-024: HTTPS強制のインフラ設定が適切か確認
- [ ] NFT-040: 将来的なスケールアウト計画がある場合、セッション共有機構の検討
- [ ] 全テストケースの合格基準値が運用SLAと整合するか確認
- [ ] セキュリティテストケース（NFT-013〜NFT-027）の網羅性確認
