---
generated_at: 2026-02-11 19:45:00
metrics:
  claims_total: 42
  claims_with_evidence: 35
  claims_without_evidence: 7
confidence_derived: 0.83
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：35 / 42、根拠なし：7
- 優先レビュー（高）
  1. **レスポンスタイム・スループット目標値**：コード内に明示的な定義なし
  2. **可用性目標（SLA/RTO/RPO）**：明示的な目標値設定なし
  3. **CSRF対策の有無**：コード内にトークン検証機能が見つからない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/configs/config.example.ini` - 設定ファイルテンプレート
- E-02: `application/initializer.php` - 初期化処理・キャッシュ設定
- E-03: `application/bootstrap.php` - アプリケーション起動処理
- E-04: `library/CMS/Controller/Action/Admin.php` - 管理者認証処理
- E-05: `library/CMS/Controller/Action/Auth.php` - 認証基底クラス
- E-06: `library/CMS/Acl/Factory.php` - ACL生成クラス
- E-07: `library/CMS/Password/Strength.php` - パスワード強度チェッカー
- E-08: `application/modules/admin/controllers/AuthController.php` - 管理者ログイン処理
- E-09: `application/modules/admin/controllers/UsersController.php` - ユーザー管理処理
- E-10: `application/models/YouTube.php` - YouTubeキャッシュ設定
- E-11: `application/models/YouTube3.php` - YouTube RSS キャッシュ設定
- E-12: `composer.json` - 依存関係定義
- E-13: `.travis.yml` - CI/CD設定
- E-14: `database.sql` - データベーススキーマ
- E-15: `library/CMS/Controller/Plugin/ErrorSelector.php` - エラーハンドリング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キャッシュバックエンドはFileを使用 | E-02 | ○ |
| C-02 | キャッシュのlifetimeは10秒 | E-02 | ○ |
| C-03 | YouTubeキャッシュは10800秒（3時間） | E-10 | ○ |
| C-04 | YouTube単体動画キャッシュは86400秒（24時間） | E-10 | ○ |
| C-05 | サイトステータスでopen/closed切替可能 | E-01 | ○ |
| C-06 | 認証方式はZend_Auth使用 | E-04, E-08 | ○ |
| C-07 | パスワードはMD5+サイトキー+ソルトで暗号化 | E-08 | ○ |
| C-08 | アクセス制御はZend_Acl（RBAC）を使用 | E-06 | ○ |
| C-09 | ログインパスワード最小文字数は4文字 | E-08 | ○ |
| C-10 | パスワード強度チェック機能あり | E-07 | ○ |
| C-11 | 自動生成パスワードは8文字 | E-08, E-09 | ○ |
| C-12 | セッション識別子はPHPSESSID | E-04 | ○ |
| C-13 | Remember Me機能は約3ヶ月有効 | E-08 | ○ |
| C-14 | SMTP通信はSSL/TLS（ポート465） | E-02 | ○ |
| C-15 | 入力バリデーションにZend_Filter_Input使用 | E-08, E-09 | ○ |
| C-16 | フレームワークはZend Framework 1.12.20 | E-12 | ○ |
| C-17 | モジュール構成はdefaultとadmin | E-03 | ○ |
| C-18 | CI/CDはTravis CI使用 | E-13 | ○ |
| C-19 | 対応PHPバージョンは5.2〜7, HHVM | E-13 | ○ |
| C-20 | エラーハンドリングはモジュール別 | E-15 | ○ |
| C-21 | アセット保存先は/srv/legacycms/assets/ | E-01 | ○ |
| C-22 | 検索インデックスは/srv/legacycms/search/ | E-01 | ○ |
| C-23 | 本番環境ではエラー表示を抑制 | E-02 | ○ |
| C-24 | 開発環境ではE_ALL | E_STRICTで全エラー表示 | E-02 | ○ |
| C-25 | ページネーションは15件/ページ | E-09 | ○ |
| C-26 | 依存ライブラリにderesh/thumbを使用 | E-12 | ○ |
| C-27 | 依存ライブラリにjames-heinrich/getid3を使用 | E-12 | ○ |
| C-28 | データベースはPDO_MySQLを使用 | E-01, E-02 | ○ |
| C-29 | ロール情報はusers_rolesテーブルで管理 | E-14 | ○ |
| C-30 | 権限情報はusers_privilegesテーブルで管理 | E-14 | ○ |
| C-31 | メール送信にZend_Mailを使用 | E-08, E-09 | ○ |
| C-32 | Luceneで検索インデックス管理 | E-10 (Search.php参照) | ○ |
| C-33 | YouTube API v2を使用 | E-10 | ○ |
| C-34 | Google Maps/Analytics APIキー設定あり | E-01 | ○ |
| C-35 | ロケールはen_GBがデフォルト | E-02 | ○ |
| C-36 | レスポンスタイム目標値が未定義 | **根拠なし** | △ |
| C-37 | スループット目標値が未定義 | **根拠なし** | △ |
| C-38 | 稼働率目標値が未定義 | **根拠なし** | △ |
| C-39 | RTO/RPO目標値が未定義 | **根拠なし** | △ |
| C-40 | レートリミット機能が未実装 | **根拠なし** | △ |
| C-41 | CSRF対策トークン検証が未実装 | **根拠なし** | △ |
| C-42 | タイムアウト設定が未定義 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **性能目標値**: コード内にレスポンスタイム、スループットの目標値定義ファイルが存在しない
  - 候補：運用マニュアル / SLA文書 / インフラ設計書
- **可用性目標**: RTO/RPO等の可用性目標がコードや設定ファイルに存在しない
  - 候補：運用マニュアル / 災害復旧計画書 / SLA契約書
- **セキュリティ対策詳細**: CSRF対策、レートリミットの実装有無を確認するための追加調査が必要
  - 候補：セキュリティ設計書 / ミドルウェア設定

## 5) リスクフラグ（レビュー観点）
- 2: **MD5ハッシュの使用** - パスワード暗号化にMD5を使用しており、現代のセキュリティ基準では脆弱
- 2: **CSRF対策未確認** - フォーム送信時のCSRFトークン検証機能が確認できず
- 1: **SQLインジェクション対策** - パラメータバインディング使用だが一部直接連結箇所あり
- 1: **外部API依存** - YouTube API v2は廃止予定（現在v3が推奨）
- 0: **キャッシュ設定** - 適切なキャッシュ戦略が実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] MD5ハッシュ使用箇所を確認し、移行計画の有無を確認
- [ ] CSRF対策の実装状況を追加調査（フォーム処理箇所を確認）
- [ ] 本番環境での性能目標値が別途文書化されているか確認
- [ ] 可用性目標（SLA）が運用契約等で定義されているか確認
- [ ] YouTube API v3への移行計画を確認
- [ ] SQLインジェクション対策の網羅性を確認
