# 非機能要件定義書

## 概要

本ドキュメントは、Legacy CMS（バージョン2.1）の非機能要件を定義するものである。Legacy CMSは、Zend Framework 1.12をベースとしたPHP製コンテンツ管理システムであり、記事、イベント、ページ、リソース、ユーザー管理などの機能を提供する。本書では、コードベースから抽出した性能、可用性、セキュリティ、拡張性、保守性、運用・監視に関する要件を記載する。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| 画面表示 | 明示的な定義なし | コード内に具体的な目標値の設定なし |
| API応答 | 明示的な定義なし | YouTube API等の外部連携はキャッシュで高速化 |
| データベースクエリ | 明示的な定義なし | PDO_MySQLアダプタを使用 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同時接続数 | 明示的な定義なし | PHPセッション管理を使用 |
| 秒間リクエスト数 | 明示的な定義なし | キャッシュ機能により負荷軽減 |
| ページネーション | 15件/ページ | ユーザー一覧等で15件固定 |

### キャッシュ設定

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| キャッシュバックエンド | File | `Zend_Cache::factory('Core', 'File')` |
| キャッシュ保存先 | `../cache` | ファイルシステム上のディレクトリ |
| デフォルトライフタイム | 10秒 | `'lifetime' => 10` |
| 自動シリアライズ | 有効 | `'automatic_serialization' => true` |
| YouTube動画キャッシュ | 10800秒（3時間） | YouTube API呼び出し結果 |
| YouTube単体動画キャッシュ | 86400秒（24時間） | 個別動画情報 |
| YouTubeコメントキャッシュ | 10800秒（3時間） | YouTube コメント取得結果 |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | 明示的な定義なし | コード内に目標値設定なし |
| 計画停止時間 | 明示的な定義なし | サイトステータス機能で「closed」状態をサポート |
| 障害復旧時間（RTO） | 明示的な定義なし | 定義なし |
| 目標復旧時点（RPO） | 明示的な定義なし | 定義なし |

### サイトステータス管理

| 設定項目 | 設定値 | 備考 |
| --- | --- | --- |
| ステータス設定 | `open` / `closed` | `config.ini [status]` セクションで定義 |
| メンテナンスメッセージ | カスタマイズ可能 | `status.message` で設定 |

## セキュリティ要件

### 認証・認可

| 機能 | 実装方式 | 備考 |
| --- | --- | --- |
| 認証方式 | Zend_Auth | データベース認証 |
| 認証アダプタ | Zend_Auth_Adapter_DbTable | MySQLユーザーテーブル参照 |
| パスワード暗号化 | MD5 + サイトキー + ソルト | `MD5(CONCAT(site.key, password, salt))` |
| アクセス制御 | Zend_Acl | ロールベースアクセス制御（RBAC） |
| ロール管理 | データベース管理 | `users_roles` テーブルで管理 |
| リソース権限 | データベース管理 | `users_privileges` テーブルで管理 |

### パスワードポリシー

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| 最小文字数 | 4文字 | ログインバリデーション時の最小長 |
| パスワード強度チェック | 実装あり | `CMS_Password_Strength` クラス |
| 自動生成パスワード | 8文字 | 英数字（一部文字除外）で生成 |

### セッション管理

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| セッション識別子 | PHPSESSID | デフォルトPHPセッション名 |
| セッション管理 | Zend_Session | 名前空間による分離 |
| Cookie設定 | ドメイン別設定 | `site.cookie` で指定 |
| Remember Me機能 | 約3ヶ月 | `time()+7889231` 秒 |

### 通信セキュリティ

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| SMTP通信 | SSL/TLS | ポート465、SSL有効 |
| SMTP認証 | login認証 | `'auth' => 'login'` |

### 入力バリデーション

| 項目 | 実装方式 | 備考 |
| --- | --- | --- |
| フィルタリング | Zend_Filter_Input | StringTrim, StringToLower等 |
| バリデーション | Zend_Validate系 | NotEmpty, EmailAddress, Db_NoRecordExists等 |
| メールアドレス検証 | Zend_Validate_EmailAddress | 形式チェック |
| 重複チェック | Zend_Validate_Db_NoRecordExists | DB問い合わせによる重複防止 |

### 既知のセキュリティ懸念事項

| 懸念事項 | 詳細 | リスクレベル |
| --- | --- | --- |
| MD5ハッシュ使用 | 現代では脆弱とされるハッシュアルゴリズム | 高 |
| ソルト長 | 8文字固定（自動生成パスワードと同様） | 中 |
| SQLインジェクション対策 | パラメータバインディング使用（一部直接連結あり） | 中 |
| CSRF対策 | 明示的なトークン検証なし | 高 |

## 拡張性要件

### アーキテクチャ

| 項目 | 実装方式 | 備考 |
| --- | --- | --- |
| フレームワーク | Zend Framework 1.12.20 | MVCアーキテクチャ |
| モジュール構成 | マルチモジュール | `default`, `admin` モジュール |
| データベース抽象化 | Zend_Db | PDO_MySQL |
| ビュー | Zend_View + カスタムヘルパー | レイアウト機能あり |

### モジュール拡張性

| 項目 | 説明 | 備考 |
| --- | --- | --- |
| コントローラー拡張 | 継承による拡張 | `CMS_Controller_Action_*` 基底クラス |
| ビューヘルパー | カスタムヘルパー追加可能 | `application/helpers`、モジュール別ヘルパー |
| プラグイン | フロントコントローラープラグイン | `Zend_Controller_Plugin_Abstract` 継承 |

### 外部サービス連携

| サービス | 連携方式 | 備考 |
| --- | --- | --- |
| YouTube | Zend_Gdata_YouTube | API v2使用 |
| Google Maps | JavaScript API | APIキー設定あり |
| Google Analytics | トラッキングコード | APIキー設定あり |
| Twitter | 設定ファイルあり | `twitter.ini` |

## 保守性要件

### コード構成

| 項目 | 説明 | 備考 |
| --- | --- | --- |
| ディレクトリ構成 | 標準Zend Framework構成 | application, library, public |
| 設定ファイル | INI形式 | 環境別設定サポート（production/development） |
| 命名規則 | Zend Framework規約 | PSR-0互換 |

### 環境別設定

| 環境 | 特徴 | 備考 |
| --- | --- | --- |
| production | エラー抑制 | `error_reporting(0)` |
| development | 全エラー表示 | `E_ALL \| E_STRICT`、例外スロー有効 |

### 依存関係管理

| ライブラリ | バージョン | 用途 |
| --- | --- | --- |
| zendframework/zendframework1 | 1.12.20 | フレームワーク |
| deresh/thumb | v1.0 | サムネイル生成 |
| james-heinrich/getid3 | v1.9.15 | メタデータ抽出 |

### テスト

| 項目 | 実装状況 | 備考 |
| --- | --- | --- |
| CI/CD | Travis CI | `.travis.yml` で設定 |
| 対応PHPバージョン | 5.2〜7, HHVM | PHP 7とHHVMは失敗許容 |
| テストサービス | memcached | テスト時に使用 |
| データベース | MySQL, PostgreSQL | テスト用DB自動作成 |

## 運用・監視要件

### ログ設定

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| エラーログ | PHP標準 | 環境別でエラー表示切替 |
| アプリケーションログ | 明示的設定なし | 専用ログ機能の実装なし |
| アクセスログ | Webサーバー依存 | Apache/Nginx設定による |

### エラーハンドリング

| 項目 | 実装方式 | 備考 |
| --- | --- | --- |
| エラーコントローラー | モジュール別 | `ErrorController.php` |
| 404エラー | カスタムページ | `notfound` アクション |
| 権限エラー | カスタムページ | `privileges` アクション |
| プラグイン | ErrorSelector | モジュール別エラーハンドリング |

### ファイルストレージ

| 項目 | パス | 備考 |
| --- | --- | --- |
| アセット保存先 | `/srv/legacycms/assets/` | 書き込み権限必須 |
| 検索インデックス | `/srv/legacycms/search/` | Luceneインデックス |
| キャッシュディレクトリ | `../cache` | アプリケーション相対パス |

### メール配信

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| メール送信方式 | SMTP | Zend_Mail_Transport_Smtp |
| SMTPポート | 465 | SSL使用 |
| 認証方式 | login | SMTP認証 |

## 備考

### 制限事項

1. **パフォーマンス要件の未定義**: レスポンスタイム、スループットの具体的な目標値がコード内に定義されていない
2. **可用性目標の未定義**: SLA、稼働率、復旧目標の明示的な定義がない
3. **監視機能の不足**: アプリケーションレベルの監視・アラート機能が実装されていない
4. **レートリミット未実装**: APIリクエストの制限機能が存在しない
5. **タイムアウト設定の未定義**: データベース接続、外部API呼び出しのタイムアウト設定が明示されていない

### 改善推奨事項

1. パスワードハッシュアルゴリズムをbcryptまたはArgon2に移行
2. CSRF対策トークンの導入
3. レートリミット機能の実装
4. 構造化ログ（JSON形式）の導入
5. アプリケーションパフォーマンスモニタリング（APM）の導入
6. データベース接続プーリングの検討
