# LLVM Project

## 概要

LLVM Projectは、高度に最適化されたコンパイラ、オプティマイザ、およびランタイム環境を構築するためのツールキットです。モジュラー設計により、コンパイラ基盤として広く採用されており、C/C++/Objective-C/Fortranなどの言語をサポートする複数のフロントエンドとバックエンドを提供しています。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| コンパイラ基盤（LLVM Core） | 中間表現（IR）の処理、最適化パス、オブジェクトファイル生成、アセンブラ、逆アセンブラ、ビットコードアナライザ |
| C/C++フロントエンド（Clang） | C、C++、Objective-C、Objective-C++のコンパイルおよび静的解析 |
| リンカ（LLD） | ELF、COFF、Mach-O、WebAssemblyなど複数フォーマットに対応したクロスプラットフォームリンカ |
| デバッガ（LLDB） | LLVM/Clangベースの高性能デバッガ |
| Fortranフロントエンド（Flang） | Fortran言語のLLVMベースフロントエンド |
| 中間表現フレームワーク（MLIR） | 多層中間表現によるドメイン固有コンパイラ構築基盤 |
| C++標準ライブラリ（libc++） | モダンC++標準に準拠した標準ライブラリ実装 |
| ランタイムサポート（compiler-rt） | サニタイザ、プロファイラ、ビルトイン関数など |
| 並列処理（OpenMP） | OpenMP規格のランタイムサポート |
| ポリヘドラル最適化（Polly） | ループ最適化のためのポリヘドラルモデル |
| バイナリ最適化（BOLT） | リンク後のバイナリ最適化ツール |

## 技術スタック

### コア

- 言語: C++（C++17準拠）
- ビルドシステム: CMake
- 対応プラットフォーム: Linux、macOS、Windows、FreeBSD、その他多数
- ライセンス: Apache License v2.0 with LLVM Exceptions

### 主要ライブラリ

- TableGen: ドメイン固有言語によるコード生成
- LIT (LLVM Integrated Tester): テストフレームワーク
- FileCheck: テスト出力検証ツール
- GoogleTest: ユニットテストフレームワーク

## ディレクトリ構成

```
llvm-project-main/
├── llvm/                    # LLVM Core（中間表現、最適化、コード生成）
├── clang/                   # Clang C/C++/Objective-Cフロントエンド
├── clang-tools-extra/       # Clang関連の追加ツール
├── lld/                     # LLDリンカ
├── lldb/                    # LLDBデバッガ
├── flang/                   # Flang Fortranフロントエンド
├── flang-rt/                # Flangランタイム
├── mlir/                    # Multi-Level IR
├── libcxx/                  # libc++ C++標準ライブラリ
├── libcxxabi/               # libc++abi
├── libunwind/               # libunwindスタック巻き戻しライブラリ
├── compiler-rt/             # コンパイラランタイム
├── openmp/                  # OpenMPランタイム
├── polly/                   # ポリヘドラル最適化
├── bolt/                    # バイナリ最適化ツール
├── libc/                    # LLVM C標準ライブラリ（開発中）
├── libclc/                  # OpenCL C言語ライブラリ
├── libsycl/                 # SYCLランタイムライブラリ
├── offload/                 # オフロードランタイム
├── orc-rt/                  # ORCランタイム
├── cross-project-tests/     # クロスプロジェクトテスト
├── third-party/             # サードパーティライブラリ
├── cmake/                   # 共通CMakeモジュール
├── runtimes/                # ランタイムビルド設定
├── utils/                   # ユーティリティスクリプト
└── .ci/                     # CI/CD設定
```

## セットアップ

### 必要条件

- CMake 3.20.0以上
- C++17対応コンパイラ（GCC 7.4+、Clang 5.0+、Visual Studio 2019 16.7+）
- Python 3.6以上
- Ninja（推奨）またはMake
- 十分なディスク容量（フルビルドで100GB以上推奨）

### ビルド手順

```bash
# ソースコードの取得
git clone https://github.com/llvm/llvm-project.git
cd llvm-project

# ビルドディレクトリの作成
mkdir build && cd build

# CMake設定（Clangとその他のプロジェクトを有効化）
cmake -G Ninja \
  -DCMAKE_BUILD_TYPE=Release \
  -DLLVM_ENABLE_PROJECTS="clang;lld;lldb" \
  -DLLVM_ENABLE_RUNTIMES="libcxx;libcxxabi;compiler-rt" \
  ../llvm

# ビルド実行
ninja

# インストール（オプション）
ninja install
```

### よく使われるCMakeオプション

| オプション | 説明 |
| --- | --- |
| `LLVM_ENABLE_PROJECTS` | ビルドするプロジェクト（clang, lld, lldb, flang, mlir等） |
| `LLVM_ENABLE_RUNTIMES` | ビルドするランタイム（libcxx, libcxxabi, compiler-rt等） |
| `CMAKE_BUILD_TYPE` | ビルドタイプ（Debug, Release, RelWithDebInfo） |
| `LLVM_TARGETS_TO_BUILD` | ビルドするターゲット（X86, ARM, AArch64等、allで全て） |

## 開発

### コーディングスタイル

- LLVM Coding Standardsに準拠
- clang-formatによる自動フォーマット（設定ファイル: `.clang-format`）
- clang-tidyによる静的解析（設定ファイル: `.clang-tidy`）

### フォーマッタ実行

```bash
# ファイル単位でのフォーマット
clang-format -i path/to/file.cpp

# プロジェクト全体（変更ファイルのみ）
git diff --name-only | xargs clang-format -i
```

### テスト実行

```bash
# LLVMテスト
ninja check-llvm

# Clangテスト
ninja check-clang

# 全てのテスト
ninja check-all
```

### ドキュメント

詳細なドキュメントは以下を参照:
- LLVM公式ドキュメント: https://llvm.org/docs/
- Getting Started: https://llvm.org/docs/GettingStarted.html
- Contributing Guide: https://llvm.org/docs/Contributing.html

### コミュニティ

- LLVM Discourse: https://discourse.llvm.org/
- Discord: https://discord.gg/xS7Z362
- Office Hours: https://llvm.org/docs/GettingInvolved.html#office-hours
