# アーキテクチャ構成図

## 1. システム全体構成図

```mermaid
flowchart TB
    subgraph Sources["ソースコード"]
        C["C/C++/ObjC"]
        Fortran["Fortran"]
        Other["その他言語"]
    end

    subgraph Frontend["Frontend Layer"]
        Clang["Clang<br/>(C/C++/ObjC Frontend)"]
        Flang["Flang<br/>(Fortran Frontend)"]
        OtherFE["Other Frontends"]
    end

    subgraph MiddleEnd["Middle-End Layer"]
        LLVMIR["LLVM IR"]
        MLIR["MLIR<br/>(Multi-Level IR)"]
        Analysis["Analysis Passes"]
        Transforms["Transform Passes"]
        PassMgr["Pass Manager"]
    end

    subgraph Backend["Backend Layer"]
        CodeGen["Code Generation"]
        MC["Machine Code Layer"]
        Target["Target Backends"]
    end

    subgraph Targets["Target Architectures"]
        X86["X86/X64"]
        AArch64["AArch64"]
        RISCV["RISC-V"]
        ARM["ARM"]
        OtherTarget["Others..."]
    end

    subgraph Output["出力"]
        Assembly["Assembly"]
        ObjFile["Object Files"]
        Executable["Executables"]
    end

    subgraph Tools["Development Tools"]
        LLDB["LLDB Debugger"]
        LLD["LLD Linker"]
        Utilities["Utilities<br/>(opt, llc, etc.)"]
    end

    subgraph Runtime["Runtime Libraries"]
        CompilerRT["Compiler-RT"]
        LibCXX["libc++"]
        OpenMP["OpenMP Runtime"]
        Unwind["libunwind"]
    end

    C --> Clang
    Fortran --> Flang
    Other --> OtherFE

    Clang --> LLVMIR
    Flang --> MLIR
    OtherFE --> LLVMIR
    MLIR --> LLVMIR

    LLVMIR --> PassMgr
    PassMgr --> Analysis
    PassMgr --> Transforms
    Analysis --> Transforms
    Transforms --> LLVMIR

    LLVMIR --> CodeGen
    CodeGen --> MC
    MC --> Target

    Target --> X86
    Target --> AArch64
    Target --> RISCV
    Target --> ARM
    Target --> OtherTarget

    X86 --> Assembly
    X86 --> ObjFile
    AArch64 --> Assembly
    AArch64 --> ObjFile

    ObjFile --> LLD
    LLD --> Executable
    Executable --> Runtime
```

## 2. LLVM Core コンポーネント構成図

```mermaid
flowchart LR
    subgraph IR["IR Layer"]
        Module["Module"]
        Function["Function"]
        BasicBlock["BasicBlock"]
        Instruction["Instruction"]
        Value["Value"]
        Type["Type"]
    end

    subgraph Analysis["Analysis Layer"]
        DomTree["Dominator Tree"]
        LoopInfo["Loop Info"]
        AliasAnalysis["Alias Analysis"]
        ScalarEvolution["Scalar Evolution"]
        MemorySSA["Memory SSA"]
    end

    subgraph Transforms["Transform Layer"]
        Scalar["Scalar Opts"]
        IPO["Interprocedural Opts"]
        Vectorize["Vectorization"]
        InstCombine["Inst Combine"]
        LoopOpts["Loop Optimizations"]
    end

    subgraph CodeGen["CodeGen Layer"]
        SelectionDAG["Selection DAG"]
        RegAlloc["Register Allocator"]
        Scheduler["Instruction Scheduler"]
        AsmPrinter["Assembly Printer"]
    end

    subgraph MC["Machine Code Layer"]
        MCInst["MC Instruction"]
        MCStreamer["MC Streamer"]
        MCAssembler["MC Assembler"]
        ObjectWriter["Object Writer"]
    end

    Module --> Function
    Function --> BasicBlock
    BasicBlock --> Instruction
    Instruction --> Value
    Value --> Type

    IR --> Analysis
    Analysis --> Transforms
    Transforms --> CodeGen
    CodeGen --> MC
```

## 3. Clang コンポーネント構成図

```mermaid
flowchart TB
    subgraph Input["入力"]
        SourceFile["Source File"]
    end

    subgraph Preprocessor["Preprocessor"]
        PP["Preprocessor"]
        HeaderSearch["Header Search"]
        MacroExpand["Macro Expansion"]
    end

    subgraph Lexer["Lexical Analysis"]
        Lex["Lexer"]
        Token["Tokens"]
    end

    subgraph Parser["Syntax Analysis"]
        Parse["Parser"]
        AST["Abstract Syntax Tree"]
    end

    subgraph Semantic["Semantic Analysis"]
        Sema["Sema"]
        TypeCheck["Type Checking"]
        NameLookup["Name Lookup"]
        Overload["Overload Resolution"]
    end

    subgraph CodeGenClang["Code Generation"]
        CGModule["CodeGen Module"]
        CGFunction["CodeGen Function"]
        CGExpr["CodeGen Expr"]
    end

    subgraph Output["出力"]
        LLVMIR["LLVM IR"]
    end

    SourceFile --> PP
    PP --> HeaderSearch
    PP --> MacroExpand
    PP --> Lex
    Lex --> Token
    Token --> Parse
    Parse --> AST
    AST --> Sema
    Sema --> TypeCheck
    Sema --> NameLookup
    Sema --> Overload
    Sema --> CGModule
    CGModule --> CGFunction
    CGFunction --> CGExpr
    CGExpr --> LLVMIR
```

## 4. LLD リンカ構成図

```mermaid
flowchart TB
    subgraph Input["入力"]
        ObjFiles["Object Files"]
        Archives["Archives (.a)"]
        SharedLibs["Shared Libraries"]
    end

    subgraph Common["Common Layer"]
        Driver["LLD Driver"]
        SymbolTable["Symbol Table"]
        InputSection["Input Sections"]
    end

    subgraph Formats["Format-Specific Linkers"]
        ELF["ELF Linker<br/>(Linux/BSD)"]
        COFF["COFF Linker<br/>(Windows)"]
        MachO["Mach-O Linker<br/>(macOS)"]
        Wasm["WebAssembly Linker"]
    end

    subgraph Processing["Processing"]
        Relocation["Relocation"]
        GC["Garbage Collection"]
        ICF["Identical Code Folding"]
        LTO["Link-Time Optimization"]
    end

    subgraph Output["出力"]
        Executable["Executable"]
        SharedLib["Shared Library"]
        Relocatable["Relocatable"]
    end

    ObjFiles --> Driver
    Archives --> Driver
    SharedLibs --> Driver

    Driver --> ELF
    Driver --> COFF
    Driver --> MachO
    Driver --> Wasm

    ELF --> SymbolTable
    COFF --> SymbolTable
    MachO --> SymbolTable
    Wasm --> SymbolTable

    SymbolTable --> InputSection
    InputSection --> Relocation
    Relocation --> GC
    GC --> ICF
    ICF --> LTO

    LTO --> Executable
    LTO --> SharedLib
    LTO --> Relocatable
```

## 5. MLIR 構成図

```mermaid
flowchart TB
    subgraph IR["MLIR IR"]
        Operation["Operation"]
        Region["Region"]
        Block["Block"]
        Attribute["Attribute"]
    end

    subgraph Dialects["Dialects"]
        Affine["Affine Dialect"]
        SCF["SCF Dialect"]
        Linalg["Linalg Dialect"]
        GPU["GPU Dialect"]
        Vector["Vector Dialect"]
        LLVMD["LLVM Dialect"]
        Arith["Arith Dialect"]
    end

    subgraph Conversion["Conversion Passes"]
        Lower["Lowering Passes"]
        Bufferize["Bufferization"]
        ToLLVM["Convert to LLVM"]
    end

    subgraph Target["Target"]
        LLVMIR["LLVM IR"]
        SPIRV["SPIR-V"]
    end

    Operation --> Region
    Region --> Block
    Block --> Attribute

    Affine --> Lower
    SCF --> Lower
    Linalg --> Lower
    GPU --> Lower
    Vector --> Lower

    Lower --> Bufferize
    Bufferize --> LLVMD
    LLVMD --> ToLLVM

    ToLLVM --> LLVMIR
    GPU --> SPIRV
```

## 6. Compiler-RT 構成図

```mermaid
flowchart TB
    subgraph Builtins["Builtins"]
        IntOps["Integer Operations"]
        FloatOps["Float Operations"]
        Atomic["Atomic Operations"]
    end

    subgraph Sanitizers["Sanitizers"]
        ASan["AddressSanitizer"]
        TSan["ThreadSanitizer"]
        MSan["MemorySanitizer"]
        UBSan["UndefinedBehaviorSanitizer"]
        LSan["LeakSanitizer"]
        HWASan["Hardware AddressSanitizer"]
    end

    subgraph Profile["Profiling"]
        PGO["PGO Runtime"]
        Coverage["Coverage"]
        MemProf["Memory Profiler"]
    end

    subgraph Fuzzing["Fuzzing"]
        LibFuzzer["LibFuzzer"]
    end

    subgraph XRay["XRay"]
        XRayRT["XRay Runtime"]
    end

    subgraph Common["Sanitizer Common"]
        SanCommon["sanitizer_common"]
        Symbolizer["Symbolizer"]
        Interceptors["Interceptors"]
    end

    ASan --> SanCommon
    TSan --> SanCommon
    MSan --> SanCommon
    UBSan --> SanCommon
    LSan --> SanCommon
    HWASan --> SanCommon

    SanCommon --> Symbolizer
    SanCommon --> Interceptors
```

## 7. ターゲットバックエンド構成図

```mermaid
flowchart TB
    subgraph TargetInfo["Target Info"]
        TargetMachine["Target Machine"]
        DataLayout["Data Layout"]
        TargetTriple["Target Triple"]
    end

    subgraph ISel["Instruction Selection"]
        DAGLower["DAG Lowering"]
        PatternMatch["Pattern Matching"]
        FastISel["Fast ISel"]
        GlobalISel["Global ISel"]
    end

    subgraph RegAlloc["Register Allocation"]
        LiveInterval["Live Intervals"]
        VirtRegRewriter["VirtReg Rewriter"]
        Spiller["Spiller"]
    end

    subgraph Scheduling["Instruction Scheduling"]
        PreRAScheduler["Pre-RA Scheduler"]
        PostRAScheduler["Post-RA Scheduler"]
        HazardRecognizer["Hazard Recognizer"]
    end

    subgraph Emission["Code Emission"]
        MachineInstr["Machine Instructions"]
        MCInst["MC Instructions"]
        AsmPrinter["Assembly Printer"]
        ObjEmitter["Object Emitter"]
    end

    TargetMachine --> DataLayout
    TargetMachine --> TargetTriple

    TargetInfo --> ISel
    DAGLower --> PatternMatch
    PatternMatch --> FastISel
    PatternMatch --> GlobalISel

    ISel --> RegAlloc
    LiveInterval --> VirtRegRewriter
    VirtRegRewriter --> Spiller

    RegAlloc --> Scheduling
    PreRAScheduler --> PostRAScheduler
    PostRAScheduler --> HazardRecognizer

    Scheduling --> Emission
    MachineInstr --> MCInst
    MCInst --> AsmPrinter
    MCInst --> ObjEmitter
```

## 8. パスパイプライン構成図

```mermaid
flowchart LR
    subgraph EarlyPasses["Early Passes"]
        SimplifyCFG["SimplifyCFG"]
        SROA["SROA"]
        EarlyCSE["Early CSE"]
    end

    subgraph LoopPasses["Loop Passes"]
        LICM["LICM"]
        IndVars["IndVars"]
        LoopUnroll["Loop Unroll"]
        LoopVectorize["Loop Vectorize"]
    end

    subgraph ScalarOpts["Scalar Opts"]
        GVN["GVN"]
        DSE["Dead Store Elim"]
        ADCE["Aggressive DCE"]
        InstCombine["Inst Combine"]
    end

    subgraph IPO["Interprocedural Opts"]
        Inliner["Inliner"]
        IPSCCP["IP SCCP"]
        GlobalOpt["Global Opt"]
        DeadArgElim["Dead Arg Elim"]
    end

    subgraph LatePasses["Late Passes"]
        SLPVectorize["SLP Vectorize"]
        CGP["CodeGen Prepare"]
    end

    EarlyPasses --> LoopPasses
    LoopPasses --> ScalarOpts
    ScalarOpts --> IPO
    IPO --> LatePasses
```

## 9. データフロー図

```mermaid
flowchart TB
    subgraph Input["入力データ"]
        Source["Source Code"]
        Headers["Header Files"]
        Libraries["Libraries"]
    end

    subgraph Process["処理フロー"]
        Compile["Compilation"]
        Optimize["Optimization"]
        Generate["Code Generation"]
        Link["Linking"]
    end

    subgraph Intermediate["中間データ"]
        Tokens["Tokens"]
        AST["AST"]
        IR["LLVM IR"]
        MachineCode["Machine Code"]
    end

    subgraph Output["出力データ"]
        Object["Object File"]
        Executable["Executable"]
        Bitcode["Bitcode"]
        Assembly["Assembly"]
    end

    Source --> Tokens
    Headers --> Tokens
    Tokens --> AST
    AST --> IR
    IR --> MachineCode
    MachineCode --> Object

    Object --> Link
    Libraries --> Link
    Link --> Executable

    IR --> Bitcode
    MachineCode --> Assembly
```
