---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **GCPインフラ詳細**：セルフホストランナーの具体的なスペック情報が不足
  2. **監視設計の詳細**：Metricsコンテナの具体的な監視項目が未確認
  3. **バックアップポリシー**：GCSキャッシュのTTL設定が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/premerge.yaml`
- E-02: `.github/workflows/libcxx-build-and-test.yaml`
- E-03: `libcxx/utils/ci/docker/docker-compose.yml`
- E-04: `libcxx/utils/ci/docker/linux-builder-base.dockerfile`
- E-05: `libcxx/utils/ci/docker/linux-builder.dockerfile`
- E-06: `libcxx/utils/ci/docker/android-builder.dockerfile`
- E-07: `.github/workflows/containers/github-action-ci/Dockerfile`
- E-08: `.github/workflows/containers/github-action-ci-windows/Dockerfile`
- E-09: `bolt/utils/docker/Dockerfile`
- E-10: `llvm/utils/docker/debian12/Dockerfile`
- E-11: `.ci/metrics/Dockerfile`
- E-12: `.ci/monolithic-linux.sh`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GitHub Actionsを中心としたCI/CDパイプラインを使用 | E-01, E-02 | ○ |
| C-02 | llvm-premerge-linux-runnersでLinux x86_64ビルドを実行 | E-01 | ○ |
| C-03 | depot-ubuntu-24.04-arm-16でLinux AArch64ビルドを実行 | E-01 | ○ |
| C-04 | llvm-premerge-windows-2022-runnersでWindowsビルドを実行 | E-01 | ○ |
| C-05 | macOS-14, macOS-15でmacOSビルドを実行 | E-01, E-02 | ○ |
| C-06 | Ubuntu 24.04 (Noble)をベースOSとして使用 | E-04, E-07 | ○ |
| C-07 | CMake 3.24.4を使用 | E-04 | ○ |
| C-08 | Ninja 1.12.1-1.13.1を使用 | E-10, E-08 | ○ |
| C-09 | sccache 0.10.0を使用 | E-07, E-08 | ○ |
| C-10 | GitHub Actions Runner 2.331.0を使用 | E-03, E-05, E-08 | ○ |
| C-11 | Visual Studio Build Tools 17を使用 | E-08 | ○ |
| C-12 | LLVM 21.1.8をWindowsで使用 | E-08 | ○ |
| C-13 | Clang 19-22の複数バージョンをサポート | E-04, E-02 | ○ |
| C-14 | GCC 14-16の複数バージョンをサポート | E-04, E-02 | ○ |
| C-15 | GCSをsccacheバックエンドとして使用 | E-01 | ○ |
| C-16 | WebDAVをDepotランナーのキャッシュに使用 | E-01 | ○ |
| C-17 | Buildkiteを使用してAndroidビルドを実行 | E-06 | ○ |
| C-18 | 3段階のテストステージ（stage1, stage2, stage3）を実行 | E-02 | ○ |
| C-19 | ASAN, MSAN, TSAN, UBSANによるサニタイザーテストを実行 | E-02 | ○ |
| C-20 | fail-fast: falseで独立したジョブ実行を確保 | E-01, E-02 | ○ |
| C-21 | Linuxビルドタイムアウト120分 | E-01 | ○ |
| C-22 | Windowsビルドタイムアウト180分 | E-01 | ○ |
| C-23 | セルフホストランナーはGCP上で実行される | E-01（コメント参照） | △ |
| C-24 | Metricsコンテナでメトリクス収集を実施 | E-11 | △ |
| C-25 | GCSキャッシュのTTL管理が設定されている | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **セルフホストランナーのインフラ詳細**: premerge.yamlのコメントでGCPに言及があるが、具体的なインフラ構成（VM/Kubernetes、スペック等）は確認できない
  - 候補：llvm-zorg リポジトリ / LLVM Infrastructure ドキュメント / 外部インフラ管理リポジトリ
- **監視メトリクスの詳細**: metrics.pyの内容が未確認
  - 候補：`.ci/metrics/metrics.py` / requirements.lock.txt
- **GCSキャッシュのTTL設定**: sccacheの設定ファイルまたは環境変数で定義されている可能性があるが、リポジトリ内では確認できない
  - 候補：GCP Console / sccache公式ドキュメント / llvm-zorgリポジトリ

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: セルフホストランナーの詳細が不明なため、インフラコストや可用性の評価が困難
- **0（低リスク）**: Docker イメージの構成は明確に文書化されている
- **0（低リスク）**: CI/CDワークフローの構成は詳細に定義されている
- **1（中リスク）**: 外部サービス（Depot, Buildkite）の可用性・SLAが未確認

## 6) レビュアーチェックリスト（最小）
- [ ] セルフホストランナーの実際のスペックとコストを確認（llvm-zorg参照）
- [ ] GCSキャッシュのTTL設定と容量制限を確認
- [ ] Metricsコンテナが収集するメトリクスの種類を確認
- [ ] 外部サービス（Depot, Buildkite）のSLA・可用性を確認
- [ ] Dockerイメージのバージョン管理ポリシーを確認
- [ ] セキュリティ関連の環境変数（トークン等）の管理方法を確認
