# インフラ構成図

## 全体構成図

```mermaid
flowchart TB
    subgraph GitHub["GitHub"]
        GH_Repo["llvm/llvm-project<br/>Repository"]
        GH_Actions["GitHub Actions"]
        GH_PR["Pull Request"]
        GHCR["GitHub Container Registry<br/>(ghcr.io)"]
    end

    subgraph CI_Runners["CI Runners"]
        subgraph Linux_Runners["Linux Runners"]
            LPL["llvm-premerge-linux-runners<br/>(x86_64, GCP)"]
            LPA["depot-ubuntu-24.04-arm<br/>(AArch64)"]
            LPLC["llvm-premerge-libcxx-runners<br/>(libc++ 専用)"]
        end

        subgraph Windows_Runners["Windows Runners"]
            LPW["llvm-premerge-windows-2022-runners"]
        end

        subgraph macOS_Runners["macOS Runners"]
            MAC14["macos-14"]
            MAC15["macos-15"]
        end
    end

    subgraph Docker_Images["Docker Images"]
        IMG_BASE["libcxx-linux-builder-base<br/>(Ubuntu Noble)"]
        IMG_LINUX["libcxx-linux-builder"]
        IMG_ANDROID["libcxx-android-builder"]
        IMG_CI["github-action-ci<br/>(Ubuntu 24.04)"]
        IMG_WIN["github-action-ci-windows<br/>(Windows Server 2022)"]
    end

    subgraph External_Services["External Services"]
        GCS["Google Cloud Storage<br/>(sccache cache)"]
        BK["Buildkite<br/>(Android CI)"]
        APT_LLVM["apt.llvm.org"]
        CE["Compiler Explorer<br/>Infra"]
    end

    GH_PR --> GH_Actions
    GH_Actions --> LPL
    GH_Actions --> LPA
    GH_Actions --> LPLC
    GH_Actions --> LPW
    GH_Actions --> MAC14
    GH_Actions --> MAC15

    GHCR --> IMG_BASE
    GHCR --> IMG_LINUX
    GHCR --> IMG_ANDROID
    GHCR --> IMG_CI
    GHCR --> IMG_WIN

    IMG_BASE --> IMG_LINUX
    IMG_BASE --> IMG_ANDROID

    LPL -.-> IMG_CI
    LPA -.-> IMG_CI
    LPLC -.-> IMG_LINUX
    LPW -.-> IMG_WIN

    LPL --> GCS
    LPW --> GCS

    IMG_ANDROID --> BK
    IMG_LINUX --> APT_LLVM
    IMG_BASE --> CE
```

## CI/CDパイプライン構成図

```mermaid
flowchart LR
    subgraph Trigger["Trigger Events"]
        PR["Pull Request<br/>(opened/synchronize/reopened)"]
        PUSH["Push<br/>(release branches)"]
        SCHED["Schedule<br/>(nightly)"]
    end

    subgraph Premerge["Premerge CI (premerge.yaml)"]
        direction TB
        PM_Linux["Build and Test Linux<br/>(x86_64 & AArch64)"]
        PM_Win["Build and Test Windows"]
        PM_Mac["MacOS Premerge Checks<br/>(release only)"]
    end

    subgraph LibCXX["libc++ CI (libcxx-build-and-test.yaml)"]
        direction TB
        S1["Stage 1<br/>(smoke tests)"]
        S2["Stage 2<br/>(standard versions)"]
        S3["Stage 3<br/>(special configs)"]
        MAC["macOS Tests"]
        WIN["Windows Tests"]

        S1 --> S2
        S2 --> S3
        S2 --> MAC
        S2 --> WIN
    end

    subgraph Artifacts["Artifacts"]
        RESULTS["test-results.xml"]
        LOGS["Build Logs"]
        CRASH["Crash Diagnostics"]
    end

    PR --> Premerge
    PR --> LibCXX
    PUSH --> Premerge
    SCHED --> LibCXX

    PM_Linux --> RESULTS
    PM_Win --> RESULTS
    S3 --> RESULTS
    MAC --> RESULTS
    WIN --> RESULTS
```

## Docker イメージ階層図

```mermaid
flowchart TB
    subgraph Base_Images["Base Images"]
        UBUNTU["docker.io/library/ubuntu:24.04<br/>(Noble)"]
        DEBIAN["launcher.gcr.io/google/debian12"]
        WINDOWS["mcr.microsoft.com/dotnet/framework/sdk:4.8<br/>-windowsservercore-ltsc2022"]
        PYTHON["docker.io/python:3.12"]
    end

    subgraph LLVM_Images["LLVM Docker Images"]
        direction TB

        subgraph Linux_Chain["Linux Image Chain"]
            BUILDER_BASE["libcxx-linux-builder-base<br/>- Clang 19-22<br/>- GCC 14-16<br/>- CMake 3.24.4<br/>- Ninja"]
            BUILDER["libcxx-linux-builder<br/>+ GitHub Actions Runner"]
            ANDROID["libcxx-android-builder<br/>+ Android SDK/NDK<br/>+ Buildkite Agent"]
        end

        subgraph CI_Images["CI Images"]
            CI_LINUX["github-action-ci<br/>- LLVM 21.1.8<br/>- sccache 0.10.0<br/>+ GitHub Actions Runner"]
            CI_WIN["github-action-ci-windows<br/>- VS Build Tools 17<br/>- Clang 21.1.2<br/>- Ninja 1.13.1"]
        end

        subgraph Utility_Images["Utility Images"]
            METRICS["metrics<br/>(Python 3.12)"]
            BOLT["bolt-builder<br/>(Ubuntu 24.04)"]
            DEBIAN_LLVM["debian12-llvm<br/>(Debian 12)"]
        end
    end

    UBUNTU --> BUILDER_BASE
    BUILDER_BASE --> BUILDER
    BUILDER_BASE --> ANDROID

    UBUNTU --> CI_LINUX
    UBUNTU --> BOLT

    WINDOWS --> CI_WIN

    DEBIAN --> DEBIAN_LLVM

    PYTHON --> METRICS
```

## ビルドキャッシュ構成図

```mermaid
flowchart TB
    subgraph Build_Process["Build Process"]
        CMAKE["CMake Configure"]
        NINJA["Ninja Build"]
        COMPILE["Compile (clang/gcc)"]
    end

    subgraph Cache_Layer["Cache Layer"]
        SCCACHE["sccache<br/>(Compiler Cache)"]
        CCACHE["ccache<br/>(Local Cache)"]
    end

    subgraph Cache_Backends["Cache Backends"]
        GCS["Google Cloud Storage<br/>(llvm-premerge runners)"]
        WEBDAV["WebDAV<br/>(depot runners)"]
        LOCAL["Local Disk<br/>(macOS)"]
    end

    CMAKE --> NINJA
    NINJA --> COMPILE
    COMPILE --> SCCACHE
    COMPILE -.-> CCACHE

    SCCACHE --> GCS
    SCCACHE --> WEBDAV
    CCACHE --> LOCAL

    subgraph Environment["Environment Variables"]
        ENV1["SCCACHE_GCS_BUCKET"]
        ENV2["SCCACHE_GCS_RW_MODE=READ_WRITE"]
        ENV3["SCCACHE_WEBDAV_ENDPOINT"]
        ENV4["SCCACHE_IDLE_TIMEOUT=0"]
    end

    ENV1 -.-> GCS
    ENV3 -.-> WEBDAV
```

## テスト実行環境マトリックス

```mermaid
flowchart TB
    subgraph Compilers["Compilers"]
        CLANG22["Clang 22 (ToT)"]
        CLANG21["Clang 21"]
        CLANG20["Clang 20"]
        GCC15["GCC 15"]
        GCC16["GCC 16"]
    end

    subgraph CXX_Standards["C++ Standards"]
        CXX03["C++03"]
        CXX11["C++11"]
        CXX14["C++14"]
        CXX17["C++17"]
        CXX20["C++20"]
        CXX23["C++23"]
        CXX26["C++26"]
    end

    subgraph Platforms["Platforms"]
        LINUX_X86["Linux x86_64"]
        LINUX_ARM["Linux AArch64"]
        WIN_X64["Windows x64"]
        WIN_ARM["Windows ARM64"]
        MACOS["macOS"]
    end

    subgraph Special_Configs["Special Configurations"]
        ASAN["AddressSanitizer"]
        MSAN["MemorySanitizer"]
        TSAN["ThreadSanitizer"]
        UBSAN["UndefinedBehaviorSanitizer"]
        MODULES["Clang Modules"]
        HARDENING["Hardening Modes"]
    end

    CLANG22 --> CXX03
    CLANG22 --> CXX26
    CLANG21 --> CXX26
    CLANG20 --> CXX26
    GCC15 --> CXX03
    GCC15 --> CXX11

    CXX26 --> LINUX_X86
    CXX26 --> LINUX_ARM
    CXX26 --> WIN_X64
    CXX26 --> MACOS

    LINUX_X86 --> ASAN
    LINUX_X86 --> MSAN
    LINUX_X86 --> TSAN
    LINUX_X86 --> UBSAN
    LINUX_X86 --> MODULES
    LINUX_X86 --> HARDENING
```

## ネットワーク構成図

```mermaid
flowchart TB
    subgraph Internet["Internet"]
        GITHUB_API["GitHub API<br/>(api.github.com)"]
        GITHUB_ACTIONS["GitHub Actions<br/>(actions.github.com)"]
        GHCR_REG["GitHub Container Registry<br/>(ghcr.io)"]
    end

    subgraph GCP["Google Cloud Platform"]
        GCS_BUCKET["GCS Bucket<br/>(sccache)"]

        subgraph Runner_Cluster["LLVM Runner Cluster"]
            RUNNER_POD["Runner Pods<br/>(Kubernetes)"]
        end
    end

    subgraph Depot["Depot Cloud"]
        DEPOT_RUNNERS["ARM64 Runners"]
        DEPOT_CACHE["WebDAV Cache"]
    end

    subgraph External["External Package Sources"]
        APT_LLVM["apt.llvm.org"]
        PYPI["pypi.org"]
        NPM["npmjs.com"]
        CHOCO["chocolatey.org"]
    end

    RUNNER_POD <--> GITHUB_API
    RUNNER_POD <--> GITHUB_ACTIONS
    RUNNER_POD --> GHCR_REG
    RUNNER_POD --> GCS_BUCKET
    RUNNER_POD --> APT_LLVM

    DEPOT_RUNNERS <--> GITHUB_ACTIONS
    DEPOT_RUNNERS --> GHCR_REG
    DEPOT_RUNNERS --> DEPOT_CACHE
```
