# インフラ設計書

## 概要

本ドキュメントは、LLVM Project のCI/CDインフラストラクチャおよび開発環境の構成を記載したインフラ設計書である。LLVM Projectは大規模なコンパイラ基盤プロジェクトであり、GitHub Actions を中心としたCI/CDパイプライン、複数のDockerコンテナによるビルド環境、および複数プラットフォーム（Linux、Windows、macOS）でのテスト実行基盤を持つ。

## システム構成

### 全体構成

LLVM Projectのインフラストラクチャは以下の主要コンポーネントで構成される：

1. **GitHub Actions CI/CD**: プルリクエストおよびプッシュイベントに対する自動ビルド・テスト
2. **Docker コンテナ環境**: 一貫したビルド環境を提供する複数のDockerイメージ
3. **セルフホストランナー**: LLVM組織が管理する専用のCI実行環境
4. **外部CIサービス**: Buildkite（Androidビルド用）
5. **キャッシュインフラ**: sccacheによるビルドキャッシュ（GCS/WebDAV）

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| GitHub Actions Runner (Linux) | Linux x86_64ビルド・テスト | llvm-premerge-linux-runners | 可変（オンデマンド） |
| GitHub Actions Runner (Linux ARM) | Linux AArch64ビルド・テスト | depot-ubuntu-24.04-arm-16 | 可変（オンデマンド） |
| GitHub Actions Runner (Windows) | Windowsビルド・テスト | llvm-premerge-windows-2022-runners | 可変（オンデマンド） |
| GitHub Actions Runner (macOS) | macOSビルド・テスト | macos-14, macos-15 | 可変（オンデマンド） |
| Buildkite Agent | Androidビルド・テスト | libcxx-android-builder | 可変 |
| libc++ CI Runner | libc++専用テスト | llvm-premerge-libcxx-runners | 可変（オンデマンド） |

### ネットワーク構成

- **GitHub Actions**: GitHubが管理するネットワーク内で実行（パブリックインターネット接続あり）
- **セルフホストランナー**: LLVM組織のプライベートインフラ（GCP上）からGitHub APIへ接続
- **Dockerコンテナ**: ブリッジネットワークでホストとの通信
- **外部サービス接続**:
  - GitHub Container Registry (ghcr.io) へのイメージプル
  - Google Cloud Storage (キャッシュ用)
  - apt.llvm.org (LLVMツールチェインのダウンロード)

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Docker | latest | コンテナランタイム |
| Ubuntu | 24.04 (Noble) | ベースOS（Linux CI） |
| Debian | 12 | 代替ベースOS（一部ビルド用） |
| Windows Server | 2022 LTSC | WindowsビルドベースOS |
| CMake | 3.24.4 | ビルドシステム |
| Ninja | 1.12.1 - 1.13.1 | 高速ビルドツール |
| sccache | 0.10.0 | 分散コンパイルキャッシュ |
| ccache | OS標準 | ローカルコンパイルキャッシュ |
| Python | 3.12 | スクリプト・テスト実行 |
| Clang/LLVM | 19-22 (複数バージョン) | C/C++コンパイラ |
| GCC | 14-16 (複数バージョン) | 代替C/C++コンパイラ |
| GitHub Actions Runner | 2.331.0 | CIジョブ実行エージェント |
| Visual Studio Build Tools | 17 (2022) | Windowsビルドツール |
| Xcode | 26.0 | macOSビルドツール |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| GitHub | ソースコード管理・CI/CD | HTTPS/SSH |
| GitHub Container Registry (ghcr.io) | Dockerイメージホスティング | HTTPS |
| Google Cloud Storage | sccacheビルドキャッシュ | HTTPS (gRPC) |
| Depot | ARMビルド用ランナー | HTTPS |
| Buildkite | Androidビルド用CI | HTTPS |
| apt.llvm.org | LLVMパッケージリポジトリ | HTTPS |
| Compiler Explorer Infrastructure | GCCインストール | HTTPS |
| Android NDK/SDK | Androidビルド用ツール | HTTPS |

## スケーリング設計

### CI/CDスケーリング

- **GitHub Actionsホストランナー**:
  - GitHub管理のオートスケーリング
  - 同時実行制御: `concurrency` グループによる重複実行キャンセル

- **セルフホストランナー**:
  - `llvm-premerge-linux-runners`: LLVM組織管理のスケーラブルプール
  - `llvm-premerge-libcxx-runners`: libc++専用のランナープール
  - `llvm-premerge-windows-2022-runners`: Windows専用ランナープール

- **ジョブ並列化**:
  - マトリックスビルドによる複数構成の並列テスト
  - `max-parallel: 8` による並列度制限（stage3）
  - `fail-fast: false` によるジョブ独立性確保

### ビルドキャッシュスケーリング

- **sccache設定**:
  - `SCCACHE_IDLE_TIMEOUT=0`: 長時間ジョブ対応
  - GCS/WebDAV バックエンドによる分散キャッシュ
  - READ_WRITE モードによる双方向キャッシュ

## 可用性設計

### CIパイプラインの冗長性

1. **マルチプラットフォームテスト**:
   - Linux x86_64 / AArch64
   - Windows x64 / ARM64
   - macOS (Intel / Apple Silicon)

2. **複数コンパイラバージョン**:
   - Clang: 19, 20, 21, 22 (ToT)
   - GCC: 14, 15, 16

3. **段階的テスト実行**:
   - stage1: 基本スモークテスト
   - stage2: 標準C++バージョンテスト
   - stage3: 特殊構成テスト（sanitizer、hardening等）

### フェイルオーバー方式

- **アーティファクト保存**: 失敗時もテスト結果・ログを保存
- **continue-on-error**: アーティファクトアップロード失敗時もビルド継続
- **再実行**: 手動またはPR更新による再トリガー

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| Dockerイメージ | ghcr.io へのタグ付きプッシュ | main ブランチプッシュ毎 | 無期限（タグ付き） |
| ビルドアーティファクト | GitHub Actions Artifacts | ビルド毎 | 5日間 |
| sccacheキャッシュ | GCS バケット | 自動 | TTL管理 |
| ソースコード | GitHub リポジトリ | コミット毎 | 無期限 |

## 監視設計

### CI/CD監視

- **GitHub Actions Dashboard**: ワークフロー実行状況の可視化
- **sccache ログ**: `SCCACHE_LOG=info` によるキャッシュヒット率監視
- **テスト結果**: JUnit XML形式でのテスト結果出力（`test-results.xml`）
- **Metricsコンテナ**: `.ci/metrics/` ディレクトリのPythonスクリプトによるメトリクス収集

### アラート

- **プルリクエストステータス**: GitHub PRステータスチェック
- **ビルドコメント**: 自動生成されるビルド結果コメント
- **タイムアウト**: Linux 120分、Windows 180分

## 備考

### Docker イメージ一覧

1. **ghcr.io/llvm/libcxx-linux-builder-base**: libc++ ビルド用ベースイメージ
2. **ghcr.io/llvm/libcxx-linux-builder**: libc++ ビルド用完全イメージ
3. **ghcr.io/llvm/libcxx-android-builder**: Android ビルド用イメージ
4. **github-action-ci**: 汎用CI用イメージ（Ubuntu 24.04ベース）
5. **github-action-ci-windows**: Windows CI用イメージ
6. **bolt/utils/docker**: BOLT ビルド用イメージ

### ビルドシステム要件

- **CMake**: 最小バージョン 3.24.4
- **Ninja**: 推奨ビルドジェネレータ
- **LLD**: 推奨リンカ（`-DLLVM_ENABLE_LLD=ON`）
- **Python 3**: スクリプト実行・テスト用

### 環境変数

| 変数名 | 用途 |
| --- | --- |
| `CC`, `CXX` | コンパイラ指定 |
| `LLVM_SYSROOT` | LLVMツールチェインパス |
| `SCCACHE_GCS_BUCKET` | GCSキャッシュバケット |
| `SCCACHE_WEBDAV_ENDPOINT` | WebDAVキャッシュエンドポイント |
| `GITHUB_TOKEN` | GitHub API認証 |
| `BUILDKITE_AGENT_TOKEN` | Buildkite認証 |
