---
generated_at: 2026-02-01 23:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **セッション管理の該当性**：LLVMがコンパイラツールであることの明確な検証が必要
  2. **CFIバイナリサイズ増加（最大15%）**：Chromium固有のデータの一般化可能性
  3. **GWP-ASanメモリオーバーヘッド（約40KiB）**：設定依存の値の妥当性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `SECURITY.md` - プロジェクトルートのセキュリティポリシー
- E-02: `llvm/docs/Security.rst` - LLVM Security Response Groupの詳細
- E-03: `clang/docs/SafeStack.rst` - SafeStackの設計・実装詳細
- E-04: `llvm/docs/SpeculativeLoadHardening.md` - Spectre緩和技術の詳細
- E-05: `llvm/docs/PointerAuth.md` - Pointer Authenticationの設計
- E-06: `llvm/docs/GwpAsan.rst` - GWP-ASanの設計・使用方法
- E-07: `llvm/docs/ScudoHardenedAllocator.rst` - Scudoアロケータの詳細
- E-08: `clang/docs/ControlFlowIntegrity.rst` - CFIスキームの詳細
- E-09: `llvm/lib/CodeGen/SafeStack.cpp` - SafeStackの実装コード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LLVMツールは悪意のある入力に対して堅牢化されていない | E-01, E-02 | ○ |
| C-02 | セキュリティ報告はGitHubのvulnerability reporting機能を使用 | E-02 | ○ |
| C-03 | LLVM Security Response Groupは信頼されたメンバーで構成 | E-02 | ○ |
| C-04 | デフォルトで90日間のエンバーゴ期間 | E-02 | ○ |
| C-05 | 修正後約14週間で議論を公開 | E-02 | ○ |
| C-06 | セッション管理は該当しない | **根拠なし** | △ |
| C-07 | SafeStackはスタックを2つの領域に分離 | E-03 | ○ |
| C-08 | SafeStackのオーバーヘッドは0.1%未満 | E-03 | ○ |
| C-09 | SafeStackはASLRに依存 | E-03 | ○ |
| C-10 | sigaltstackを使用するハンドラはno_sanitize属性が必要 | E-03 | ○ |
| C-11 | CFI-vcallのオーバーヘッドは1%未満（Chromium） | E-08 | ○ |
| C-12 | CFIによるバイナリサイズ増加は最大15% | E-08 | △ |
| C-13 | kcfiはLTOを必要としない | E-08 | ○ |
| C-14 | CFIはx86, x86_64, arm, aarch64, wasmをサポート | E-08 | ○ |
| C-15 | Speculative Load HardeningはSpectre Variant #1を緩和 | E-04 | ○ |
| C-16 | Load Hardeningはlfenceより1.77x高速 | E-04 | ○ |
| C-17 | Googleマイクロベンチマークでの性能比較データ | E-04 | ○ |
| C-18 | Pointer AuthenticationはAArch64のみサポート | E-05 | ○ |
| C-19 | PAuthは5つのキーを提供 | E-05 | ○ |
| C-20 | llvm.ptrauth.sign intrinsicの存在 | E-05 | ○ |
| C-21 | llvm.ptrauth.auth intrinsicの存在 | E-05 | ○ |
| C-22 | GWP-ASanはサンプリングベースのアロケータ | E-06 | ○ |
| C-23 | GWP-ASanのメモリオーバーヘッドは約40KiB | E-06 | △ |
| C-24 | GWP-ASanはuse-after-freeを検出可能 | E-06 | ○ |
| C-25 | GWP-ASanはheap buffer overflowを検出可能 | E-06 | ○ |
| C-26 | ScudoはFuchsiaとAndroid 11+のデフォルト | E-07 | ○ |
| C-27 | ScudoはCRC32でヘッダーチェックサム検証 | E-07 | ○ |
| C-28 | Scudoはクアランティン機能を持つ | E-07 | ○ |
| C-29 | Scudo SecondaryアロケータはGuard Pagesを使用 | E-07 | ○ |
| C-30 | SafeStackはLinux, NetBSD, FreeBSD, macOSでテスト済み | E-03 | ○ |
| C-31 | コード生成の誤コンパイルはセキュリティ問題になりうる | E-02 | ○ |
| C-32 | サニタイザーは本番用ではないためセキュリティ問題として扱わない | E-02 | ○ |
| C-33 | libc/libc++の未定義動作はセキュリティ問題として扱わない | E-02 | ○ |
| C-34 | アンワインディングは堅牢化されていない | E-02 | ○ |
| C-35 | 透明性レポートは年次で公開 | E-02 | ○ |
| C-36 | Security Response Groupメンバーには機密保持義務がある | E-02 | ○ |
| C-37 | -fsanitize=safe-stackでSafeStackを有効化 | E-03 | ○ |
| C-38 | -fsanitize=cfiでCFIを有効化 | E-08 | ○ |
| C-39 | -fsanitize=scudoでScudoを有効化 | E-07 | ○ |
| C-40 | CFIは-fltoまたは-flto=thinを必要とする | E-08 | ○ |
| C-41 | ptrauth operand bundleは中間ポインタをレジスタに保持 | E-05 | ○ |
| C-42 | llvm.ptrauth.resignは認証と署名を組み合わせる | E-05 | ○ |
| C-43 | ELFでのPAuthリロケーションはR_AARCH64_AUTH_ABS64 | E-05 | ○ |
| C-44 | SafeStackはCode-Pointer Integrityプロジェクトの一部 | E-03 | ○ |
| C-45 | Scudoヘッダーは8バイト | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-06 セッション管理の該当性**
  - コンパイラツールチェーンとしてのLLVMの性質から推論
  - 明示的なドキュメントは存在しない
  - 候補：プロジェクトの性質に関するメタドキュメント / README.md / 公式Webサイト

- **C-12 CFIバイナリサイズ増加（最大15%）**
  - Chromiumでの測定結果であり、一般的な値ではない可能性
  - 候補：他のベンチマークデータ / 追加の性能測定結果

- **C-23 GWP-ASanメモリオーバーヘッド（約40KiB）**
  - デフォルト設定での値であり、設定によって変動
  - 「depending on the average size of your allocations」という記載あり
  - 候補：詳細な設定別メモリ使用量データ

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なセキュリティ機能の説明（SafeStack、CFI、Scudo等）
  - ソースコードとドキュメントの両方で確認可能
- **0（低リスク）**: LLVM Security Response Groupのプロセス
  - Security.rstで詳細に文書化
- **1（中リスク）**: パフォーマンス数値
  - ベンチマーク結果は環境依存の可能性あり
- **0（低リスク）**: コンパイラフラグの記述
  - 公式ドキュメントで明確に定義

## 6) レビュアーチェックリスト（最小）
- [ ] LLVMがコンパイラツールチェーンであり、従来の認証/セッション管理が適用されないことの妥当性を確認
- [ ] CFIのバイナリサイズ増加（最大15%）がChromium固有でないか確認
- [ ] GWP-ASanのメモリオーバーヘッド（約40KiB）がデフォルト設定での値であることを理解
- [ ] Speculative Load Hardeningのパフォーマンスデータが最新かつ一般的に適用可能か確認
- [ ] プラットフォームサポート表が最新のLLVMバージョンを反映しているか確認
- [ ] セキュリティ問題のスコープ定義が現在のLLVMセキュリティポリシーと一致しているか確認
